/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityir.model.SecurityIrRequest;
import software.amazon.awssdk.services.securityir.model.SelfManagedCaseStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCaseStatusRequest
extends SecurityIrRequest
implements ToCopyableBuilder<Builder, UpdateCaseStatusRequest> {
    private static final SdkField<String> CASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("caseId").getter(UpdateCaseStatusRequest.getter(UpdateCaseStatusRequest::caseId)).setter(UpdateCaseStatusRequest.setter(Builder::caseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("caseId").build()}).build();
    private static final SdkField<String> CASE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("caseStatus").getter(UpdateCaseStatusRequest.getter(UpdateCaseStatusRequest::caseStatusAsString)).setter(UpdateCaseStatusRequest.setter(Builder::caseStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_ID_FIELD, CASE_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateCaseStatusRequest.memberNameToFieldInitializer();
    private final String caseId;
    private final String caseStatus;

    private UpdateCaseStatusRequest(BuilderImpl builder) {
        super(builder);
        this.caseId = builder.caseId;
        this.caseStatus = builder.caseStatus;
    }

    public final String caseId() {
        return this.caseId;
    }

    public final SelfManagedCaseStatus caseStatus() {
        return SelfManagedCaseStatus.fromValue(this.caseStatus);
    }

    public final String caseStatusAsString() {
        return this.caseStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.caseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.caseStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCaseStatusRequest)) {
            return false;
        }
        UpdateCaseStatusRequest other = (UpdateCaseStatusRequest)((Object)obj);
        return Objects.equals(this.caseId(), other.caseId()) && Objects.equals(this.caseStatusAsString(), other.caseStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCaseStatusRequest").add("CaseId", (Object)this.caseId()).add("CaseStatus", (Object)this.caseStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "caseId": {
                return Optional.ofNullable(clazz.cast(this.caseId()));
            }
            case "caseStatus": {
                return Optional.ofNullable(clazz.cast(this.caseStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("caseId", CASE_ID_FIELD);
        map.put("caseStatus", CASE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCaseStatusRequest, T> g) {
        return obj -> g.apply((UpdateCaseStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityIrRequest.BuilderImpl
    implements Builder {
        private String caseId;
        private String caseStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCaseStatusRequest model) {
            super(model);
            this.caseId(model.caseId);
            this.caseStatus(model.caseStatus);
        }

        public final String getCaseId() {
            return this.caseId;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final String getCaseStatus() {
            return this.caseStatus;
        }

        public final void setCaseStatus(String caseStatus) {
            this.caseStatus = caseStatus;
        }

        @Override
        public final Builder caseStatus(String caseStatus) {
            this.caseStatus = caseStatus;
            return this;
        }

        @Override
        public final Builder caseStatus(SelfManagedCaseStatus caseStatus) {
            this.caseStatus(caseStatus == null ? null : caseStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCaseStatusRequest build() {
            return new UpdateCaseStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityIrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCaseStatusRequest> {
        public Builder caseId(String var1);

        public Builder caseStatus(String var1);

        public Builder caseStatus(SelfManagedCaseStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

