/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityir.model.ActionType;
import software.amazon.awssdk.services.securityir.model.ExecutionStatus;
import software.amazon.awssdk.services.securityir.model.InvestigationFeedback;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvestigationAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InvestigationAction> {
    private static final SdkField<String> INVESTIGATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("investigationId").getter(InvestigationAction.getter(InvestigationAction::investigationId)).setter(InvestigationAction.setter(Builder::investigationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("investigationId").build()}).build();
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionType").getter(InvestigationAction.getter(InvestigationAction::actionTypeAsString)).setter(InvestigationAction.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(InvestigationAction.getter(InvestigationAction::title)).setter(InvestigationAction.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("content").getter(InvestigationAction.getter(InvestigationAction::content)).setter(InvestigationAction.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(InvestigationAction.getter(InvestigationAction::statusAsString)).setter(InvestigationAction.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdated").getter(InvestigationAction.getter(InvestigationAction::lastUpdated)).setter(InvestigationAction.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build()}).build();
    private static final SdkField<InvestigationFeedback> FEEDBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("feedback").getter(InvestigationAction.getter(InvestigationAction::feedback)).setter(InvestigationAction.setter(Builder::feedback)).constructor(InvestigationFeedback::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("feedback").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVESTIGATION_ID_FIELD, ACTION_TYPE_FIELD, TITLE_FIELD, CONTENT_FIELD, STATUS_FIELD, LAST_UPDATED_FIELD, FEEDBACK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvestigationAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String investigationId;
    private final String actionType;
    private final String title;
    private final String content;
    private final String status;
    private final Instant lastUpdated;
    private final InvestigationFeedback feedback;

    private InvestigationAction(BuilderImpl builder) {
        this.investigationId = builder.investigationId;
        this.actionType = builder.actionType;
        this.title = builder.title;
        this.content = builder.content;
        this.status = builder.status;
        this.lastUpdated = builder.lastUpdated;
        this.feedback = builder.feedback;
    }

    public final String investigationId() {
        return this.investigationId;
    }

    public final ActionType actionType() {
        return ActionType.fromValue(this.actionType);
    }

    public final String actionTypeAsString() {
        return this.actionType;
    }

    public final String title() {
        return this.title;
    }

    public final String content() {
        return this.content;
    }

    public final ExecutionStatus status() {
        return ExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public final InvestigationFeedback feedback() {
        return this.feedback;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.investigationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.feedback());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvestigationAction)) {
            return false;
        }
        InvestigationAction other = (InvestigationAction)obj;
        return Objects.equals(this.investigationId(), other.investigationId()) && Objects.equals(this.actionTypeAsString(), other.actionTypeAsString()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.feedback(), other.feedback());
    }

    public final String toString() {
        return ToString.builder((String)"InvestigationAction").add("InvestigationId", (Object)this.investigationId()).add("ActionType", (Object)this.actionTypeAsString()).add("Title", (Object)this.title()).add("Content", (Object)this.content()).add("Status", (Object)this.statusAsString()).add("LastUpdated", (Object)this.lastUpdated()).add("Feedback", (Object)this.feedback()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "investigationId": {
                return Optional.ofNullable(clazz.cast(this.investigationId()));
            }
            case "actionType": {
                return Optional.ofNullable(clazz.cast(this.actionTypeAsString()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "lastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "feedback": {
                return Optional.ofNullable(clazz.cast(this.feedback()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("investigationId", INVESTIGATION_ID_FIELD);
        map.put("actionType", ACTION_TYPE_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("lastUpdated", LAST_UPDATED_FIELD);
        map.put("feedback", FEEDBACK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvestigationAction, T> g) {
        return obj -> g.apply((InvestigationAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String investigationId;
        private String actionType;
        private String title;
        private String content;
        private String status;
        private Instant lastUpdated;
        private InvestigationFeedback feedback;

        private BuilderImpl() {
        }

        private BuilderImpl(InvestigationAction model) {
            this.investigationId(model.investigationId);
            this.actionType(model.actionType);
            this.title(model.title);
            this.content(model.content);
            this.status(model.status);
            this.lastUpdated(model.lastUpdated);
            this.feedback(model.feedback);
        }

        public final String getInvestigationId() {
            return this.investigationId;
        }

        public final void setInvestigationId(String investigationId) {
            this.investigationId = investigationId;
        }

        @Override
        public final Builder investigationId(String investigationId) {
            this.investigationId = investigationId;
            return this;
        }

        public final String getActionType() {
            return this.actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final InvestigationFeedback.Builder getFeedback() {
            return this.feedback != null ? this.feedback.toBuilder() : null;
        }

        public final void setFeedback(InvestigationFeedback.BuilderImpl feedback) {
            this.feedback = feedback != null ? feedback.build() : null;
        }

        @Override
        public final Builder feedback(InvestigationFeedback feedback) {
            this.feedback = feedback;
            return this;
        }

        public InvestigationAction build() {
            return new InvestigationAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvestigationAction> {
        public Builder investigationId(String var1);

        public Builder actionType(String var1);

        public Builder actionType(ActionType var1);

        public Builder title(String var1);

        public Builder content(String var1);

        public Builder status(String var1);

        public Builder status(ExecutionStatus var1);

        public Builder lastUpdated(Instant var1);

        public Builder feedback(InvestigationFeedback var1);

        default public Builder feedback(Consumer<InvestigationFeedback.Builder> feedback) {
            return this.feedback((InvestigationFeedback)((InvestigationFeedback.Builder)InvestigationFeedback.builder().applyMutation(feedback)).build());
        }
    }
}

