/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>MembershipAccountsConfigurationsUpdate</code>structure represents the configuration updates for member
 * accounts within an Amazon Web Services organization.
 * </p>
 * <p>
 * This structure is used to modify existing account configurations and settings for members in the organization. When
 * applying updates, ensure all required fields are properly specified to maintain account consistency.
 * </p>
 * <p>
 * Key considerations when using this structure:
 * </p>
 * <ul>
 * <li>
 * <p>
 * All configuration changes are validated before being applied
 * </p>
 * </li>
 * <li>
 * <p>
 * Updates are processed asynchronously in the background
 * </p>
 * </li>
 * <li>
 * <p>
 * Configuration changes may take several minutes to propagate across all affected accounts
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MembershipAccountsConfigurationsUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<MembershipAccountsConfigurationsUpdate.Builder, MembershipAccountsConfigurationsUpdate> {
    private static final SdkField<Boolean> COVER_ENTIRE_ORGANIZATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("coverEntireOrganization")
            .getter(getter(MembershipAccountsConfigurationsUpdate::coverEntireOrganization))
            .setter(setter(Builder::coverEntireOrganization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coverEntireOrganization").build())
            .build();

    private static final SdkField<List<String>> ORGANIZATIONAL_UNITS_TO_ADD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("organizationalUnitsToAdd")
            .getter(getter(MembershipAccountsConfigurationsUpdate::organizationalUnitsToAdd))
            .setter(setter(Builder::organizationalUnitsToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationalUnitsToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ORGANIZATIONAL_UNITS_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("organizationalUnitsToRemove")
            .getter(getter(MembershipAccountsConfigurationsUpdate::organizationalUnitsToRemove))
            .setter(setter(Builder::organizationalUnitsToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationalUnitsToRemove")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COVER_ENTIRE_ORGANIZATION_FIELD, ORGANIZATIONAL_UNITS_TO_ADD_FIELD, ORGANIZATIONAL_UNITS_TO_REMOVE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean coverEntireOrganization;

    private final List<String> organizationalUnitsToAdd;

    private final List<String> organizationalUnitsToRemove;

    private MembershipAccountsConfigurationsUpdate(BuilderImpl builder) {
        this.coverEntireOrganization = builder.coverEntireOrganization;
        this.organizationalUnitsToAdd = builder.organizationalUnitsToAdd;
        this.organizationalUnitsToRemove = builder.organizationalUnitsToRemove;
    }

    /**
     * <p>
     * The <code>coverEntireOrganization</code> field is a boolean value that determines whether the membership
     * configuration should be applied across the entire Amazon Web Services Organization.
     * </p>
     * <p>
     * When set to <code>true</code>, the configuration will be applied to all accounts within the organization. When
     * set to <code>false</code>, the configuration will only apply to specifically designated accounts.
     * </p>
     * 
     * @return The <code>coverEntireOrganization</code> field is a boolean value that determines whether the membership
     *         configuration should be applied across the entire Amazon Web Services Organization. </p>
     *         <p>
     *         When set to <code>true</code>, the configuration will be applied to all accounts within the organization.
     *         When set to <code>false</code>, the configuration will only apply to specifically designated accounts.
     */
    public final Boolean coverEntireOrganization() {
        return coverEntireOrganization;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrganizationalUnitsToAdd property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOrganizationalUnitsToAdd() {
        return organizationalUnitsToAdd != null && !(organizationalUnitsToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of organizational unit IDs to add to the membership configuration. Each organizational unit ID must match
     * the pattern <code>ou-[0-9a-z]{4,32}-[a-z0-9]{8,32}</code>.
     * </p>
     * <p>
     * The list must contain between 1 and 5 organizational unit IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrganizationalUnitsToAdd} method.
     * </p>
     * 
     * @return A list of organizational unit IDs to add to the membership configuration. Each organizational unit ID
     *         must match the pattern <code>ou-[0-9a-z]{4,32}-[a-z0-9]{8,32}</code>. </p>
     *         <p>
     *         The list must contain between 1 and 5 organizational unit IDs.
     */
    public final List<String> organizationalUnitsToAdd() {
        return organizationalUnitsToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrganizationalUnitsToRemove property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOrganizationalUnitsToRemove() {
        return organizationalUnitsToRemove != null && !(organizationalUnitsToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of organizational unit IDs to remove from the membership configuration. Each organizational unit ID must
     * match the pattern <code>ou-[0-9a-z]{4,32}-[a-z0-9]{8,32}</code>.
     * </p>
     * <p>
     * The list must contain between 1 and 5 organizational unit IDs per invocation of the API request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrganizationalUnitsToRemove} method.
     * </p>
     * 
     * @return A list of organizational unit IDs to remove from the membership configuration. Each organizational unit
     *         ID must match the pattern <code>ou-[0-9a-z]{4,32}-[a-z0-9]{8,32}</code>. </p>
     *         <p>
     *         The list must contain between 1 and 5 organizational unit IDs per invocation of the API request.
     */
    public final List<String> organizationalUnitsToRemove() {
        return organizationalUnitsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(coverEntireOrganization());
        hashCode = 31 * hashCode + Objects.hashCode(hasOrganizationalUnitsToAdd() ? organizationalUnitsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOrganizationalUnitsToRemove() ? organizationalUnitsToRemove() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MembershipAccountsConfigurationsUpdate)) {
            return false;
        }
        MembershipAccountsConfigurationsUpdate other = (MembershipAccountsConfigurationsUpdate) obj;
        return Objects.equals(coverEntireOrganization(), other.coverEntireOrganization())
                && hasOrganizationalUnitsToAdd() == other.hasOrganizationalUnitsToAdd()
                && Objects.equals(organizationalUnitsToAdd(), other.organizationalUnitsToAdd())
                && hasOrganizationalUnitsToRemove() == other.hasOrganizationalUnitsToRemove()
                && Objects.equals(organizationalUnitsToRemove(), other.organizationalUnitsToRemove());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MembershipAccountsConfigurationsUpdate")
                .add("CoverEntireOrganization", coverEntireOrganization())
                .add("OrganizationalUnitsToAdd", hasOrganizationalUnitsToAdd() ? organizationalUnitsToAdd() : null)
                .add("OrganizationalUnitsToRemove", hasOrganizationalUnitsToRemove() ? organizationalUnitsToRemove() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "coverEntireOrganization":
            return Optional.ofNullable(clazz.cast(coverEntireOrganization()));
        case "organizationalUnitsToAdd":
            return Optional.ofNullable(clazz.cast(organizationalUnitsToAdd()));
        case "organizationalUnitsToRemove":
            return Optional.ofNullable(clazz.cast(organizationalUnitsToRemove()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("coverEntireOrganization", COVER_ENTIRE_ORGANIZATION_FIELD);
        map.put("organizationalUnitsToAdd", ORGANIZATIONAL_UNITS_TO_ADD_FIELD);
        map.put("organizationalUnitsToRemove", ORGANIZATIONAL_UNITS_TO_REMOVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MembershipAccountsConfigurationsUpdate, T> g) {
        return obj -> g.apply((MembershipAccountsConfigurationsUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MembershipAccountsConfigurationsUpdate> {
        /**
         * <p>
         * The <code>coverEntireOrganization</code> field is a boolean value that determines whether the membership
         * configuration should be applied across the entire Amazon Web Services Organization.
         * </p>
         * <p>
         * When set to <code>true</code>, the configuration will be applied to all accounts within the organization.
         * When set to <code>false</code>, the configuration will only apply to specifically designated accounts.
         * </p>
         * 
         * @param coverEntireOrganization
         *        The <code>coverEntireOrganization</code> field is a boolean value that determines whether the
         *        membership configuration should be applied across the entire Amazon Web Services Organization. </p>
         *        <p>
         *        When set to <code>true</code>, the configuration will be applied to all accounts within the
         *        organization. When set to <code>false</code>, the configuration will only apply to specifically
         *        designated accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coverEntireOrganization(Boolean coverEntireOrganization);

        /**
         * <p>
         * A list of organizational unit IDs to add to the membership configuration. Each organizational unit ID must
         * match the pattern <code>ou-[0-9a-z]{4,32}-[a-z0-9]{8,32}</code>.
         * </p>
         * <p>
         * The list must contain between 1 and 5 organizational unit IDs.
         * </p>
         * 
         * @param organizationalUnitsToAdd
         *        A list of organizational unit IDs to add to the membership configuration. Each organizational unit ID
         *        must match the pattern <code>ou-[0-9a-z]{4,32}-[a-z0-9]{8,32}</code>. </p>
         *        <p>
         *        The list must contain between 1 and 5 organizational unit IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitsToAdd(Collection<String> organizationalUnitsToAdd);

        /**
         * <p>
         * A list of organizational unit IDs to add to the membership configuration. Each organizational unit ID must
         * match the pattern <code>ou-[0-9a-z]{4,32}-[a-z0-9]{8,32}</code>.
         * </p>
         * <p>
         * The list must contain between 1 and 5 organizational unit IDs.
         * </p>
         * 
         * @param organizationalUnitsToAdd
         *        A list of organizational unit IDs to add to the membership configuration. Each organizational unit ID
         *        must match the pattern <code>ou-[0-9a-z]{4,32}-[a-z0-9]{8,32}</code>. </p>
         *        <p>
         *        The list must contain between 1 and 5 organizational unit IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitsToAdd(String... organizationalUnitsToAdd);

        /**
         * <p>
         * A list of organizational unit IDs to remove from the membership configuration. Each organizational unit ID
         * must match the pattern <code>ou-[0-9a-z]{4,32}-[a-z0-9]{8,32}</code>.
         * </p>
         * <p>
         * The list must contain between 1 and 5 organizational unit IDs per invocation of the API request.
         * </p>
         * 
         * @param organizationalUnitsToRemove
         *        A list of organizational unit IDs to remove from the membership configuration. Each organizational
         *        unit ID must match the pattern <code>ou-[0-9a-z]{4,32}-[a-z0-9]{8,32}</code>. </p>
         *        <p>
         *        The list must contain between 1 and 5 organizational unit IDs per invocation of the API request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitsToRemove(Collection<String> organizationalUnitsToRemove);

        /**
         * <p>
         * A list of organizational unit IDs to remove from the membership configuration. Each organizational unit ID
         * must match the pattern <code>ou-[0-9a-z]{4,32}-[a-z0-9]{8,32}</code>.
         * </p>
         * <p>
         * The list must contain between 1 and 5 organizational unit IDs per invocation of the API request.
         * </p>
         * 
         * @param organizationalUnitsToRemove
         *        A list of organizational unit IDs to remove from the membership configuration. Each organizational
         *        unit ID must match the pattern <code>ou-[0-9a-z]{4,32}-[a-z0-9]{8,32}</code>. </p>
         *        <p>
         *        The list must contain between 1 and 5 organizational unit IDs per invocation of the API request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitsToRemove(String... organizationalUnitsToRemove);
    }

    static final class BuilderImpl implements Builder {
        private Boolean coverEntireOrganization;

        private List<String> organizationalUnitsToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<String> organizationalUnitsToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MembershipAccountsConfigurationsUpdate model) {
            coverEntireOrganization(model.coverEntireOrganization);
            organizationalUnitsToAdd(model.organizationalUnitsToAdd);
            organizationalUnitsToRemove(model.organizationalUnitsToRemove);
        }

        public final Boolean getCoverEntireOrganization() {
            return coverEntireOrganization;
        }

        public final void setCoverEntireOrganization(Boolean coverEntireOrganization) {
            this.coverEntireOrganization = coverEntireOrganization;
        }

        @Override
        public final Builder coverEntireOrganization(Boolean coverEntireOrganization) {
            this.coverEntireOrganization = coverEntireOrganization;
            return this;
        }

        public final Collection<String> getOrganizationalUnitsToAdd() {
            if (organizationalUnitsToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return organizationalUnitsToAdd;
        }

        public final void setOrganizationalUnitsToAdd(Collection<String> organizationalUnitsToAdd) {
            this.organizationalUnitsToAdd = MembershipAccountsConfigurationsUpdateOrganizationalUnitsToAddListCopier
                    .copy(organizationalUnitsToAdd);
        }

        @Override
        public final Builder organizationalUnitsToAdd(Collection<String> organizationalUnitsToAdd) {
            this.organizationalUnitsToAdd = MembershipAccountsConfigurationsUpdateOrganizationalUnitsToAddListCopier
                    .copy(organizationalUnitsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnitsToAdd(String... organizationalUnitsToAdd) {
            organizationalUnitsToAdd(Arrays.asList(organizationalUnitsToAdd));
            return this;
        }

        public final Collection<String> getOrganizationalUnitsToRemove() {
            if (organizationalUnitsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return organizationalUnitsToRemove;
        }

        public final void setOrganizationalUnitsToRemove(Collection<String> organizationalUnitsToRemove) {
            this.organizationalUnitsToRemove = MembershipAccountsConfigurationsUpdateOrganizationalUnitsToRemoveListCopier
                    .copy(organizationalUnitsToRemove);
        }

        @Override
        public final Builder organizationalUnitsToRemove(Collection<String> organizationalUnitsToRemove) {
            this.organizationalUnitsToRemove = MembershipAccountsConfigurationsUpdateOrganizationalUnitsToRemoveListCopier
                    .copy(organizationalUnitsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnitsToRemove(String... organizationalUnitsToRemove) {
            organizationalUnitsToRemove(Arrays.asList(organizationalUnitsToRemove));
            return this;
        }

        @Override
        public MembershipAccountsConfigurationsUpdate build() {
            return new MembershipAccountsConfigurationsUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
