/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an investigation action performed within a case. This structure captures the details of an automated or
 * manual investigation, including its status, results, and user feedback.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvestigationAction implements SdkPojo, Serializable,
        ToCopyableBuilder<InvestigationAction.Builder, InvestigationAction> {
    private static final SdkField<String> INVESTIGATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("investigationId").getter(getter(InvestigationAction::investigationId))
            .setter(setter(Builder::investigationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("investigationId").build()).build();

    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionType").getter(getter(InvestigationAction::actionTypeAsString)).setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(InvestigationAction::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("content")
            .getter(getter(InvestigationAction::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(InvestigationAction::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdated").getter(getter(InvestigationAction::lastUpdated)).setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build()).build();

    private static final SdkField<InvestigationFeedback> FEEDBACK_FIELD = SdkField
            .<InvestigationFeedback> builder(MarshallingType.SDK_POJO).memberName("feedback")
            .getter(getter(InvestigationAction::feedback)).setter(setter(Builder::feedback))
            .constructor(InvestigationFeedback::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("feedback").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVESTIGATION_ID_FIELD,
            ACTION_TYPE_FIELD, TITLE_FIELD, CONTENT_FIELD, STATUS_FIELD, LAST_UPDATED_FIELD, FEEDBACK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String investigationId;

    private final String actionType;

    private final String title;

    private final String content;

    private final String status;

    private final Instant lastUpdated;

    private final InvestigationFeedback feedback;

    private InvestigationAction(BuilderImpl builder) {
        this.investigationId = builder.investigationId;
        this.actionType = builder.actionType;
        this.title = builder.title;
        this.content = builder.content;
        this.status = builder.status;
        this.lastUpdated = builder.lastUpdated;
        this.feedback = builder.feedback;
    }

    /**
     * <p>
     * The unique identifier for this investigation action. This ID is used to track and reference the specific
     * investigation throughout its lifecycle.
     * </p>
     * 
     * @return The unique identifier for this investigation action. This ID is used to track and reference the specific
     *         investigation throughout its lifecycle.
     */
    public final String investigationId() {
        return investigationId;
    }

    /**
     * <p>
     * The type of investigation action being performed. This categorizes the investigation method or approach used in
     * the case.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The type of investigation action being performed. This categorizes the investigation method or approach
     *         used in the case.
     * @see ActionType
     */
    public final ActionType actionType() {
        return ActionType.fromValue(actionType);
    }

    /**
     * <p>
     * The type of investigation action being performed. This categorizes the investigation method or approach used in
     * the case.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The type of investigation action being performed. This categorizes the investigation method or approach
     *         used in the case.
     * @see ActionType
     */
    public final String actionTypeAsString() {
        return actionType;
    }

    /**
     * <p>
     * Human-readable summary of the investigation focus. This provides a brief description of what the investigation is
     * examining or analyzing.
     * </p>
     * 
     * @return Human-readable summary of the investigation focus. This provides a brief description of what the
     *         investigation is examining or analyzing.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * Detailed investigation results in rich markdown format. This field contains the comprehensive findings, analysis,
     * and conclusions from the investigation.
     * </p>
     * 
     * @return Detailed investigation results in rich markdown format. This field contains the comprehensive findings,
     *         analysis, and conclusions from the investigation.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The current execution status of the investigation. This indicates whether the investigation is pending, in
     * progress, completed, or failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current execution status of the investigation. This indicates whether the investigation is pending,
     *         in progress, completed, or failed.
     * @see ExecutionStatus
     */
    public final ExecutionStatus status() {
        return ExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current execution status of the investigation. This indicates whether the investigation is pending, in
     * progress, completed, or failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current execution status of the investigation. This indicates whether the investigation is pending,
     *         in progress, completed, or failed.
     * @see ExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * ISO 8601 timestamp of the most recent status update. This indicates when the investigation was last modified or
     * when its status last changed.
     * </p>
     * 
     * @return ISO 8601 timestamp of the most recent status update. This indicates when the investigation was last
     *         modified or when its status last changed.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * <p>
     * User feedback for this investigation result. This contains the user's assessment and comments about the quality
     * and usefulness of the investigation findings.
     * </p>
     * 
     * @return User feedback for this investigation result. This contains the user's assessment and comments about the
     *         quality and usefulness of the investigation findings.
     */
    public final InvestigationFeedback feedback() {
        return feedback;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(investigationId());
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(feedback());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvestigationAction)) {
            return false;
        }
        InvestigationAction other = (InvestigationAction) obj;
        return Objects.equals(investigationId(), other.investigationId())
                && Objects.equals(actionTypeAsString(), other.actionTypeAsString()) && Objects.equals(title(), other.title())
                && Objects.equals(content(), other.content()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lastUpdated(), other.lastUpdated()) && Objects.equals(feedback(), other.feedback());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvestigationAction").add("InvestigationId", investigationId())
                .add("ActionType", actionTypeAsString()).add("Title", title()).add("Content", content())
                .add("Status", statusAsString()).add("LastUpdated", lastUpdated()).add("Feedback", feedback()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "investigationId":
            return Optional.ofNullable(clazz.cast(investigationId()));
        case "actionType":
            return Optional.ofNullable(clazz.cast(actionTypeAsString()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "lastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "feedback":
            return Optional.ofNullable(clazz.cast(feedback()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("investigationId", INVESTIGATION_ID_FIELD);
        map.put("actionType", ACTION_TYPE_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("lastUpdated", LAST_UPDATED_FIELD);
        map.put("feedback", FEEDBACK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvestigationAction, T> g) {
        return obj -> g.apply((InvestigationAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvestigationAction> {
        /**
         * <p>
         * The unique identifier for this investigation action. This ID is used to track and reference the specific
         * investigation throughout its lifecycle.
         * </p>
         * 
         * @param investigationId
         *        The unique identifier for this investigation action. This ID is used to track and reference the
         *        specific investigation throughout its lifecycle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder investigationId(String investigationId);

        /**
         * <p>
         * The type of investigation action being performed. This categorizes the investigation method or approach used
         * in the case.
         * </p>
         * 
         * @param actionType
         *        The type of investigation action being performed. This categorizes the investigation method or
         *        approach used in the case.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * The type of investigation action being performed. This categorizes the investigation method or approach used
         * in the case.
         * </p>
         * 
         * @param actionType
         *        The type of investigation action being performed. This categorizes the investigation method or
         *        approach used in the case.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(ActionType actionType);

        /**
         * <p>
         * Human-readable summary of the investigation focus. This provides a brief description of what the
         * investigation is examining or analyzing.
         * </p>
         * 
         * @param title
         *        Human-readable summary of the investigation focus. This provides a brief description of what the
         *        investigation is examining or analyzing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * Detailed investigation results in rich markdown format. This field contains the comprehensive findings,
         * analysis, and conclusions from the investigation.
         * </p>
         * 
         * @param content
         *        Detailed investigation results in rich markdown format. This field contains the comprehensive
         *        findings, analysis, and conclusions from the investigation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The current execution status of the investigation. This indicates whether the investigation is pending, in
         * progress, completed, or failed.
         * </p>
         * 
         * @param status
         *        The current execution status of the investigation. This indicates whether the investigation is
         *        pending, in progress, completed, or failed.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current execution status of the investigation. This indicates whether the investigation is pending, in
         * progress, completed, or failed.
         * </p>
         * 
         * @param status
         *        The current execution status of the investigation. This indicates whether the investigation is
         *        pending, in progress, completed, or failed.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(ExecutionStatus status);

        /**
         * <p>
         * ISO 8601 timestamp of the most recent status update. This indicates when the investigation was last modified
         * or when its status last changed.
         * </p>
         * 
         * @param lastUpdated
         *        ISO 8601 timestamp of the most recent status update. This indicates when the investigation was last
         *        modified or when its status last changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * <p>
         * User feedback for this investigation result. This contains the user's assessment and comments about the
         * quality and usefulness of the investigation findings.
         * </p>
         * 
         * @param feedback
         *        User feedback for this investigation result. This contains the user's assessment and comments about
         *        the quality and usefulness of the investigation findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder feedback(InvestigationFeedback feedback);

        /**
         * <p>
         * User feedback for this investigation result. This contains the user's assessment and comments about the
         * quality and usefulness of the investigation findings.
         * </p>
         * This is a convenience method that creates an instance of the {@link InvestigationFeedback.Builder} avoiding
         * the need to create one manually via {@link InvestigationFeedback#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InvestigationFeedback.Builder#build()} is called immediately and
         * its result is passed to {@link #feedback(InvestigationFeedback)}.
         * 
         * @param feedback
         *        a consumer that will call methods on {@link InvestigationFeedback.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #feedback(InvestigationFeedback)
         */
        default Builder feedback(Consumer<InvestigationFeedback.Builder> feedback) {
            return feedback(InvestigationFeedback.builder().applyMutation(feedback).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String investigationId;

        private String actionType;

        private String title;

        private String content;

        private String status;

        private Instant lastUpdated;

        private InvestigationFeedback feedback;

        private BuilderImpl() {
        }

        private BuilderImpl(InvestigationAction model) {
            investigationId(model.investigationId);
            actionType(model.actionType);
            title(model.title);
            content(model.content);
            status(model.status);
            lastUpdated(model.lastUpdated);
            feedback(model.feedback);
        }

        public final String getInvestigationId() {
            return investigationId;
        }

        public final void setInvestigationId(String investigationId) {
            this.investigationId = investigationId;
        }

        @Override
        public final Builder investigationId(String investigationId) {
            this.investigationId = investigationId;
            return this;
        }

        public final String getActionType() {
            return actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final InvestigationFeedback.Builder getFeedback() {
            return feedback != null ? feedback.toBuilder() : null;
        }

        public final void setFeedback(InvestigationFeedback.BuilderImpl feedback) {
            this.feedback = feedback != null ? feedback.build() : null;
        }

        @Override
        public final Builder feedback(InvestigationFeedback feedback) {
            this.feedback = feedback;
            return this;
        }

        @Override
        public InvestigationAction build() {
            return new InvestigationAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
