/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IncidentResponder implements SdkPojo, Serializable,
        ToCopyableBuilder<IncidentResponder.Builder, IncidentResponder> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(IncidentResponder::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> JOB_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobTitle").getter(getter(IncidentResponder::jobTitle)).setter(setter(Builder::jobTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTitle").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("email")
            .getter(getter(IncidentResponder::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()).build();

    private static final SdkField<List<String>> COMMUNICATION_PREFERENCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("communicationPreferences")
            .getter(getter(IncidentResponder::communicationPreferencesAsStrings))
            .setter(setter(Builder::communicationPreferencesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("communicationPreferences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, JOB_TITLE_FIELD,
            EMAIL_FIELD, COMMUNICATION_PREFERENCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String jobTitle;

    private final String email;

    private final List<String> communicationPreferences;

    private IncidentResponder(BuilderImpl builder) {
        this.name = builder.name;
        this.jobTitle = builder.jobTitle;
        this.email = builder.email;
        this.communicationPreferences = builder.communicationPreferences;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String name() {
        return name;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String jobTitle() {
        return jobTitle;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String email() {
        return email;
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCommunicationPreferences} method.
     * </p>
     * 
     * @return
     */
    public final List<CommunicationType> communicationPreferences() {
        return CommunicationPreferencesCopier.copyStringToEnum(communicationPreferences);
    }

    /**
     * For responses, this returns true if the service returned a value for the CommunicationPreferences property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCommunicationPreferences() {
        return communicationPreferences != null && !(communicationPreferences instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCommunicationPreferences} method.
     * </p>
     * 
     * @return
     */
    public final List<String> communicationPreferencesAsStrings() {
        return communicationPreferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(jobTitle());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(hasCommunicationPreferences() ? communicationPreferencesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncidentResponder)) {
            return false;
        }
        IncidentResponder other = (IncidentResponder) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(jobTitle(), other.jobTitle())
                && Objects.equals(email(), other.email()) && hasCommunicationPreferences() == other.hasCommunicationPreferences()
                && Objects.equals(communicationPreferencesAsStrings(), other.communicationPreferencesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IncidentResponder").add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("JobTitle", jobTitle() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Email", email() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CommunicationPreferences", hasCommunicationPreferences() ? communicationPreferencesAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "jobTitle":
            return Optional.ofNullable(clazz.cast(jobTitle()));
        case "email":
            return Optional.ofNullable(clazz.cast(email()));
        case "communicationPreferences":
            return Optional.ofNullable(clazz.cast(communicationPreferencesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("jobTitle", JOB_TITLE_FIELD);
        map.put("email", EMAIL_FIELD);
        map.put("communicationPreferences", COMMUNICATION_PREFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IncidentResponder, T> g) {
        return obj -> g.apply((IncidentResponder) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IncidentResponder> {
        /**
         * <p/>
         * 
         * @param name
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p/>
         * 
         * @param jobTitle
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTitle(String jobTitle);

        /**
         * <p/>
         * 
         * @param email
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p/>
         * 
         * @param communicationPreferences
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder communicationPreferencesWithStrings(Collection<String> communicationPreferences);

        /**
         * <p/>
         * 
         * @param communicationPreferences
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder communicationPreferencesWithStrings(String... communicationPreferences);

        /**
         * <p/>
         * 
         * @param communicationPreferences
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder communicationPreferences(Collection<CommunicationType> communicationPreferences);

        /**
         * <p/>
         * 
         * @param communicationPreferences
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder communicationPreferences(CommunicationType... communicationPreferences);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String jobTitle;

        private String email;

        private List<String> communicationPreferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IncidentResponder model) {
            name(model.name);
            jobTitle(model.jobTitle);
            email(model.email);
            communicationPreferencesWithStrings(model.communicationPreferences);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getJobTitle() {
            return jobTitle;
        }

        public final void setJobTitle(String jobTitle) {
            this.jobTitle = jobTitle;
        }

        @Override
        public final Builder jobTitle(String jobTitle) {
            this.jobTitle = jobTitle;
            return this;
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final Collection<String> getCommunicationPreferences() {
            if (communicationPreferences instanceof SdkAutoConstructList) {
                return null;
            }
            return communicationPreferences;
        }

        public final void setCommunicationPreferences(Collection<String> communicationPreferences) {
            this.communicationPreferences = CommunicationPreferencesCopier.copy(communicationPreferences);
        }

        @Override
        public final Builder communicationPreferencesWithStrings(Collection<String> communicationPreferences) {
            this.communicationPreferences = CommunicationPreferencesCopier.copy(communicationPreferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder communicationPreferencesWithStrings(String... communicationPreferences) {
            communicationPreferencesWithStrings(Arrays.asList(communicationPreferences));
            return this;
        }

        @Override
        public final Builder communicationPreferences(Collection<CommunicationType> communicationPreferences) {
            this.communicationPreferences = CommunicationPreferencesCopier.copyEnumToString(communicationPreferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder communicationPreferences(CommunicationType... communicationPreferences) {
            communicationPreferences(Arrays.asList(communicationPreferences));
            return this;
        }

        @Override
        public IncidentResponder build() {
            return new IncidentResponder(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
