/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.endpoints;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The parameters object used to resolve an endpoint for the SecurityIr service.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public final class SecurityIrEndpointParams implements
        ToCopyableBuilder<SecurityIrEndpointParams.Builder, SecurityIrEndpointParams> {
    private final Boolean useFIPS;

    private final String endpoint;

    private final Region region;

    private SecurityIrEndpointParams(BuilderImpl builder) {
        this.useFIPS = builder.useFIPS;
        this.endpoint = builder.endpoint;
        this.region = builder.region;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Boolean useFips() {
        return useFIPS;
    }

    public String endpoint() {
        return endpoint;
    }

    public Region region() {
        return region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public interface Builder extends CopyableBuilder<Builder, SecurityIrEndpointParams> {
        Builder useFips(Boolean useFIPS);

        Builder endpoint(String endpoint);

        Builder region(Region region);

        SecurityIrEndpointParams build();
    }

    private static class BuilderImpl implements Builder {
        private Boolean useFIPS = false;

        private String endpoint;

        private Region region;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityIrEndpointParams builder) {
            this.useFIPS = builder.useFIPS;
            this.endpoint = builder.endpoint;
            this.region = builder.region;
        }

        @Override
        public Builder useFips(Boolean useFIPS) {
            this.useFIPS = useFIPS;
            if (this.useFIPS == null) {
                this.useFIPS = false;
            }
            return this;
        }

        @Override
        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public SecurityIrEndpointParams build() {
            return new SecurityIrEndpointParams(this);
        }
    }
}
