/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClient;
import software.amazon.awssdk.services.securityhub.model.GetInsightsRequest;
import software.amazon.awssdk.services.securityhub.model.GetInsightsResponse;

public class GetInsightsPublisher
implements SdkPublisher<GetInsightsResponse> {
    private final SecurityHubAsyncClient client;
    private final GetInsightsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetInsightsPublisher(SecurityHubAsyncClient client, GetInsightsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetInsightsPublisher(SecurityHubAsyncClient client, GetInsightsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetInsightsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetInsightsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetInsightsResponseFetcher
    implements AsyncPageFetcher<GetInsightsResponse> {
        private GetInsightsResponseFetcher() {
        }

        public boolean hasNextPage(GetInsightsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetInsightsResponse> nextPage(GetInsightsResponse previousPage) {
            if (previousPage == null) {
                return GetInsightsPublisher.this.client.getInsights(GetInsightsPublisher.this.firstRequest);
            }
            return GetInsightsPublisher.this.client.getInsights((GetInsightsRequest)((Object)GetInsightsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

