/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClient;
import software.amazon.awssdk.services.securityhub.model.ListProductSubscribersRequest;
import software.amazon.awssdk.services.securityhub.model.ListProductSubscribersResponse;

public class ListProductSubscribersPublisher
implements SdkPublisher<ListProductSubscribersResponse> {
    private final SecurityHubAsyncClient client;
    private final ListProductSubscribersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProductSubscribersPublisher(SecurityHubAsyncClient client, ListProductSubscribersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProductSubscribersPublisher(SecurityHubAsyncClient client, ListProductSubscribersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProductSubscribersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProductSubscribersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListProductSubscribersResponseFetcher
    implements AsyncPageFetcher<ListProductSubscribersResponse> {
        private ListProductSubscribersResponseFetcher() {
        }

        public boolean hasNextPage(ListProductSubscribersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProductSubscribersResponse> nextPage(ListProductSubscribersResponse previousPage) {
            if (previousPage == null) {
                return ListProductSubscribersPublisher.this.client.listProductSubscribers(ListProductSubscribersPublisher.this.firstRequest);
            }
            return ListProductSubscribersPublisher.this.client.listProductSubscribers((ListProductSubscribersRequest)((Object)ListProductSubscribersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

