/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ThreatIntelIndicatorType {
    DOMAIN("DOMAIN"),
    EMAIL_ADDRESS("EMAIL_ADDRESS"),
    HASH_MD5("HASH_MD5"),
    HASH_SHA1("HASH_SHA1"),
    HASH_SHA256("HASH_SHA256"),
    HASH_SHA512("HASH_SHA512"),
    IPV4_ADDRESS("IPV4_ADDRESS"),
    IPV6_ADDRESS("IPV6_ADDRESS"),
    MUTEX("MUTEX"),
    PROCESS("PROCESS"),
    URL("URL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ThreatIntelIndicatorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ThreatIntelIndicatorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ThreatIntelIndicatorType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ThreatIntelIndicatorType> knownValues() {
        return Stream.of(ThreatIntelIndicatorType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

