/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsV2ProcessedFinding;
import software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsV2ProcessedFindingsListCopier;
import software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsV2UnprocessedFinding;
import software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsV2UnprocessedFindingsListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateFindingsV2Response
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, BatchUpdateFindingsV2Response> {
    private static final SdkField<List<BatchUpdateFindingsV2ProcessedFinding>> PROCESSED_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProcessedFindings").getter(BatchUpdateFindingsV2Response.getter(BatchUpdateFindingsV2Response::processedFindings)).setter(BatchUpdateFindingsV2Response.setter(Builder::processedFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedFindings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchUpdateFindingsV2ProcessedFinding::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchUpdateFindingsV2UnprocessedFinding>> UNPROCESSED_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedFindings").getter(BatchUpdateFindingsV2Response.getter(BatchUpdateFindingsV2Response::unprocessedFindings)).setter(BatchUpdateFindingsV2Response.setter(Builder::unprocessedFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedFindings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchUpdateFindingsV2UnprocessedFinding::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESSED_FINDINGS_FIELD, UNPROCESSED_FINDINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchUpdateFindingsV2Response.memberNameToFieldInitializer();
    private final List<BatchUpdateFindingsV2ProcessedFinding> processedFindings;
    private final List<BatchUpdateFindingsV2UnprocessedFinding> unprocessedFindings;

    private BatchUpdateFindingsV2Response(BuilderImpl builder) {
        super(builder);
        this.processedFindings = builder.processedFindings;
        this.unprocessedFindings = builder.unprocessedFindings;
    }

    public final boolean hasProcessedFindings() {
        return this.processedFindings != null && !(this.processedFindings instanceof SdkAutoConstructList);
    }

    public final List<BatchUpdateFindingsV2ProcessedFinding> processedFindings() {
        return this.processedFindings;
    }

    public final boolean hasUnprocessedFindings() {
        return this.unprocessedFindings != null && !(this.unprocessedFindings instanceof SdkAutoConstructList);
    }

    public final List<BatchUpdateFindingsV2UnprocessedFinding> unprocessedFindings() {
        return this.unprocessedFindings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProcessedFindings() ? this.processedFindings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedFindings() ? this.unprocessedFindings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateFindingsV2Response)) {
            return false;
        }
        BatchUpdateFindingsV2Response other = (BatchUpdateFindingsV2Response)((Object)obj);
        return this.hasProcessedFindings() == other.hasProcessedFindings() && Objects.equals(this.processedFindings(), other.processedFindings()) && this.hasUnprocessedFindings() == other.hasUnprocessedFindings() && Objects.equals(this.unprocessedFindings(), other.unprocessedFindings());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateFindingsV2Response").add("ProcessedFindings", this.hasProcessedFindings() ? this.processedFindings() : null).add("UnprocessedFindings", this.hasUnprocessedFindings() ? this.unprocessedFindings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProcessedFindings": {
                return Optional.ofNullable(clazz.cast(this.processedFindings()));
            }
            case "UnprocessedFindings": {
                return Optional.ofNullable(clazz.cast(this.unprocessedFindings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProcessedFindings", PROCESSED_FINDINGS_FIELD);
        map.put("UnprocessedFindings", UNPROCESSED_FINDINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateFindingsV2Response, T> g) {
        return obj -> g.apply((BatchUpdateFindingsV2Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<BatchUpdateFindingsV2ProcessedFinding> processedFindings = DefaultSdkAutoConstructList.getInstance();
        private List<BatchUpdateFindingsV2UnprocessedFinding> unprocessedFindings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateFindingsV2Response model) {
            super(model);
            this.processedFindings(model.processedFindings);
            this.unprocessedFindings(model.unprocessedFindings);
        }

        public final List<BatchUpdateFindingsV2ProcessedFinding.Builder> getProcessedFindings() {
            List<BatchUpdateFindingsV2ProcessedFinding.Builder> result = BatchUpdateFindingsV2ProcessedFindingsListCopier.copyToBuilder(this.processedFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessedFindings(Collection<BatchUpdateFindingsV2ProcessedFinding.BuilderImpl> processedFindings) {
            this.processedFindings = BatchUpdateFindingsV2ProcessedFindingsListCopier.copyFromBuilder(processedFindings);
        }

        @Override
        public final Builder processedFindings(Collection<BatchUpdateFindingsV2ProcessedFinding> processedFindings) {
            this.processedFindings = BatchUpdateFindingsV2ProcessedFindingsListCopier.copy(processedFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedFindings(BatchUpdateFindingsV2ProcessedFinding ... processedFindings) {
            this.processedFindings(Arrays.asList(processedFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedFindings(Consumer<BatchUpdateFindingsV2ProcessedFinding.Builder> ... processedFindings) {
            this.processedFindings(Stream.of(processedFindings).map(c -> (BatchUpdateFindingsV2ProcessedFinding)((BatchUpdateFindingsV2ProcessedFinding.Builder)BatchUpdateFindingsV2ProcessedFinding.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchUpdateFindingsV2UnprocessedFinding.Builder> getUnprocessedFindings() {
            List<BatchUpdateFindingsV2UnprocessedFinding.Builder> result = BatchUpdateFindingsV2UnprocessedFindingsListCopier.copyToBuilder(this.unprocessedFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedFindings(Collection<BatchUpdateFindingsV2UnprocessedFinding.BuilderImpl> unprocessedFindings) {
            this.unprocessedFindings = BatchUpdateFindingsV2UnprocessedFindingsListCopier.copyFromBuilder(unprocessedFindings);
        }

        @Override
        public final Builder unprocessedFindings(Collection<BatchUpdateFindingsV2UnprocessedFinding> unprocessedFindings) {
            this.unprocessedFindings = BatchUpdateFindingsV2UnprocessedFindingsListCopier.copy(unprocessedFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedFindings(BatchUpdateFindingsV2UnprocessedFinding ... unprocessedFindings) {
            this.unprocessedFindings(Arrays.asList(unprocessedFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedFindings(Consumer<BatchUpdateFindingsV2UnprocessedFinding.Builder> ... unprocessedFindings) {
            this.unprocessedFindings(Stream.of(unprocessedFindings).map(c -> (BatchUpdateFindingsV2UnprocessedFinding)((BatchUpdateFindingsV2UnprocessedFinding.Builder)BatchUpdateFindingsV2UnprocessedFinding.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateFindingsV2Response build() {
            return new BatchUpdateFindingsV2Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateFindingsV2Response> {
        public Builder processedFindings(Collection<BatchUpdateFindingsV2ProcessedFinding> var1);

        public Builder processedFindings(BatchUpdateFindingsV2ProcessedFinding ... var1);

        public Builder processedFindings(Consumer<BatchUpdateFindingsV2ProcessedFinding.Builder> ... var1);

        public Builder unprocessedFindings(Collection<BatchUpdateFindingsV2UnprocessedFinding> var1);

        public Builder unprocessedFindings(BatchUpdateFindingsV2UnprocessedFinding ... var1);

        public Builder unprocessedFindings(Consumer<BatchUpdateFindingsV2UnprocessedFinding.Builder> ... var1);
    }
}

