/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.model.GetFindingsRequest;
import software.amazon.awssdk.services.securityhub.model.GetFindingsResponse;

public class GetFindingsIterable
implements SdkIterable<GetFindingsResponse> {
    private final SecurityHubClient client;
    private final GetFindingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetFindingsIterable(SecurityHubClient client, GetFindingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetFindingsResponseFetcher();
    }

    public Iterator<GetFindingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final GetFindingsIterable resume(GetFindingsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetFindingsIterable(this.client, (GetFindingsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetFindingsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetFindingsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetFindingsResponseFetcher
    implements SyncPageFetcher<GetFindingsResponse> {
        private GetFindingsResponseFetcher() {
        }

        public boolean hasNextPage(GetFindingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetFindingsResponse nextPage(GetFindingsResponse previousPage) {
            if (previousPage == null) {
                return GetFindingsIterable.this.client.getFindings(GetFindingsIterable.this.firstRequest);
            }
            return GetFindingsIterable.this.client.getFindings((GetFindingsRequest)((Object)GetFindingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

