/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.ProductV2;
import software.amazon.awssdk.services.securityhub.model.ProductsV2ListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProductsV2Response
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, DescribeProductsV2Response> {
    private static final SdkField<List<ProductV2>> PRODUCTS_V2_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductsV2").getter(DescribeProductsV2Response.getter(DescribeProductsV2Response::productsV2)).setter(DescribeProductsV2Response.setter(Builder::productsV2)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductsV2").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductV2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeProductsV2Response.getter(DescribeProductsV2Response::nextToken)).setter(DescribeProductsV2Response.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCTS_V2_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeProductsV2Response.memberNameToFieldInitializer();
    private final List<ProductV2> productsV2;
    private final String nextToken;

    private DescribeProductsV2Response(BuilderImpl builder) {
        super(builder);
        this.productsV2 = builder.productsV2;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasProductsV2() {
        return this.productsV2 != null && !(this.productsV2 instanceof SdkAutoConstructList);
    }

    public final List<ProductV2> productsV2() {
        return this.productsV2;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductsV2() ? this.productsV2() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProductsV2Response)) {
            return false;
        }
        DescribeProductsV2Response other = (DescribeProductsV2Response)((Object)obj);
        return this.hasProductsV2() == other.hasProductsV2() && Objects.equals(this.productsV2(), other.productsV2()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeProductsV2Response").add("ProductsV2", this.hasProductsV2() ? this.productsV2() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductsV2": {
                return Optional.ofNullable(clazz.cast(this.productsV2()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProductsV2", PRODUCTS_V2_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeProductsV2Response, T> g) {
        return obj -> g.apply((DescribeProductsV2Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<ProductV2> productsV2 = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProductsV2Response model) {
            super(model);
            this.productsV2(model.productsV2);
            this.nextToken(model.nextToken);
        }

        public final List<ProductV2.Builder> getProductsV2() {
            List<ProductV2.Builder> result = ProductsV2ListCopier.copyToBuilder(this.productsV2);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductsV2(Collection<ProductV2.BuilderImpl> productsV2) {
            this.productsV2 = ProductsV2ListCopier.copyFromBuilder(productsV2);
        }

        @Override
        public final Builder productsV2(Collection<ProductV2> productsV2) {
            this.productsV2 = ProductsV2ListCopier.copy(productsV2);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productsV2(ProductV2 ... productsV2) {
            this.productsV2(Arrays.asList(productsV2));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productsV2(Consumer<ProductV2.Builder> ... productsV2) {
            this.productsV2(Stream.of(productsV2).map(c -> (ProductV2)((ProductV2.Builder)ProductV2.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeProductsV2Response build() {
            return new DescribeProductsV2Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeProductsV2Response> {
        public Builder productsV2(Collection<ProductV2> var1);

        public Builder productsV2(ProductV2 ... var1);

        public Builder productsV2(Consumer<ProductV2.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

