/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourcesNumberField {
    FINDINGS_SUMMARY_TOTAL_FINDINGS("findings_summary.total_findings"),
    FINDINGS_SUMMARY_SEVERITIES_OTHER("findings_summary.severities.other"),
    FINDINGS_SUMMARY_SEVERITIES_FATAL("findings_summary.severities.fatal"),
    FINDINGS_SUMMARY_SEVERITIES_CRITICAL("findings_summary.severities.critical"),
    FINDINGS_SUMMARY_SEVERITIES_HIGH("findings_summary.severities.high"),
    FINDINGS_SUMMARY_SEVERITIES_MEDIUM("findings_summary.severities.medium"),
    FINDINGS_SUMMARY_SEVERITIES_LOW("findings_summary.severities.low"),
    FINDINGS_SUMMARY_SEVERITIES_INFORMATIONAL("findings_summary.severities.informational"),
    FINDINGS_SUMMARY_SEVERITIES_UNKNOWN("findings_summary.severities.unknown"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourcesNumberField> VALUE_MAP;
    private final String value;

    private ResourcesNumberField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourcesNumberField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourcesNumberField> knownValues() {
        EnumSet<ResourcesNumberField> knownValues = EnumSet.allOf(ResourcesNumberField.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourcesNumberField.class, ResourcesNumberField::toString);
    }
}

