/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceGroupByField {
    ACCOUNT_ID("account_id"),
    REGION("region"),
    RESOURCE_CATEGORY("resource_category"),
    RESOURCE_TYPE("resource_type"),
    RESOURCE_NAME("resource_name"),
    FINDINGS_SUMMARY_FINDING_TYPE("findings_summary.finding_type"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceGroupByField> VALUE_MAP;
    private final String value;

    private ResourceGroupByField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceGroupByField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceGroupByField> knownValues() {
        EnumSet<ResourceGroupByField> knownValues = EnumSet.allOf(ResourceGroupByField.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceGroupByField.class, ResourceGroupByField::toString);
    }
}

