/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.ResourceSeverityBreakdown;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceFindingsSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceFindingsSummary> {
    private static final SdkField<String> FINDING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FindingType").getter(ResourceFindingsSummary.getter(ResourceFindingsSummary::findingType)).setter(ResourceFindingsSummary.setter(Builder::findingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingType").build()}).build();
    private static final SdkField<String> PRODUCT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductName").getter(ResourceFindingsSummary.getter(ResourceFindingsSummary::productName)).setter(ResourceFindingsSummary.setter(Builder::productName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductName").build()}).build();
    private static final SdkField<Integer> TOTAL_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalFindings").getter(ResourceFindingsSummary.getter(ResourceFindingsSummary::totalFindings)).setter(ResourceFindingsSummary.setter(Builder::totalFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalFindings").build()}).build();
    private static final SdkField<ResourceSeverityBreakdown> SEVERITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Severities").getter(ResourceFindingsSummary.getter(ResourceFindingsSummary::severities)).setter(ResourceFindingsSummary.setter(Builder::severities)).constructor(ResourceSeverityBreakdown::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severities").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_TYPE_FIELD, PRODUCT_NAME_FIELD, TOTAL_FINDINGS_FIELD, SEVERITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceFindingsSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String findingType;
    private final String productName;
    private final Integer totalFindings;
    private final ResourceSeverityBreakdown severities;

    private ResourceFindingsSummary(BuilderImpl builder) {
        this.findingType = builder.findingType;
        this.productName = builder.productName;
        this.totalFindings = builder.totalFindings;
        this.severities = builder.severities;
    }

    public final String findingType() {
        return this.findingType;
    }

    public final String productName() {
        return this.productName;
    }

    public final Integer totalFindings() {
        return this.totalFindings;
    }

    public final ResourceSeverityBreakdown severities() {
        return this.severities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.findingType());
        hashCode = 31 * hashCode + Objects.hashCode(this.productName());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalFindings());
        hashCode = 31 * hashCode + Objects.hashCode(this.severities());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceFindingsSummary)) {
            return false;
        }
        ResourceFindingsSummary other = (ResourceFindingsSummary)obj;
        return Objects.equals(this.findingType(), other.findingType()) && Objects.equals(this.productName(), other.productName()) && Objects.equals(this.totalFindings(), other.totalFindings()) && Objects.equals(this.severities(), other.severities());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceFindingsSummary").add("FindingType", (Object)this.findingType()).add("ProductName", (Object)this.productName()).add("TotalFindings", (Object)this.totalFindings()).add("Severities", (Object)this.severities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FindingType": {
                return Optional.ofNullable(clazz.cast(this.findingType()));
            }
            case "ProductName": {
                return Optional.ofNullable(clazz.cast(this.productName()));
            }
            case "TotalFindings": {
                return Optional.ofNullable(clazz.cast(this.totalFindings()));
            }
            case "Severities": {
                return Optional.ofNullable(clazz.cast(this.severities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FindingType", FINDING_TYPE_FIELD);
        map.put("ProductName", PRODUCT_NAME_FIELD);
        map.put("TotalFindings", TOTAL_FINDINGS_FIELD);
        map.put("Severities", SEVERITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceFindingsSummary, T> g) {
        return obj -> g.apply((ResourceFindingsSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String findingType;
        private String productName;
        private Integer totalFindings;
        private ResourceSeverityBreakdown severities;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceFindingsSummary model) {
            this.findingType(model.findingType);
            this.productName(model.productName);
            this.totalFindings(model.totalFindings);
            this.severities(model.severities);
        }

        public final String getFindingType() {
            return this.findingType;
        }

        public final void setFindingType(String findingType) {
            this.findingType = findingType;
        }

        @Override
        public final Builder findingType(String findingType) {
            this.findingType = findingType;
            return this;
        }

        public final String getProductName() {
            return this.productName;
        }

        public final void setProductName(String productName) {
            this.productName = productName;
        }

        @Override
        public final Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public final Integer getTotalFindings() {
            return this.totalFindings;
        }

        public final void setTotalFindings(Integer totalFindings) {
            this.totalFindings = totalFindings;
        }

        @Override
        public final Builder totalFindings(Integer totalFindings) {
            this.totalFindings = totalFindings;
            return this;
        }

        public final ResourceSeverityBreakdown.Builder getSeverities() {
            return this.severities != null ? this.severities.toBuilder() : null;
        }

        public final void setSeverities(ResourceSeverityBreakdown.BuilderImpl severities) {
            this.severities = severities != null ? severities.build() : null;
        }

        @Override
        public final Builder severities(ResourceSeverityBreakdown severities) {
            this.severities = severities;
            return this;
        }

        public ResourceFindingsSummary build() {
            return new ResourceFindingsSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceFindingsSummary> {
        public Builder findingType(String var1);

        public Builder productName(String var1);

        public Builder totalFindings(Integer var1);

        public Builder severities(ResourceSeverityBreakdown var1);

        default public Builder severities(Consumer<ResourceSeverityBreakdown.Builder> severities) {
            return this.severities((ResourceSeverityBreakdown)((ResourceSeverityBreakdown.Builder)ResourceSeverityBreakdown.builder().applyMutation(severities)).build());
        }
    }
}

