/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OcsfStringField {
    METADATA_UID("metadata.uid"),
    ACTIVITY_NAME("activity_name"),
    CLOUD_ACCOUNT_UID("cloud.account.uid"),
    CLOUD_PROVIDER("cloud.provider"),
    CLOUD_REGION("cloud.region"),
    COMPLIANCE_ASSESSMENTS_CATEGORY("compliance.assessments.category"),
    COMPLIANCE_ASSESSMENTS_NAME("compliance.assessments.name"),
    COMPLIANCE_CONTROL("compliance.control"),
    COMPLIANCE_STATUS("compliance.status"),
    COMPLIANCE_STANDARDS("compliance.standards"),
    FINDING_INFO_DESC("finding_info.desc"),
    FINDING_INFO_SRC_URL("finding_info.src_url"),
    FINDING_INFO_TITLE("finding_info.title"),
    FINDING_INFO_TYPES("finding_info.types"),
    FINDING_INFO_UID("finding_info.uid"),
    FINDING_INFO_RELATED_EVENTS_UID("finding_info.related_events.uid"),
    FINDING_INFO_RELATED_EVENTS_PRODUCT_UID("finding_info.related_events.product.uid"),
    FINDING_INFO_RELATED_EVENTS_TITLE("finding_info.related_events.title"),
    METADATA_PRODUCT_NAME("metadata.product.name"),
    METADATA_PRODUCT_UID("metadata.product.uid"),
    METADATA_PRODUCT_VENDOR_NAME("metadata.product.vendor_name"),
    REMEDIATION_DESC("remediation.desc"),
    REMEDIATION_REFERENCES("remediation.references"),
    RESOURCES_CLOUD_PARTITION("resources.cloud_partition"),
    RESOURCES_REGION("resources.region"),
    RESOURCES_TYPE("resources.type"),
    RESOURCES_UID("resources.uid"),
    SEVERITY("severity"),
    STATUS("status"),
    COMMENT("comment"),
    VULNERABILITIES_FIX_COVERAGE("vulnerabilities.fix_coverage"),
    CLASS_NAME("class_name"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OcsfStringField> VALUE_MAP;
    private final String value;

    private OcsfStringField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OcsfStringField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OcsfStringField> knownValues() {
        EnumSet<OcsfStringField> knownValues = EnumSet.allOf(OcsfStringField.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OcsfStringField.class, OcsfStringField::toString);
    }
}

