/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.AutomationRulesActionTypeV2;
import software.amazon.awssdk.services.securityhub.model.AutomationRulesFindingFieldsUpdateV2;
import software.amazon.awssdk.services.securityhub.model.ExternalIntegrationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomationRulesActionV2
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomationRulesActionV2> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(AutomationRulesActionV2.getter(AutomationRulesActionV2::typeAsString)).setter(AutomationRulesActionV2.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<AutomationRulesFindingFieldsUpdateV2> FINDING_FIELDS_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FindingFieldsUpdate").getter(AutomationRulesActionV2.getter(AutomationRulesActionV2::findingFieldsUpdate)).setter(AutomationRulesActionV2.setter(Builder::findingFieldsUpdate)).constructor(AutomationRulesFindingFieldsUpdateV2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingFieldsUpdate").build()}).build();
    private static final SdkField<ExternalIntegrationConfiguration> EXTERNAL_INTEGRATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExternalIntegrationConfiguration").getter(AutomationRulesActionV2.getter(AutomationRulesActionV2::externalIntegrationConfiguration)).setter(AutomationRulesActionV2.setter(Builder::externalIntegrationConfiguration)).constructor(ExternalIntegrationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalIntegrationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, FINDING_FIELDS_UPDATE_FIELD, EXTERNAL_INTEGRATION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomationRulesActionV2.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final AutomationRulesFindingFieldsUpdateV2 findingFieldsUpdate;
    private final ExternalIntegrationConfiguration externalIntegrationConfiguration;

    private AutomationRulesActionV2(BuilderImpl builder) {
        this.type = builder.type;
        this.findingFieldsUpdate = builder.findingFieldsUpdate;
        this.externalIntegrationConfiguration = builder.externalIntegrationConfiguration;
    }

    public final AutomationRulesActionTypeV2 type() {
        return AutomationRulesActionTypeV2.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final AutomationRulesFindingFieldsUpdateV2 findingFieldsUpdate() {
        return this.findingFieldsUpdate;
    }

    public final ExternalIntegrationConfiguration externalIntegrationConfiguration() {
        return this.externalIntegrationConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingFieldsUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalIntegrationConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationRulesActionV2)) {
            return false;
        }
        AutomationRulesActionV2 other = (AutomationRulesActionV2)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.findingFieldsUpdate(), other.findingFieldsUpdate()) && Objects.equals(this.externalIntegrationConfiguration(), other.externalIntegrationConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"AutomationRulesActionV2").add("Type", (Object)this.typeAsString()).add("FindingFieldsUpdate", (Object)this.findingFieldsUpdate()).add("ExternalIntegrationConfiguration", (Object)this.externalIntegrationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "FindingFieldsUpdate": {
                return Optional.ofNullable(clazz.cast(this.findingFieldsUpdate()));
            }
            case "ExternalIntegrationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.externalIntegrationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("FindingFieldsUpdate", FINDING_FIELDS_UPDATE_FIELD);
        map.put("ExternalIntegrationConfiguration", EXTERNAL_INTEGRATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomationRulesActionV2, T> g) {
        return obj -> g.apply((AutomationRulesActionV2)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private AutomationRulesFindingFieldsUpdateV2 findingFieldsUpdate;
        private ExternalIntegrationConfiguration externalIntegrationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationRulesActionV2 model) {
            this.type(model.type);
            this.findingFieldsUpdate(model.findingFieldsUpdate);
            this.externalIntegrationConfiguration(model.externalIntegrationConfiguration);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AutomationRulesActionTypeV2 type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final AutomationRulesFindingFieldsUpdateV2.Builder getFindingFieldsUpdate() {
            return this.findingFieldsUpdate != null ? this.findingFieldsUpdate.toBuilder() : null;
        }

        public final void setFindingFieldsUpdate(AutomationRulesFindingFieldsUpdateV2.BuilderImpl findingFieldsUpdate) {
            this.findingFieldsUpdate = findingFieldsUpdate != null ? findingFieldsUpdate.build() : null;
        }

        @Override
        public final Builder findingFieldsUpdate(AutomationRulesFindingFieldsUpdateV2 findingFieldsUpdate) {
            this.findingFieldsUpdate = findingFieldsUpdate;
            return this;
        }

        public final ExternalIntegrationConfiguration.Builder getExternalIntegrationConfiguration() {
            return this.externalIntegrationConfiguration != null ? this.externalIntegrationConfiguration.toBuilder() : null;
        }

        public final void setExternalIntegrationConfiguration(ExternalIntegrationConfiguration.BuilderImpl externalIntegrationConfiguration) {
            this.externalIntegrationConfiguration = externalIntegrationConfiguration != null ? externalIntegrationConfiguration.build() : null;
        }

        @Override
        public final Builder externalIntegrationConfiguration(ExternalIntegrationConfiguration externalIntegrationConfiguration) {
            this.externalIntegrationConfiguration = externalIntegrationConfiguration;
            return this;
        }

        public AutomationRulesActionV2 build() {
            return new AutomationRulesActionV2(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomationRulesActionV2> {
        public Builder type(String var1);

        public Builder type(AutomationRulesActionTypeV2 var1);

        public Builder findingFieldsUpdate(AutomationRulesFindingFieldsUpdateV2 var1);

        default public Builder findingFieldsUpdate(Consumer<AutomationRulesFindingFieldsUpdateV2.Builder> findingFieldsUpdate) {
            return this.findingFieldsUpdate((AutomationRulesFindingFieldsUpdateV2)((AutomationRulesFindingFieldsUpdateV2.Builder)AutomationRulesFindingFieldsUpdateV2.builder().applyMutation(findingFieldsUpdate)).build());
        }

        public Builder externalIntegrationConfiguration(ExternalIntegrationConfiguration var1);

        default public Builder externalIntegrationConfiguration(Consumer<ExternalIntegrationConfiguration.Builder> externalIntegrationConfiguration) {
            return this.externalIntegrationConfiguration((ExternalIntegrationConfiguration)((ExternalIntegrationConfiguration.Builder)ExternalIntegrationConfiguration.builder().applyMutation(externalIntegrationConfiguration)).build());
        }
    }
}

