/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.Insight;
import software.amazon.awssdk.services.securityhub.model.InsightListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInsightsResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, GetInsightsResponse> {
    private static final SdkField<List<Insight>> INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Insights").getter(GetInsightsResponse.getter(GetInsightsResponse::insights)).setter(GetInsightsResponse.setter(Builder::insights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Insights").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Insight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetInsightsResponse.getter(GetInsightsResponse::nextToken)).setter(GetInsightsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetInsightsResponse.memberNameToFieldInitializer();
    private final List<Insight> insights;
    private final String nextToken;

    private GetInsightsResponse(BuilderImpl builder) {
        super(builder);
        this.insights = builder.insights;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInsights() {
        return this.insights != null && !(this.insights instanceof SdkAutoConstructList);
    }

    public final List<Insight> insights() {
        return this.insights;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInsights() ? this.insights() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInsightsResponse)) {
            return false;
        }
        GetInsightsResponse other = (GetInsightsResponse)((Object)obj);
        return this.hasInsights() == other.hasInsights() && Objects.equals(this.insights(), other.insights()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetInsightsResponse").add("Insights", this.hasInsights() ? this.insights() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Insights": {
                return Optional.ofNullable(clazz.cast(this.insights()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Insights", INSIGHTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetInsightsResponse, T> g) {
        return obj -> g.apply((GetInsightsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<Insight> insights = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInsightsResponse model) {
            super(model);
            this.insights(model.insights);
            this.nextToken(model.nextToken);
        }

        public final List<Insight.Builder> getInsights() {
            List<Insight.Builder> result = InsightListCopier.copyToBuilder(this.insights);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInsights(Collection<Insight.BuilderImpl> insights) {
            this.insights = InsightListCopier.copyFromBuilder(insights);
        }

        @Override
        public final Builder insights(Collection<Insight> insights) {
            this.insights = InsightListCopier.copy(insights);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insights(Insight ... insights) {
            this.insights(Arrays.asList(insights));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insights(Consumer<Insight.Builder> ... insights) {
            this.insights(Stream.of(insights).map(c -> (Insight)((Insight.Builder)Insight.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetInsightsResponse build() {
            return new GetInsightsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInsightsResponse> {
        public Builder insights(Collection<Insight> var1);

        public Builder insights(Insight ... var1);

        public Builder insights(Consumer<Insight.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

