/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsCloudFormationStackDriftInformationDetails;
import software.amazon.awssdk.services.securityhub.model.AwsCloudFormationStackOutputsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsCloudFormationStackOutputsListCopier;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsCloudFormationStackDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsCloudFormationStackDetails> {
    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Capabilities").getter(AwsCloudFormationStackDetails.getter(AwsCloudFormationStackDetails::capabilities)).setter(AwsCloudFormationStackDetails.setter(Builder::capabilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationTime").getter(AwsCloudFormationStackDetails.getter(AwsCloudFormationStackDetails::creationTime)).setter(AwsCloudFormationStackDetails.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AwsCloudFormationStackDetails.getter(AwsCloudFormationStackDetails::description)).setter(AwsCloudFormationStackDetails.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> DISABLE_ROLLBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisableRollback").getter(AwsCloudFormationStackDetails.getter(AwsCloudFormationStackDetails::disableRollback)).setter(AwsCloudFormationStackDetails.setter(Builder::disableRollback)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableRollback").build()}).build();
    private static final SdkField<AwsCloudFormationStackDriftInformationDetails> DRIFT_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DriftInformation").getter(AwsCloudFormationStackDetails.getter(AwsCloudFormationStackDetails::driftInformation)).setter(AwsCloudFormationStackDetails.setter(Builder::driftInformation)).constructor(AwsCloudFormationStackDriftInformationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriftInformation").build()}).build();
    private static final SdkField<Boolean> ENABLE_TERMINATION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableTerminationProtection").getter(AwsCloudFormationStackDetails.getter(AwsCloudFormationStackDetails::enableTerminationProtection)).setter(AwsCloudFormationStackDetails.setter(Builder::enableTerminationProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableTerminationProtection").build()}).build();
    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUpdatedTime").getter(AwsCloudFormationStackDetails.getter(AwsCloudFormationStackDetails::lastUpdatedTime)).setter(AwsCloudFormationStackDetails.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<List<String>> NOTIFICATION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotificationArns").getter(AwsCloudFormationStackDetails.getter(AwsCloudFormationStackDetails::notificationArns)).setter(AwsCloudFormationStackDetails.setter(Builder::notificationArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AwsCloudFormationStackOutputsDetails>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Outputs").getter(AwsCloudFormationStackDetails.getter(AwsCloudFormationStackDetails::outputs)).setter(AwsCloudFormationStackDetails.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsCloudFormationStackOutputsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(AwsCloudFormationStackDetails.getter(AwsCloudFormationStackDetails::roleArn)).setter(AwsCloudFormationStackDetails.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackId").getter(AwsCloudFormationStackDetails.getter(AwsCloudFormationStackDetails::stackId)).setter(AwsCloudFormationStackDetails.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackName").getter(AwsCloudFormationStackDetails.getter(AwsCloudFormationStackDetails::stackName)).setter(AwsCloudFormationStackDetails.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<String> STACK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackStatus").getter(AwsCloudFormationStackDetails.getter(AwsCloudFormationStackDetails::stackStatus)).setter(AwsCloudFormationStackDetails.setter(Builder::stackStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackStatus").build()}).build();
    private static final SdkField<String> STACK_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackStatusReason").getter(AwsCloudFormationStackDetails.getter(AwsCloudFormationStackDetails::stackStatusReason)).setter(AwsCloudFormationStackDetails.setter(Builder::stackStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackStatusReason").build()}).build();
    private static final SdkField<Integer> TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimeoutInMinutes").getter(AwsCloudFormationStackDetails.getter(AwsCloudFormationStackDetails::timeoutInMinutes)).setter(AwsCloudFormationStackDetails.setter(Builder::timeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutInMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPABILITIES_FIELD, CREATION_TIME_FIELD, DESCRIPTION_FIELD, DISABLE_ROLLBACK_FIELD, DRIFT_INFORMATION_FIELD, ENABLE_TERMINATION_PROTECTION_FIELD, LAST_UPDATED_TIME_FIELD, NOTIFICATION_ARNS_FIELD, OUTPUTS_FIELD, ROLE_ARN_FIELD, STACK_ID_FIELD, STACK_NAME_FIELD, STACK_STATUS_FIELD, STACK_STATUS_REASON_FIELD, TIMEOUT_IN_MINUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsCloudFormationStackDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> capabilities;
    private final String creationTime;
    private final String description;
    private final Boolean disableRollback;
    private final AwsCloudFormationStackDriftInformationDetails driftInformation;
    private final Boolean enableTerminationProtection;
    private final String lastUpdatedTime;
    private final List<String> notificationArns;
    private final List<AwsCloudFormationStackOutputsDetails> outputs;
    private final String roleArn;
    private final String stackId;
    private final String stackName;
    private final String stackStatus;
    private final String stackStatusReason;
    private final Integer timeoutInMinutes;

    private AwsCloudFormationStackDetails(BuilderImpl builder) {
        this.capabilities = builder.capabilities;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.disableRollback = builder.disableRollback;
        this.driftInformation = builder.driftInformation;
        this.enableTerminationProtection = builder.enableTerminationProtection;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.notificationArns = builder.notificationArns;
        this.outputs = builder.outputs;
        this.roleArn = builder.roleArn;
        this.stackId = builder.stackId;
        this.stackName = builder.stackName;
        this.stackStatus = builder.stackStatus;
        this.stackStatusReason = builder.stackStatusReason;
        this.timeoutInMinutes = builder.timeoutInMinutes;
    }

    public final boolean hasCapabilities() {
        return this.capabilities != null && !(this.capabilities instanceof SdkAutoConstructList);
    }

    public final List<String> capabilities() {
        return this.capabilities;
    }

    public final String creationTime() {
        return this.creationTime;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean disableRollback() {
        return this.disableRollback;
    }

    public final AwsCloudFormationStackDriftInformationDetails driftInformation() {
        return this.driftInformation;
    }

    public final Boolean enableTerminationProtection() {
        return this.enableTerminationProtection;
    }

    public final String lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final boolean hasNotificationArns() {
        return this.notificationArns != null && !(this.notificationArns instanceof SdkAutoConstructList);
    }

    public final List<String> notificationArns() {
        return this.notificationArns;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public final List<AwsCloudFormationStackOutputsDetails> outputs() {
        return this.outputs;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String stackId() {
        return this.stackId;
    }

    public final String stackName() {
        return this.stackName;
    }

    public final String stackStatus() {
        return this.stackStatus;
    }

    public final String stackStatusReason() {
        return this.stackStatusReason;
    }

    public final Integer timeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapabilities() ? this.capabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableRollback());
        hashCode = 31 * hashCode + Objects.hashCode(this.driftInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableTerminationProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotificationArns() ? this.notificationArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFormationStackDetails)) {
            return false;
        }
        AwsCloudFormationStackDetails other = (AwsCloudFormationStackDetails)obj;
        return this.hasCapabilities() == other.hasCapabilities() && Objects.equals(this.capabilities(), other.capabilities()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.disableRollback(), other.disableRollback()) && Objects.equals(this.driftInformation(), other.driftInformation()) && Objects.equals(this.enableTerminationProtection(), other.enableTerminationProtection()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && this.hasNotificationArns() == other.hasNotificationArns() && Objects.equals(this.notificationArns(), other.notificationArns()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.stackStatus(), other.stackStatus()) && Objects.equals(this.stackStatusReason(), other.stackStatusReason()) && Objects.equals(this.timeoutInMinutes(), other.timeoutInMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"AwsCloudFormationStackDetails").add("Capabilities", this.hasCapabilities() ? this.capabilities() : null).add("CreationTime", (Object)this.creationTime()).add("Description", (Object)this.description()).add("DisableRollback", (Object)this.disableRollback()).add("DriftInformation", (Object)this.driftInformation()).add("EnableTerminationProtection", (Object)this.enableTerminationProtection()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("NotificationArns", this.hasNotificationArns() ? this.notificationArns() : null).add("Outputs", this.hasOutputs() ? this.outputs() : null).add("RoleArn", (Object)this.roleArn()).add("StackId", (Object)this.stackId()).add("StackName", (Object)this.stackName()).add("StackStatus", (Object)this.stackStatus()).add("StackStatusReason", (Object)this.stackStatusReason()).add("TimeoutInMinutes", (Object)this.timeoutInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilities()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisableRollback": {
                return Optional.ofNullable(clazz.cast(this.disableRollback()));
            }
            case "DriftInformation": {
                return Optional.ofNullable(clazz.cast(this.driftInformation()));
            }
            case "EnableTerminationProtection": {
                return Optional.ofNullable(clazz.cast(this.enableTerminationProtection()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "NotificationArns": {
                return Optional.ofNullable(clazz.cast(this.notificationArns()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "StackStatus": {
                return Optional.ofNullable(clazz.cast(this.stackStatus()));
            }
            case "StackStatusReason": {
                return Optional.ofNullable(clazz.cast(this.stackStatusReason()));
            }
            case "TimeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.timeoutInMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Capabilities", CAPABILITIES_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DisableRollback", DISABLE_ROLLBACK_FIELD);
        map.put("DriftInformation", DRIFT_INFORMATION_FIELD);
        map.put("EnableTerminationProtection", ENABLE_TERMINATION_PROTECTION_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("NotificationArns", NOTIFICATION_ARNS_FIELD);
        map.put("Outputs", OUTPUTS_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("StackId", STACK_ID_FIELD);
        map.put("StackName", STACK_NAME_FIELD);
        map.put("StackStatus", STACK_STATUS_FIELD);
        map.put("StackStatusReason", STACK_STATUS_REASON_FIELD);
        map.put("TimeoutInMinutes", TIMEOUT_IN_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFormationStackDetails, T> g) {
        return obj -> g.apply((AwsCloudFormationStackDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();
        private String creationTime;
        private String description;
        private Boolean disableRollback;
        private AwsCloudFormationStackDriftInformationDetails driftInformation;
        private Boolean enableTerminationProtection;
        private String lastUpdatedTime;
        private List<String> notificationArns = DefaultSdkAutoConstructList.getInstance();
        private List<AwsCloudFormationStackOutputsDetails> outputs = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;
        private String stackId;
        private String stackName;
        private String stackStatus;
        private String stackStatusReason;
        private Integer timeoutInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFormationStackDetails model) {
            this.capabilities(model.capabilities);
            this.creationTime(model.creationTime);
            this.description(model.description);
            this.disableRollback(model.disableRollback);
            this.driftInformation(model.driftInformation);
            this.enableTerminationProtection(model.enableTerminationProtection);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.notificationArns(model.notificationArns);
            this.outputs(model.outputs);
            this.roleArn(model.roleArn);
            this.stackId(model.stackId);
            this.stackName(model.stackName);
            this.stackStatus(model.stackStatus);
            this.stackStatusReason(model.stackStatusReason);
            this.timeoutInMinutes(model.timeoutInMinutes);
        }

        public final Collection<String> getCapabilities() {
            if (this.capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = NonEmptyStringListCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = NonEmptyStringListCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getDisableRollback() {
            return this.disableRollback;
        }

        public final void setDisableRollback(Boolean disableRollback) {
            this.disableRollback = disableRollback;
        }

        @Override
        public final Builder disableRollback(Boolean disableRollback) {
            this.disableRollback = disableRollback;
            return this;
        }

        public final AwsCloudFormationStackDriftInformationDetails.Builder getDriftInformation() {
            return this.driftInformation != null ? this.driftInformation.toBuilder() : null;
        }

        public final void setDriftInformation(AwsCloudFormationStackDriftInformationDetails.BuilderImpl driftInformation) {
            this.driftInformation = driftInformation != null ? driftInformation.build() : null;
        }

        @Override
        public final Builder driftInformation(AwsCloudFormationStackDriftInformationDetails driftInformation) {
            this.driftInformation = driftInformation;
            return this;
        }

        public final Boolean getEnableTerminationProtection() {
            return this.enableTerminationProtection;
        }

        public final void setEnableTerminationProtection(Boolean enableTerminationProtection) {
            this.enableTerminationProtection = enableTerminationProtection;
        }

        @Override
        public final Builder enableTerminationProtection(Boolean enableTerminationProtection) {
            this.enableTerminationProtection = enableTerminationProtection;
            return this;
        }

        public final String getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Collection<String> getNotificationArns() {
            if (this.notificationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notificationArns;
        }

        public final void setNotificationArns(Collection<String> notificationArns) {
            this.notificationArns = NonEmptyStringListCopier.copy(notificationArns);
        }

        @Override
        public final Builder notificationArns(Collection<String> notificationArns) {
            this.notificationArns = NonEmptyStringListCopier.copy(notificationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationArns(String ... notificationArns) {
            this.notificationArns(Arrays.asList(notificationArns));
            return this;
        }

        public final List<AwsCloudFormationStackOutputsDetails.Builder> getOutputs() {
            List<AwsCloudFormationStackOutputsDetails.Builder> result = AwsCloudFormationStackOutputsListCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<AwsCloudFormationStackOutputsDetails.BuilderImpl> outputs) {
            this.outputs = AwsCloudFormationStackOutputsListCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<AwsCloudFormationStackOutputsDetails> outputs) {
            this.outputs = AwsCloudFormationStackOutputsListCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(AwsCloudFormationStackOutputsDetails ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<AwsCloudFormationStackOutputsDetails.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (AwsCloudFormationStackOutputsDetails)((AwsCloudFormationStackOutputsDetails.Builder)AwsCloudFormationStackOutputsDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStackId() {
            return this.stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getStackName() {
            return this.stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getStackStatus() {
            return this.stackStatus;
        }

        public final void setStackStatus(String stackStatus) {
            this.stackStatus = stackStatus;
        }

        @Override
        public final Builder stackStatus(String stackStatus) {
            this.stackStatus = stackStatus;
            return this;
        }

        public final String getStackStatusReason() {
            return this.stackStatusReason;
        }

        public final void setStackStatusReason(String stackStatusReason) {
            this.stackStatusReason = stackStatusReason;
        }

        @Override
        public final Builder stackStatusReason(String stackStatusReason) {
            this.stackStatusReason = stackStatusReason;
            return this;
        }

        public final Integer getTimeoutInMinutes() {
            return this.timeoutInMinutes;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public AwsCloudFormationStackDetails build() {
            return new AwsCloudFormationStackDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsCloudFormationStackDetails> {
        public Builder capabilities(Collection<String> var1);

        public Builder capabilities(String ... var1);

        public Builder creationTime(String var1);

        public Builder description(String var1);

        public Builder disableRollback(Boolean var1);

        public Builder driftInformation(AwsCloudFormationStackDriftInformationDetails var1);

        default public Builder driftInformation(Consumer<AwsCloudFormationStackDriftInformationDetails.Builder> driftInformation) {
            return this.driftInformation((AwsCloudFormationStackDriftInformationDetails)((AwsCloudFormationStackDriftInformationDetails.Builder)AwsCloudFormationStackDriftInformationDetails.builder().applyMutation(driftInformation)).build());
        }

        public Builder enableTerminationProtection(Boolean var1);

        public Builder lastUpdatedTime(String var1);

        public Builder notificationArns(Collection<String> var1);

        public Builder notificationArns(String ... var1);

        public Builder outputs(Collection<AwsCloudFormationStackOutputsDetails> var1);

        public Builder outputs(AwsCloudFormationStackOutputsDetails ... var1);

        public Builder outputs(Consumer<AwsCloudFormationStackOutputsDetails.Builder> ... var1);

        public Builder roleArn(String var1);

        public Builder stackId(String var1);

        public Builder stackName(String var1);

        public Builder stackStatus(String var1);

        public Builder stackStatusReason(String var1);

        public Builder timeoutInMinutes(Integer var1);
    }
}

