/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupAvailabilityZonesListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails;
import software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification;
import software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails;
import software.amazon.awssdk.services.securityhub.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsAutoScalingAutoScalingGroupDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsAutoScalingAutoScalingGroupDetails> {
    private static final SdkField<String> LAUNCH_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchConfigurationName").getter(AwsAutoScalingAutoScalingGroupDetails.getter(AwsAutoScalingAutoScalingGroupDetails::launchConfigurationName)).setter(AwsAutoScalingAutoScalingGroupDetails.setter(Builder::launchConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurationName").build()}).build();
    private static final SdkField<List<String>> LOAD_BALANCER_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LoadBalancerNames").getter(AwsAutoScalingAutoScalingGroupDetails.getter(AwsAutoScalingAutoScalingGroupDetails::loadBalancerNames)).setter(AwsAutoScalingAutoScalingGroupDetails.setter(Builder::loadBalancerNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HEALTH_CHECK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthCheckType").getter(AwsAutoScalingAutoScalingGroupDetails.getter(AwsAutoScalingAutoScalingGroupDetails::healthCheckType)).setter(AwsAutoScalingAutoScalingGroupDetails.setter(Builder::healthCheckType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckType").build()}).build();
    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HealthCheckGracePeriod").getter(AwsAutoScalingAutoScalingGroupDetails.getter(AwsAutoScalingAutoScalingGroupDetails::healthCheckGracePeriod)).setter(AwsAutoScalingAutoScalingGroupDetails.setter(Builder::healthCheckGracePeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckGracePeriod").build()}).build();
    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedTime").getter(AwsAutoScalingAutoScalingGroupDetails.getter(AwsAutoScalingAutoScalingGroupDetails::createdTime)).setter(AwsAutoScalingAutoScalingGroupDetails.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails> MIXED_INSTANCES_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MixedInstancesPolicy").getter(AwsAutoScalingAutoScalingGroupDetails.getter(AwsAutoScalingAutoScalingGroupDetails::mixedInstancesPolicy)).setter(AwsAutoScalingAutoScalingGroupDetails.setter(Builder::mixedInstancesPolicy)).constructor(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MixedInstancesPolicy").build()}).build();
    private static final SdkField<List<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(AwsAutoScalingAutoScalingGroupDetails.getter(AwsAutoScalingAutoScalingGroupDetails::availabilityZones)).setter(AwsAutoScalingAutoScalingGroupDetails.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchTemplate").getter(AwsAutoScalingAutoScalingGroupDetails.getter(AwsAutoScalingAutoScalingGroupDetails::launchTemplate)).setter(AwsAutoScalingAutoScalingGroupDetails.setter(Builder::launchTemplate)).constructor(AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate").build()}).build();
    private static final SdkField<Boolean> CAPACITY_REBALANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CapacityRebalance").getter(AwsAutoScalingAutoScalingGroupDetails.getter(AwsAutoScalingAutoScalingGroupDetails::capacityRebalance)).setter(AwsAutoScalingAutoScalingGroupDetails.setter(Builder::capacityRebalance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityRebalance").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_CONFIGURATION_NAME_FIELD, LOAD_BALANCER_NAMES_FIELD, HEALTH_CHECK_TYPE_FIELD, HEALTH_CHECK_GRACE_PERIOD_FIELD, CREATED_TIME_FIELD, MIXED_INSTANCES_POLICY_FIELD, AVAILABILITY_ZONES_FIELD, LAUNCH_TEMPLATE_FIELD, CAPACITY_REBALANCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsAutoScalingAutoScalingGroupDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String launchConfigurationName;
    private final List<String> loadBalancerNames;
    private final String healthCheckType;
    private final Integer healthCheckGracePeriod;
    private final String createdTime;
    private final AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails mixedInstancesPolicy;
    private final List<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails> availabilityZones;
    private final AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification launchTemplate;
    private final Boolean capacityRebalance;

    private AwsAutoScalingAutoScalingGroupDetails(BuilderImpl builder) {
        this.launchConfigurationName = builder.launchConfigurationName;
        this.loadBalancerNames = builder.loadBalancerNames;
        this.healthCheckType = builder.healthCheckType;
        this.healthCheckGracePeriod = builder.healthCheckGracePeriod;
        this.createdTime = builder.createdTime;
        this.mixedInstancesPolicy = builder.mixedInstancesPolicy;
        this.availabilityZones = builder.availabilityZones;
        this.launchTemplate = builder.launchTemplate;
        this.capacityRebalance = builder.capacityRebalance;
    }

    public final String launchConfigurationName() {
        return this.launchConfigurationName;
    }

    public final boolean hasLoadBalancerNames() {
        return this.loadBalancerNames != null && !(this.loadBalancerNames instanceof SdkAutoConstructList);
    }

    public final List<String> loadBalancerNames() {
        return this.loadBalancerNames;
    }

    public final String healthCheckType() {
        return this.healthCheckType;
    }

    public final Integer healthCheckGracePeriod() {
        return this.healthCheckGracePeriod;
    }

    public final String createdTime() {
        return this.createdTime;
    }

    public final AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails mixedInstancesPolicy() {
        return this.mixedInstancesPolicy;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails> availabilityZones() {
        return this.availabilityZones;
    }

    public final AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification launchTemplate() {
        return this.launchTemplate;
    }

    public final Boolean capacityRebalance() {
        return this.capacityRebalance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoadBalancerNames() ? this.loadBalancerNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckType());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckGracePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.mixedInstancesPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityRebalance());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAutoScalingAutoScalingGroupDetails)) {
            return false;
        }
        AwsAutoScalingAutoScalingGroupDetails other = (AwsAutoScalingAutoScalingGroupDetails)obj;
        return Objects.equals(this.launchConfigurationName(), other.launchConfigurationName()) && this.hasLoadBalancerNames() == other.hasLoadBalancerNames() && Objects.equals(this.loadBalancerNames(), other.loadBalancerNames()) && Objects.equals(this.healthCheckType(), other.healthCheckType()) && Objects.equals(this.healthCheckGracePeriod(), other.healthCheckGracePeriod()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.mixedInstancesPolicy(), other.mixedInstancesPolicy()) && this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.launchTemplate(), other.launchTemplate()) && Objects.equals(this.capacityRebalance(), other.capacityRebalance());
    }

    public final String toString() {
        return ToString.builder((String)"AwsAutoScalingAutoScalingGroupDetails").add("LaunchConfigurationName", (Object)this.launchConfigurationName()).add("LoadBalancerNames", this.hasLoadBalancerNames() ? this.loadBalancerNames() : null).add("HealthCheckType", (Object)this.healthCheckType()).add("HealthCheckGracePeriod", (Object)this.healthCheckGracePeriod()).add("CreatedTime", (Object)this.createdTime()).add("MixedInstancesPolicy", (Object)this.mixedInstancesPolicy()).add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("LaunchTemplate", (Object)this.launchTemplate()).add("CapacityRebalance", (Object)this.capacityRebalance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.launchConfigurationName()));
            }
            case "LoadBalancerNames": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerNames()));
            }
            case "HealthCheckType": {
                return Optional.ofNullable(clazz.cast(this.healthCheckType()));
            }
            case "HealthCheckGracePeriod": {
                return Optional.ofNullable(clazz.cast(this.healthCheckGracePeriod()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "MixedInstancesPolicy": {
                return Optional.ofNullable(clazz.cast(this.mixedInstancesPolicy()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "LaunchTemplate": {
                return Optional.ofNullable(clazz.cast(this.launchTemplate()));
            }
            case "CapacityRebalance": {
                return Optional.ofNullable(clazz.cast(this.capacityRebalance()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LaunchConfigurationName", LAUNCH_CONFIGURATION_NAME_FIELD);
        map.put("LoadBalancerNames", LOAD_BALANCER_NAMES_FIELD);
        map.put("HealthCheckType", HEALTH_CHECK_TYPE_FIELD);
        map.put("HealthCheckGracePeriod", HEALTH_CHECK_GRACE_PERIOD_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("MixedInstancesPolicy", MIXED_INSTANCES_POLICY_FIELD);
        map.put("AvailabilityZones", AVAILABILITY_ZONES_FIELD);
        map.put("LaunchTemplate", LAUNCH_TEMPLATE_FIELD);
        map.put("CapacityRebalance", CAPACITY_REBALANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsAutoScalingAutoScalingGroupDetails, T> g) {
        return obj -> g.apply((AwsAutoScalingAutoScalingGroupDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String launchConfigurationName;
        private List<String> loadBalancerNames = DefaultSdkAutoConstructList.getInstance();
        private String healthCheckType;
        private Integer healthCheckGracePeriod;
        private String createdTime;
        private AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails mixedInstancesPolicy;
        private List<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification launchTemplate;
        private Boolean capacityRebalance;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAutoScalingAutoScalingGroupDetails model) {
            this.launchConfigurationName(model.launchConfigurationName);
            this.loadBalancerNames(model.loadBalancerNames);
            this.healthCheckType(model.healthCheckType);
            this.healthCheckGracePeriod(model.healthCheckGracePeriod);
            this.createdTime(model.createdTime);
            this.mixedInstancesPolicy(model.mixedInstancesPolicy);
            this.availabilityZones(model.availabilityZones);
            this.launchTemplate(model.launchTemplate);
            this.capacityRebalance(model.capacityRebalance);
        }

        public final String getLaunchConfigurationName() {
            return this.launchConfigurationName;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final Collection<String> getLoadBalancerNames() {
            if (this.loadBalancerNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.loadBalancerNames;
        }

        public final void setLoadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = StringListCopier.copy(loadBalancerNames);
        }

        @Override
        public final Builder loadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = StringListCopier.copy(loadBalancerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerNames(String ... loadBalancerNames) {
            this.loadBalancerNames(Arrays.asList(loadBalancerNames));
            return this;
        }

        public final String getHealthCheckType() {
            return this.healthCheckType;
        }

        public final void setHealthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
        }

        @Override
        public final Builder healthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public final Integer getHealthCheckGracePeriod() {
            return this.healthCheckGracePeriod;
        }

        public final void setHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
        }

        @Override
        public final Builder healthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public final String getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.Builder getMixedInstancesPolicy() {
            return this.mixedInstancesPolicy != null ? this.mixedInstancesPolicy.toBuilder() : null;
        }

        public final void setMixedInstancesPolicy(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.BuilderImpl mixedInstancesPolicy) {
            this.mixedInstancesPolicy = mixedInstancesPolicy != null ? mixedInstancesPolicy.build() : null;
        }

        @Override
        public final Builder mixedInstancesPolicy(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails mixedInstancesPolicy) {
            this.mixedInstancesPolicy = mixedInstancesPolicy;
            return this;
        }

        public final List<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails.Builder> getAvailabilityZones() {
            List<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails.Builder> result = AwsAutoScalingAutoScalingGroupAvailabilityZonesListCopier.copyToBuilder(this.availabilityZones);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailabilityZones(Collection<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails.BuilderImpl> availabilityZones) {
            this.availabilityZones = AwsAutoScalingAutoScalingGroupAvailabilityZonesListCopier.copyFromBuilder(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails> availabilityZones) {
            this.availabilityZones = AwsAutoScalingAutoScalingGroupAvailabilityZonesListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(Consumer<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails.Builder> ... availabilityZones) {
            this.availabilityZones(Stream.of(availabilityZones).map(c -> (AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails)((AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails.Builder)AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification.Builder getLaunchTemplate() {
            return this.launchTemplate != null ? this.launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final Boolean getCapacityRebalance() {
            return this.capacityRebalance;
        }

        public final void setCapacityRebalance(Boolean capacityRebalance) {
            this.capacityRebalance = capacityRebalance;
        }

        @Override
        public final Builder capacityRebalance(Boolean capacityRebalance) {
            this.capacityRebalance = capacityRebalance;
            return this;
        }

        public AwsAutoScalingAutoScalingGroupDetails build() {
            return new AwsAutoScalingAutoScalingGroupDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsAutoScalingAutoScalingGroupDetails> {
        public Builder launchConfigurationName(String var1);

        public Builder loadBalancerNames(Collection<String> var1);

        public Builder loadBalancerNames(String ... var1);

        public Builder healthCheckType(String var1);

        public Builder healthCheckGracePeriod(Integer var1);

        public Builder createdTime(String var1);

        public Builder mixedInstancesPolicy(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails var1);

        default public Builder mixedInstancesPolicy(Consumer<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.Builder> mixedInstancesPolicy) {
            return this.mixedInstancesPolicy((AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails)((AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.Builder)AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.builder().applyMutation(mixedInstancesPolicy)).build());
        }

        public Builder availabilityZones(Collection<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails> var1);

        public Builder availabilityZones(AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails ... var1);

        public Builder availabilityZones(Consumer<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails.Builder> ... var1);

        public Builder launchTemplate(AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification var1);

        default public Builder launchTemplate(Consumer<AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification.Builder> launchTemplate) {
            return this.launchTemplate((AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification)((AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification.Builder)AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification.builder().applyMutation(launchTemplate)).build());
        }

        public Builder capacityRebalance(Boolean var1);
    }
}

