/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRedirectTo;
import software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRule;
import software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRulesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsS3BucketWebsiteConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsS3BucketWebsiteConfiguration> {
    private static final SdkField<String> ERROR_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorDocument").getter(AwsS3BucketWebsiteConfiguration.getter(AwsS3BucketWebsiteConfiguration::errorDocument)).setter(AwsS3BucketWebsiteConfiguration.setter(Builder::errorDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDocument").build()}).build();
    private static final SdkField<String> INDEX_DOCUMENT_SUFFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexDocumentSuffix").getter(AwsS3BucketWebsiteConfiguration.getter(AwsS3BucketWebsiteConfiguration::indexDocumentSuffix)).setter(AwsS3BucketWebsiteConfiguration.setter(Builder::indexDocumentSuffix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexDocumentSuffix").build()}).build();
    private static final SdkField<AwsS3BucketWebsiteConfigurationRedirectTo> REDIRECT_ALL_REQUESTS_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RedirectAllRequestsTo").getter(AwsS3BucketWebsiteConfiguration.getter(AwsS3BucketWebsiteConfiguration::redirectAllRequestsTo)).setter(AwsS3BucketWebsiteConfiguration.setter(Builder::redirectAllRequestsTo)).constructor(AwsS3BucketWebsiteConfigurationRedirectTo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectAllRequestsTo").build()}).build();
    private static final SdkField<List<AwsS3BucketWebsiteConfigurationRoutingRule>> ROUTING_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RoutingRules").getter(AwsS3BucketWebsiteConfiguration.getter(AwsS3BucketWebsiteConfiguration::routingRules)).setter(AwsS3BucketWebsiteConfiguration.setter(Builder::routingRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsS3BucketWebsiteConfigurationRoutingRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_DOCUMENT_FIELD, INDEX_DOCUMENT_SUFFIX_FIELD, REDIRECT_ALL_REQUESTS_TO_FIELD, ROUTING_RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsS3BucketWebsiteConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String errorDocument;
    private final String indexDocumentSuffix;
    private final AwsS3BucketWebsiteConfigurationRedirectTo redirectAllRequestsTo;
    private final List<AwsS3BucketWebsiteConfigurationRoutingRule> routingRules;

    private AwsS3BucketWebsiteConfiguration(BuilderImpl builder) {
        this.errorDocument = builder.errorDocument;
        this.indexDocumentSuffix = builder.indexDocumentSuffix;
        this.redirectAllRequestsTo = builder.redirectAllRequestsTo;
        this.routingRules = builder.routingRules;
    }

    public final String errorDocument() {
        return this.errorDocument;
    }

    public final String indexDocumentSuffix() {
        return this.indexDocumentSuffix;
    }

    public final AwsS3BucketWebsiteConfigurationRedirectTo redirectAllRequestsTo() {
        return this.redirectAllRequestsTo;
    }

    public final boolean hasRoutingRules() {
        return this.routingRules != null && !(this.routingRules instanceof SdkAutoConstructList);
    }

    public final List<AwsS3BucketWebsiteConfigurationRoutingRule> routingRules() {
        return this.routingRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexDocumentSuffix());
        hashCode = 31 * hashCode + Objects.hashCode(this.redirectAllRequestsTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutingRules() ? this.routingRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketWebsiteConfiguration)) {
            return false;
        }
        AwsS3BucketWebsiteConfiguration other = (AwsS3BucketWebsiteConfiguration)obj;
        return Objects.equals(this.errorDocument(), other.errorDocument()) && Objects.equals(this.indexDocumentSuffix(), other.indexDocumentSuffix()) && Objects.equals(this.redirectAllRequestsTo(), other.redirectAllRequestsTo()) && this.hasRoutingRules() == other.hasRoutingRules() && Objects.equals(this.routingRules(), other.routingRules());
    }

    public final String toString() {
        return ToString.builder((String)"AwsS3BucketWebsiteConfiguration").add("ErrorDocument", (Object)this.errorDocument()).add("IndexDocumentSuffix", (Object)this.indexDocumentSuffix()).add("RedirectAllRequestsTo", (Object)this.redirectAllRequestsTo()).add("RoutingRules", this.hasRoutingRules() ? this.routingRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ErrorDocument": {
                return Optional.ofNullable(clazz.cast(this.errorDocument()));
            }
            case "IndexDocumentSuffix": {
                return Optional.ofNullable(clazz.cast(this.indexDocumentSuffix()));
            }
            case "RedirectAllRequestsTo": {
                return Optional.ofNullable(clazz.cast(this.redirectAllRequestsTo()));
            }
            case "RoutingRules": {
                return Optional.ofNullable(clazz.cast(this.routingRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ErrorDocument", ERROR_DOCUMENT_FIELD);
        map.put("IndexDocumentSuffix", INDEX_DOCUMENT_SUFFIX_FIELD);
        map.put("RedirectAllRequestsTo", REDIRECT_ALL_REQUESTS_TO_FIELD);
        map.put("RoutingRules", ROUTING_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketWebsiteConfiguration, T> g) {
        return obj -> g.apply((AwsS3BucketWebsiteConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String errorDocument;
        private String indexDocumentSuffix;
        private AwsS3BucketWebsiteConfigurationRedirectTo redirectAllRequestsTo;
        private List<AwsS3BucketWebsiteConfigurationRoutingRule> routingRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketWebsiteConfiguration model) {
            this.errorDocument(model.errorDocument);
            this.indexDocumentSuffix(model.indexDocumentSuffix);
            this.redirectAllRequestsTo(model.redirectAllRequestsTo);
            this.routingRules(model.routingRules);
        }

        public final String getErrorDocument() {
            return this.errorDocument;
        }

        public final void setErrorDocument(String errorDocument) {
            this.errorDocument = errorDocument;
        }

        @Override
        public final Builder errorDocument(String errorDocument) {
            this.errorDocument = errorDocument;
            return this;
        }

        public final String getIndexDocumentSuffix() {
            return this.indexDocumentSuffix;
        }

        public final void setIndexDocumentSuffix(String indexDocumentSuffix) {
            this.indexDocumentSuffix = indexDocumentSuffix;
        }

        @Override
        public final Builder indexDocumentSuffix(String indexDocumentSuffix) {
            this.indexDocumentSuffix = indexDocumentSuffix;
            return this;
        }

        public final AwsS3BucketWebsiteConfigurationRedirectTo.Builder getRedirectAllRequestsTo() {
            return this.redirectAllRequestsTo != null ? this.redirectAllRequestsTo.toBuilder() : null;
        }

        public final void setRedirectAllRequestsTo(AwsS3BucketWebsiteConfigurationRedirectTo.BuilderImpl redirectAllRequestsTo) {
            this.redirectAllRequestsTo = redirectAllRequestsTo != null ? redirectAllRequestsTo.build() : null;
        }

        @Override
        public final Builder redirectAllRequestsTo(AwsS3BucketWebsiteConfigurationRedirectTo redirectAllRequestsTo) {
            this.redirectAllRequestsTo = redirectAllRequestsTo;
            return this;
        }

        public final List<AwsS3BucketWebsiteConfigurationRoutingRule.Builder> getRoutingRules() {
            List<AwsS3BucketWebsiteConfigurationRoutingRule.Builder> result = AwsS3BucketWebsiteConfigurationRoutingRulesCopier.copyToBuilder(this.routingRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutingRules(Collection<AwsS3BucketWebsiteConfigurationRoutingRule.BuilderImpl> routingRules) {
            this.routingRules = AwsS3BucketWebsiteConfigurationRoutingRulesCopier.copyFromBuilder(routingRules);
        }

        @Override
        public final Builder routingRules(Collection<AwsS3BucketWebsiteConfigurationRoutingRule> routingRules) {
            this.routingRules = AwsS3BucketWebsiteConfigurationRoutingRulesCopier.copy(routingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingRules(AwsS3BucketWebsiteConfigurationRoutingRule ... routingRules) {
            this.routingRules(Arrays.asList(routingRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingRules(Consumer<AwsS3BucketWebsiteConfigurationRoutingRule.Builder> ... routingRules) {
            this.routingRules(Stream.of(routingRules).map(c -> (AwsS3BucketWebsiteConfigurationRoutingRule)((AwsS3BucketWebsiteConfigurationRoutingRule.Builder)AwsS3BucketWebsiteConfigurationRoutingRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AwsS3BucketWebsiteConfiguration build() {
            return new AwsS3BucketWebsiteConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsS3BucketWebsiteConfiguration> {
        public Builder errorDocument(String var1);

        public Builder indexDocumentSuffix(String var1);

        public Builder redirectAllRequestsTo(AwsS3BucketWebsiteConfigurationRedirectTo var1);

        default public Builder redirectAllRequestsTo(Consumer<AwsS3BucketWebsiteConfigurationRedirectTo.Builder> redirectAllRequestsTo) {
            return this.redirectAllRequestsTo((AwsS3BucketWebsiteConfigurationRedirectTo)((AwsS3BucketWebsiteConfigurationRedirectTo.Builder)AwsS3BucketWebsiteConfigurationRedirectTo.builder().applyMutation(redirectAllRequestsTo)).build());
        }

        public Builder routingRules(Collection<AwsS3BucketWebsiteConfigurationRoutingRule> var1);

        public Builder routingRules(AwsS3BucketWebsiteConfigurationRoutingRule ... var1);

        public Builder routingRules(Consumer<AwsS3BucketWebsiteConfigurationRoutingRule.Builder> ... var1);
    }
}

