/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.FindingProviderSeverity;
import software.amazon.awssdk.services.securityhub.model.RelatedFinding;
import software.amazon.awssdk.services.securityhub.model.RelatedFindingListCopier;
import software.amazon.awssdk.services.securityhub.model.TypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FindingProviderFields
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FindingProviderFields> {
    private static final SdkField<Integer> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Confidence").getter(FindingProviderFields.getter(FindingProviderFields::confidence)).setter(FindingProviderFields.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final SdkField<Integer> CRITICALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Criticality").getter(FindingProviderFields.getter(FindingProviderFields::criticality)).setter(FindingProviderFields.setter(Builder::criticality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criticality").build()}).build();
    private static final SdkField<List<RelatedFinding>> RELATED_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RelatedFindings").getter(FindingProviderFields.getter(FindingProviderFields::relatedFindings)).setter(FindingProviderFields.setter(Builder::relatedFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedFindings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelatedFinding::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<FindingProviderSeverity> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Severity").getter(FindingProviderFields.getter(FindingProviderFields::severity)).setter(FindingProviderFields.setter(Builder::severity)).constructor(FindingProviderSeverity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<List<String>> TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Types").getter(FindingProviderFields.getter(FindingProviderFields::types)).setter(FindingProviderFields.setter(Builder::types)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Types").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIDENCE_FIELD, CRITICALITY_FIELD, RELATED_FINDINGS_FIELD, SEVERITY_FIELD, TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FindingProviderFields.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer confidence;
    private final Integer criticality;
    private final List<RelatedFinding> relatedFindings;
    private final FindingProviderSeverity severity;
    private final List<String> types;

    private FindingProviderFields(BuilderImpl builder) {
        this.confidence = builder.confidence;
        this.criticality = builder.criticality;
        this.relatedFindings = builder.relatedFindings;
        this.severity = builder.severity;
        this.types = builder.types;
    }

    public final Integer confidence() {
        return this.confidence;
    }

    public final Integer criticality() {
        return this.criticality;
    }

    public final boolean hasRelatedFindings() {
        return this.relatedFindings != null && !(this.relatedFindings instanceof SdkAutoConstructList);
    }

    public final List<RelatedFinding> relatedFindings() {
        return this.relatedFindings;
    }

    public final FindingProviderSeverity severity() {
        return this.severity;
    }

    public final boolean hasTypes() {
        return this.types != null && !(this.types instanceof SdkAutoConstructList);
    }

    public final List<String> types() {
        return this.types;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.criticality());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedFindings() ? this.relatedFindings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTypes() ? this.types() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingProviderFields)) {
            return false;
        }
        FindingProviderFields other = (FindingProviderFields)obj;
        return Objects.equals(this.confidence(), other.confidence()) && Objects.equals(this.criticality(), other.criticality()) && this.hasRelatedFindings() == other.hasRelatedFindings() && Objects.equals(this.relatedFindings(), other.relatedFindings()) && Objects.equals(this.severity(), other.severity()) && this.hasTypes() == other.hasTypes() && Objects.equals(this.types(), other.types());
    }

    public final String toString() {
        return ToString.builder((String)"FindingProviderFields").add("Confidence", (Object)this.confidence()).add("Criticality", (Object)this.criticality()).add("RelatedFindings", this.hasRelatedFindings() ? this.relatedFindings() : null).add("Severity", (Object)this.severity()).add("Types", this.hasTypes() ? this.types() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "Criticality": {
                return Optional.ofNullable(clazz.cast(this.criticality()));
            }
            case "RelatedFindings": {
                return Optional.ofNullable(clazz.cast(this.relatedFindings()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "Types": {
                return Optional.ofNullable(clazz.cast(this.types()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Confidence", CONFIDENCE_FIELD);
        map.put("Criticality", CRITICALITY_FIELD);
        map.put("RelatedFindings", RELATED_FINDINGS_FIELD);
        map.put("Severity", SEVERITY_FIELD);
        map.put("Types", TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FindingProviderFields, T> g) {
        return obj -> g.apply((FindingProviderFields)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer confidence;
        private Integer criticality;
        private List<RelatedFinding> relatedFindings = DefaultSdkAutoConstructList.getInstance();
        private FindingProviderSeverity severity;
        private List<String> types = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FindingProviderFields model) {
            this.confidence(model.confidence);
            this.criticality(model.criticality);
            this.relatedFindings(model.relatedFindings);
            this.severity(model.severity);
            this.types(model.types);
        }

        public final Integer getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(Integer confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Integer confidence) {
            this.confidence = confidence;
            return this;
        }

        public final Integer getCriticality() {
            return this.criticality;
        }

        public final void setCriticality(Integer criticality) {
            this.criticality = criticality;
        }

        @Override
        public final Builder criticality(Integer criticality) {
            this.criticality = criticality;
            return this;
        }

        public final List<RelatedFinding.Builder> getRelatedFindings() {
            List<RelatedFinding.Builder> result = RelatedFindingListCopier.copyToBuilder(this.relatedFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelatedFindings(Collection<RelatedFinding.BuilderImpl> relatedFindings) {
            this.relatedFindings = RelatedFindingListCopier.copyFromBuilder(relatedFindings);
        }

        @Override
        public final Builder relatedFindings(Collection<RelatedFinding> relatedFindings) {
            this.relatedFindings = RelatedFindingListCopier.copy(relatedFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedFindings(RelatedFinding ... relatedFindings) {
            this.relatedFindings(Arrays.asList(relatedFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedFindings(Consumer<RelatedFinding.Builder> ... relatedFindings) {
            this.relatedFindings(Stream.of(relatedFindings).map(c -> (RelatedFinding)((RelatedFinding.Builder)RelatedFinding.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final FindingProviderSeverity.Builder getSeverity() {
            return this.severity != null ? this.severity.toBuilder() : null;
        }

        public final void setSeverity(FindingProviderSeverity.BuilderImpl severity) {
            this.severity = severity != null ? severity.build() : null;
        }

        @Override
        public final Builder severity(FindingProviderSeverity severity) {
            this.severity = severity;
            return this;
        }

        public final Collection<String> getTypes() {
            if (this.types instanceof SdkAutoConstructList) {
                return null;
            }
            return this.types;
        }

        public final void setTypes(Collection<String> types) {
            this.types = TypeListCopier.copy(types);
        }

        @Override
        public final Builder types(Collection<String> types) {
            this.types = TypeListCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(String ... types) {
            this.types(Arrays.asList(types));
            return this;
        }

        public FindingProviderFields build() {
            return new FindingProviderFields(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FindingProviderFields> {
        public Builder confidence(Integer var1);

        public Builder criticality(Integer var1);

        public Builder relatedFindings(Collection<RelatedFinding> var1);

        public Builder relatedFindings(RelatedFinding ... var1);

        public Builder relatedFindings(Consumer<RelatedFinding.Builder> ... var1);

        public Builder severity(FindingProviderSeverity var1);

        default public Builder severity(Consumer<FindingProviderSeverity.Builder> severity) {
            return this.severity((FindingProviderSeverity)((FindingProviderSeverity.Builder)FindingProviderSeverity.builder().applyMutation(severity)).build());
        }

        public Builder types(Collection<String> var1);

        public Builder types(String ... var1);
    }
}

