/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.services.securityhub.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFindingAggregatorResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, UpdateFindingAggregatorResponse> {
    private static final SdkField<String> FINDING_AGGREGATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FindingAggregatorArn").getter(UpdateFindingAggregatorResponse.getter(UpdateFindingAggregatorResponse::findingAggregatorArn)).setter(UpdateFindingAggregatorResponse.setter(Builder::findingAggregatorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingAggregatorArn").build()}).build();
    private static final SdkField<String> FINDING_AGGREGATION_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FindingAggregationRegion").getter(UpdateFindingAggregatorResponse.getter(UpdateFindingAggregatorResponse::findingAggregationRegion)).setter(UpdateFindingAggregatorResponse.setter(Builder::findingAggregationRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingAggregationRegion").build()}).build();
    private static final SdkField<String> REGION_LINKING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionLinkingMode").getter(UpdateFindingAggregatorResponse.getter(UpdateFindingAggregatorResponse::regionLinkingMode)).setter(UpdateFindingAggregatorResponse.setter(Builder::regionLinkingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionLinkingMode").build()}).build();
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Regions").getter(UpdateFindingAggregatorResponse.getter(UpdateFindingAggregatorResponse::regions)).setter(UpdateFindingAggregatorResponse.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_AGGREGATOR_ARN_FIELD, FINDING_AGGREGATION_REGION_FIELD, REGION_LINKING_MODE_FIELD, REGIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateFindingAggregatorResponse.memberNameToFieldInitializer();
    private final String findingAggregatorArn;
    private final String findingAggregationRegion;
    private final String regionLinkingMode;
    private final List<String> regions;

    private UpdateFindingAggregatorResponse(BuilderImpl builder) {
        super(builder);
        this.findingAggregatorArn = builder.findingAggregatorArn;
        this.findingAggregationRegion = builder.findingAggregationRegion;
        this.regionLinkingMode = builder.regionLinkingMode;
        this.regions = builder.regions;
    }

    public final String findingAggregatorArn() {
        return this.findingAggregatorArn;
    }

    public final String findingAggregationRegion() {
        return this.findingAggregationRegion;
    }

    public final String regionLinkingMode() {
        return this.regionLinkingMode;
    }

    public final boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public final List<String> regions() {
        return this.regions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.findingAggregatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingAggregationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionLinkingMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFindingAggregatorResponse)) {
            return false;
        }
        UpdateFindingAggregatorResponse other = (UpdateFindingAggregatorResponse)((Object)obj);
        return Objects.equals(this.findingAggregatorArn(), other.findingAggregatorArn()) && Objects.equals(this.findingAggregationRegion(), other.findingAggregationRegion()) && Objects.equals(this.regionLinkingMode(), other.regionLinkingMode()) && this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFindingAggregatorResponse").add("FindingAggregatorArn", (Object)this.findingAggregatorArn()).add("FindingAggregationRegion", (Object)this.findingAggregationRegion()).add("RegionLinkingMode", (Object)this.regionLinkingMode()).add("Regions", this.hasRegions() ? this.regions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FindingAggregatorArn": {
                return Optional.ofNullable(clazz.cast(this.findingAggregatorArn()));
            }
            case "FindingAggregationRegion": {
                return Optional.ofNullable(clazz.cast(this.findingAggregationRegion()));
            }
            case "RegionLinkingMode": {
                return Optional.ofNullable(clazz.cast(this.regionLinkingMode()));
            }
            case "Regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FindingAggregatorArn", FINDING_AGGREGATOR_ARN_FIELD);
        map.put("FindingAggregationRegion", FINDING_AGGREGATION_REGION_FIELD);
        map.put("RegionLinkingMode", REGION_LINKING_MODE_FIELD);
        map.put("Regions", REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFindingAggregatorResponse, T> g) {
        return obj -> g.apply((UpdateFindingAggregatorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private String findingAggregatorArn;
        private String findingAggregationRegion;
        private String regionLinkingMode;
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFindingAggregatorResponse model) {
            super(model);
            this.findingAggregatorArn(model.findingAggregatorArn);
            this.findingAggregationRegion(model.findingAggregationRegion);
            this.regionLinkingMode(model.regionLinkingMode);
            this.regions(model.regions);
        }

        public final String getFindingAggregatorArn() {
            return this.findingAggregatorArn;
        }

        public final void setFindingAggregatorArn(String findingAggregatorArn) {
            this.findingAggregatorArn = findingAggregatorArn;
        }

        @Override
        public final Builder findingAggregatorArn(String findingAggregatorArn) {
            this.findingAggregatorArn = findingAggregatorArn;
            return this;
        }

        public final String getFindingAggregationRegion() {
            return this.findingAggregationRegion;
        }

        public final void setFindingAggregationRegion(String findingAggregationRegion) {
            this.findingAggregationRegion = findingAggregationRegion;
        }

        @Override
        public final Builder findingAggregationRegion(String findingAggregationRegion) {
            this.findingAggregationRegion = findingAggregationRegion;
            return this;
        }

        public final String getRegionLinkingMode() {
            return this.regionLinkingMode;
        }

        public final void setRegionLinkingMode(String regionLinkingMode) {
            this.regionLinkingMode = regionLinkingMode;
        }

        @Override
        public final Builder regionLinkingMode(String regionLinkingMode) {
            this.regionLinkingMode = regionLinkingMode;
            return this;
        }

        public final Collection<String> getRegions() {
            if (this.regions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = StringListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = StringListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        @Override
        public UpdateFindingAggregatorResponse build() {
            return new UpdateFindingAggregatorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFindingAggregatorResponse> {
        public Builder findingAggregatorArn(String var1);

        public Builder findingAggregationRegion(String var1);

        public Builder regionLinkingMode(String var1);

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);
    }
}

