/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.ActionTarget;
import software.amazon.awssdk.services.securityhub.model.ActionTargetListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeActionTargetsResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, DescribeActionTargetsResponse> {
    private static final SdkField<List<ActionTarget>> ACTION_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ActionTargets").getter(DescribeActionTargetsResponse.getter(DescribeActionTargetsResponse::actionTargets)).setter(DescribeActionTargetsResponse.setter(Builder::actionTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeActionTargetsResponse.getter(DescribeActionTargetsResponse::nextToken)).setter(DescribeActionTargetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TARGETS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeActionTargetsResponse.memberNameToFieldInitializer();
    private final List<ActionTarget> actionTargets;
    private final String nextToken;

    private DescribeActionTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.actionTargets = builder.actionTargets;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasActionTargets() {
        return this.actionTargets != null && !(this.actionTargets instanceof SdkAutoConstructList);
    }

    public final List<ActionTarget> actionTargets() {
        return this.actionTargets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionTargets() ? this.actionTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActionTargetsResponse)) {
            return false;
        }
        DescribeActionTargetsResponse other = (DescribeActionTargetsResponse)((Object)obj);
        return this.hasActionTargets() == other.hasActionTargets() && Objects.equals(this.actionTargets(), other.actionTargets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeActionTargetsResponse").add("ActionTargets", this.hasActionTargets() ? this.actionTargets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionTargets": {
                return Optional.ofNullable(clazz.cast(this.actionTargets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ActionTargets", ACTION_TARGETS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeActionTargetsResponse, T> g) {
        return obj -> g.apply((DescribeActionTargetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<ActionTarget> actionTargets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActionTargetsResponse model) {
            super(model);
            this.actionTargets(model.actionTargets);
            this.nextToken(model.nextToken);
        }

        public final List<ActionTarget.Builder> getActionTargets() {
            List<ActionTarget.Builder> result = ActionTargetListCopier.copyToBuilder(this.actionTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionTargets(Collection<ActionTarget.BuilderImpl> actionTargets) {
            this.actionTargets = ActionTargetListCopier.copyFromBuilder(actionTargets);
        }

        @Override
        public final Builder actionTargets(Collection<ActionTarget> actionTargets) {
            this.actionTargets = ActionTargetListCopier.copy(actionTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionTargets(ActionTarget ... actionTargets) {
            this.actionTargets(Arrays.asList(actionTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionTargets(Consumer<ActionTarget.Builder> ... actionTargets) {
            this.actionTargets(Stream.of(actionTargets).map(c -> (ActionTarget)((ActionTarget.Builder)ActionTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeActionTargetsResponse build() {
            return new DescribeActionTargetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeActionTargetsResponse> {
        public Builder actionTargets(Collection<ActionTarget> var1);

        public Builder actionTargets(ActionTarget ... var1);

        public Builder actionTargets(Consumer<ActionTarget.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

