/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionEnvironmentError;
import software.amazon.awssdk.services.securityhub.model.FieldMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsLambdaFunctionEnvironment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsLambdaFunctionEnvironment> {
    private static final SdkField<Map<String, String>> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Variables").getter(AwsLambdaFunctionEnvironment.getter(AwsLambdaFunctionEnvironment::variables)).setter(AwsLambdaFunctionEnvironment.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Variables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AwsLambdaFunctionEnvironmentError> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Error").getter(AwsLambdaFunctionEnvironment.getter(AwsLambdaFunctionEnvironment::error)).setter(AwsLambdaFunctionEnvironment.setter(Builder::error)).constructor(AwsLambdaFunctionEnvironmentError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIABLES_FIELD, ERROR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsLambdaFunctionEnvironment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> variables;
    private final AwsLambdaFunctionEnvironmentError error;

    private AwsLambdaFunctionEnvironment(BuilderImpl builder) {
        this.variables = builder.variables;
        this.error = builder.error;
    }

    public final boolean hasVariables() {
        return this.variables != null && !(this.variables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> variables() {
        return this.variables;
    }

    public final AwsLambdaFunctionEnvironmentError error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariables() ? this.variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsLambdaFunctionEnvironment)) {
            return false;
        }
        AwsLambdaFunctionEnvironment other = (AwsLambdaFunctionEnvironment)obj;
        return this.hasVariables() == other.hasVariables() && Objects.equals(this.variables(), other.variables()) && Objects.equals(this.error(), other.error());
    }

    public final String toString() {
        return ToString.builder((String)"AwsLambdaFunctionEnvironment").add("Variables", this.hasVariables() ? this.variables() : null).add("Error", (Object)this.error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Variables", VARIABLES_FIELD);
        map.put("Error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsLambdaFunctionEnvironment, T> g) {
        return obj -> g.apply((AwsLambdaFunctionEnvironment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> variables = DefaultSdkAutoConstructMap.getInstance();
        private AwsLambdaFunctionEnvironmentError error;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsLambdaFunctionEnvironment model) {
            this.variables(model.variables);
            this.error(model.error);
        }

        public final Map<String, String> getVariables() {
            if (this.variables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.variables;
        }

        public final void setVariables(Map<String, String> variables) {
            this.variables = FieldMapCopier.copy(variables);
        }

        @Override
        public final Builder variables(Map<String, String> variables) {
            this.variables = FieldMapCopier.copy(variables);
            return this;
        }

        public final AwsLambdaFunctionEnvironmentError.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(AwsLambdaFunctionEnvironmentError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(AwsLambdaFunctionEnvironmentError error) {
            this.error = error;
            return this;
        }

        public AwsLambdaFunctionEnvironment build() {
            return new AwsLambdaFunctionEnvironment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsLambdaFunctionEnvironment> {
        public Builder variables(Map<String, String> var1);

        public Builder error(AwsLambdaFunctionEnvironmentError var1);

        default public Builder error(Consumer<AwsLambdaFunctionEnvironmentError.Builder> error) {
            return this.error((AwsLambdaFunctionEnvironmentError)((AwsLambdaFunctionEnvironmentError.Builder)AwsLambdaFunctionEnvironmentError.builder().applyMutation(error)).build());
        }
    }
}

