/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsS3BucketServerSideEncryptionByDefault
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsS3BucketServerSideEncryptionByDefault> {
    private static final SdkField<String> SSE_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SSEAlgorithm").getter(AwsS3BucketServerSideEncryptionByDefault.getter(AwsS3BucketServerSideEncryptionByDefault::sseAlgorithm)).setter(AwsS3BucketServerSideEncryptionByDefault.setter(Builder::sseAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSEAlgorithm").build()}).build();
    private static final SdkField<String> KMS_MASTER_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSMasterKeyID").getter(AwsS3BucketServerSideEncryptionByDefault.getter(AwsS3BucketServerSideEncryptionByDefault::kmsMasterKeyID)).setter(AwsS3BucketServerSideEncryptionByDefault.setter(Builder::kmsMasterKeyID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSMasterKeyID").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SSE_ALGORITHM_FIELD, KMS_MASTER_KEY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsS3BucketServerSideEncryptionByDefault.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sseAlgorithm;
    private final String kmsMasterKeyID;

    private AwsS3BucketServerSideEncryptionByDefault(BuilderImpl builder) {
        this.sseAlgorithm = builder.sseAlgorithm;
        this.kmsMasterKeyID = builder.kmsMasterKeyID;
    }

    public final String sseAlgorithm() {
        return this.sseAlgorithm;
    }

    public final String kmsMasterKeyID() {
        return this.kmsMasterKeyID;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sseAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsMasterKeyID());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketServerSideEncryptionByDefault)) {
            return false;
        }
        AwsS3BucketServerSideEncryptionByDefault other = (AwsS3BucketServerSideEncryptionByDefault)obj;
        return Objects.equals(this.sseAlgorithm(), other.sseAlgorithm()) && Objects.equals(this.kmsMasterKeyID(), other.kmsMasterKeyID());
    }

    public final String toString() {
        return ToString.builder((String)"AwsS3BucketServerSideEncryptionByDefault").add("SSEAlgorithm", (Object)this.sseAlgorithm()).add("KMSMasterKeyID", (Object)this.kmsMasterKeyID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SSEAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.sseAlgorithm()));
            }
            case "KMSMasterKeyID": {
                return Optional.ofNullable(clazz.cast(this.kmsMasterKeyID()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SSEAlgorithm", SSE_ALGORITHM_FIELD);
        map.put("KMSMasterKeyID", KMS_MASTER_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketServerSideEncryptionByDefault, T> g) {
        return obj -> g.apply((AwsS3BucketServerSideEncryptionByDefault)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sseAlgorithm;
        private String kmsMasterKeyID;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketServerSideEncryptionByDefault model) {
            this.sseAlgorithm(model.sseAlgorithm);
            this.kmsMasterKeyID(model.kmsMasterKeyID);
        }

        public final String getSseAlgorithm() {
            return this.sseAlgorithm;
        }

        public final void setSseAlgorithm(String sseAlgorithm) {
            this.sseAlgorithm = sseAlgorithm;
        }

        @Override
        public final Builder sseAlgorithm(String sseAlgorithm) {
            this.sseAlgorithm = sseAlgorithm;
            return this;
        }

        public final String getKmsMasterKeyID() {
            return this.kmsMasterKeyID;
        }

        public final void setKmsMasterKeyID(String kmsMasterKeyID) {
            this.kmsMasterKeyID = kmsMasterKeyID;
        }

        @Override
        public final Builder kmsMasterKeyID(String kmsMasterKeyID) {
            this.kmsMasterKeyID = kmsMasterKeyID;
            return this;
        }

        public AwsS3BucketServerSideEncryptionByDefault build() {
            return new AwsS3BucketServerSideEncryptionByDefault(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsS3BucketServerSideEncryptionByDefault> {
        public Builder sseAlgorithm(String var1);

        public Builder kmsMasterKeyID(String var1);
    }
}

