/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.AwsEfsAccessPointPosixUserDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEfsAccessPointRootDirectoryDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEfsAccessPointDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEfsAccessPointDetails> {
    private static final SdkField<String> ACCESS_POINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessPointId").getter(AwsEfsAccessPointDetails.getter(AwsEfsAccessPointDetails::accessPointId)).setter(AwsEfsAccessPointDetails.setter(Builder::accessPointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPointId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(AwsEfsAccessPointDetails.getter(AwsEfsAccessPointDetails::arn)).setter(AwsEfsAccessPointDetails.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(AwsEfsAccessPointDetails.getter(AwsEfsAccessPointDetails::clientToken)).setter(AwsEfsAccessPointDetails.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(AwsEfsAccessPointDetails.getter(AwsEfsAccessPointDetails::fileSystemId)).setter(AwsEfsAccessPointDetails.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()}).build();
    private static final SdkField<AwsEfsAccessPointPosixUserDetails> POSIX_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PosixUser").getter(AwsEfsAccessPointDetails.getter(AwsEfsAccessPointDetails::posixUser)).setter(AwsEfsAccessPointDetails.setter(Builder::posixUser)).constructor(AwsEfsAccessPointPosixUserDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PosixUser").build()}).build();
    private static final SdkField<AwsEfsAccessPointRootDirectoryDetails> ROOT_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RootDirectory").getter(AwsEfsAccessPointDetails.getter(AwsEfsAccessPointDetails::rootDirectory)).setter(AwsEfsAccessPointDetails.setter(Builder::rootDirectory)).constructor(AwsEfsAccessPointRootDirectoryDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDirectory").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POINT_ID_FIELD, ARN_FIELD, CLIENT_TOKEN_FIELD, FILE_SYSTEM_ID_FIELD, POSIX_USER_FIELD, ROOT_DIRECTORY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsEfsAccessPointDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accessPointId;
    private final String arn;
    private final String clientToken;
    private final String fileSystemId;
    private final AwsEfsAccessPointPosixUserDetails posixUser;
    private final AwsEfsAccessPointRootDirectoryDetails rootDirectory;

    private AwsEfsAccessPointDetails(BuilderImpl builder) {
        this.accessPointId = builder.accessPointId;
        this.arn = builder.arn;
        this.clientToken = builder.clientToken;
        this.fileSystemId = builder.fileSystemId;
        this.posixUser = builder.posixUser;
        this.rootDirectory = builder.rootDirectory;
    }

    public final String accessPointId() {
        return this.accessPointId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final AwsEfsAccessPointPosixUserDetails posixUser() {
        return this.posixUser;
    }

    public final AwsEfsAccessPointRootDirectoryDetails rootDirectory() {
        return this.rootDirectory;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.posixUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootDirectory());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEfsAccessPointDetails)) {
            return false;
        }
        AwsEfsAccessPointDetails other = (AwsEfsAccessPointDetails)obj;
        return Objects.equals(this.accessPointId(), other.accessPointId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.posixUser(), other.posixUser()) && Objects.equals(this.rootDirectory(), other.rootDirectory());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEfsAccessPointDetails").add("AccessPointId", (Object)this.accessPointId()).add("Arn", (Object)this.arn()).add("ClientToken", (Object)this.clientToken()).add("FileSystemId", (Object)this.fileSystemId()).add("PosixUser", (Object)this.posixUser()).add("RootDirectory", (Object)this.rootDirectory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessPointId": {
                return Optional.ofNullable(clazz.cast(this.accessPointId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "PosixUser": {
                return Optional.ofNullable(clazz.cast(this.posixUser()));
            }
            case "RootDirectory": {
                return Optional.ofNullable(clazz.cast(this.rootDirectory()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccessPointId", ACCESS_POINT_ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("FileSystemId", FILE_SYSTEM_ID_FIELD);
        map.put("PosixUser", POSIX_USER_FIELD);
        map.put("RootDirectory", ROOT_DIRECTORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEfsAccessPointDetails, T> g) {
        return obj -> g.apply((AwsEfsAccessPointDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessPointId;
        private String arn;
        private String clientToken;
        private String fileSystemId;
        private AwsEfsAccessPointPosixUserDetails posixUser;
        private AwsEfsAccessPointRootDirectoryDetails rootDirectory;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEfsAccessPointDetails model) {
            this.accessPointId(model.accessPointId);
            this.arn(model.arn);
            this.clientToken(model.clientToken);
            this.fileSystemId(model.fileSystemId);
            this.posixUser(model.posixUser);
            this.rootDirectory(model.rootDirectory);
        }

        public final String getAccessPointId() {
            return this.accessPointId;
        }

        public final void setAccessPointId(String accessPointId) {
            this.accessPointId = accessPointId;
        }

        @Override
        public final Builder accessPointId(String accessPointId) {
            this.accessPointId = accessPointId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final AwsEfsAccessPointPosixUserDetails.Builder getPosixUser() {
            return this.posixUser != null ? this.posixUser.toBuilder() : null;
        }

        public final void setPosixUser(AwsEfsAccessPointPosixUserDetails.BuilderImpl posixUser) {
            this.posixUser = posixUser != null ? posixUser.build() : null;
        }

        @Override
        public final Builder posixUser(AwsEfsAccessPointPosixUserDetails posixUser) {
            this.posixUser = posixUser;
            return this;
        }

        public final AwsEfsAccessPointRootDirectoryDetails.Builder getRootDirectory() {
            return this.rootDirectory != null ? this.rootDirectory.toBuilder() : null;
        }

        public final void setRootDirectory(AwsEfsAccessPointRootDirectoryDetails.BuilderImpl rootDirectory) {
            this.rootDirectory = rootDirectory != null ? rootDirectory.build() : null;
        }

        @Override
        public final Builder rootDirectory(AwsEfsAccessPointRootDirectoryDetails rootDirectory) {
            this.rootDirectory = rootDirectory;
            return this;
        }

        public AwsEfsAccessPointDetails build() {
            return new AwsEfsAccessPointDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEfsAccessPointDetails> {
        public Builder accessPointId(String var1);

        public Builder arn(String var1);

        public Builder clientToken(String var1);

        public Builder fileSystemId(String var1);

        public Builder posixUser(AwsEfsAccessPointPosixUserDetails var1);

        default public Builder posixUser(Consumer<AwsEfsAccessPointPosixUserDetails.Builder> posixUser) {
            return this.posixUser((AwsEfsAccessPointPosixUserDetails)((AwsEfsAccessPointPosixUserDetails.Builder)AwsEfsAccessPointPosixUserDetails.builder().applyMutation(posixUser)).build());
        }

        public Builder rootDirectory(AwsEfsAccessPointRootDirectoryDetails var1);

        default public Builder rootDirectory(Consumer<AwsEfsAccessPointRootDirectoryDetails.Builder> rootDirectory) {
            return this.rootDirectory((AwsEfsAccessPointRootDirectoryDetails)((AwsEfsAccessPointRootDirectoryDetails.Builder)AwsEfsAccessPointRootDirectoryDetails.builder().applyMutation(rootDirectory)).build());
        }
    }
}

