/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsCloudWatchAlarmDimensionsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsCloudWatchAlarmDimensionsListCopier;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsCloudWatchAlarmDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsCloudWatchAlarmDetails> {
    private static final SdkField<Boolean> ACTIONS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ActionsEnabled").getter(AwsCloudWatchAlarmDetails.getter(AwsCloudWatchAlarmDetails::actionsEnabled)).setter(AwsCloudWatchAlarmDetails.setter(Builder::actionsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionsEnabled").build()}).build();
    private static final SdkField<List<String>> ALARM_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AlarmActions").getter(AwsCloudWatchAlarmDetails.getter(AwsCloudWatchAlarmDetails::alarmActions)).setter(AwsCloudWatchAlarmDetails.setter(Builder::alarmActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ALARM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlarmArn").getter(AwsCloudWatchAlarmDetails.getter(AwsCloudWatchAlarmDetails::alarmArn)).setter(AwsCloudWatchAlarmDetails.setter(Builder::alarmArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmArn").build()}).build();
    private static final SdkField<String> ALARM_CONFIGURATION_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlarmConfigurationUpdatedTimestamp").getter(AwsCloudWatchAlarmDetails.getter(AwsCloudWatchAlarmDetails::alarmConfigurationUpdatedTimestamp)).setter(AwsCloudWatchAlarmDetails.setter(Builder::alarmConfigurationUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmConfigurationUpdatedTimestamp").build()}).build();
    private static final SdkField<String> ALARM_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlarmDescription").getter(AwsCloudWatchAlarmDetails.getter(AwsCloudWatchAlarmDetails::alarmDescription)).setter(AwsCloudWatchAlarmDetails.setter(Builder::alarmDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmDescription").build()}).build();
    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlarmName").getter(AwsCloudWatchAlarmDetails.getter(AwsCloudWatchAlarmDetails::alarmName)).setter(AwsCloudWatchAlarmDetails.setter(Builder::alarmName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmName").build()}).build();
    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComparisonOperator").getter(AwsCloudWatchAlarmDetails.getter(AwsCloudWatchAlarmDetails::comparisonOperator)).setter(AwsCloudWatchAlarmDetails.setter(Builder::comparisonOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonOperator").build()}).build();
    private static final SdkField<Integer> DATAPOINTS_TO_ALARM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DatapointsToAlarm").getter(AwsCloudWatchAlarmDetails.getter(AwsCloudWatchAlarmDetails::datapointsToAlarm)).setter(AwsCloudWatchAlarmDetails.setter(Builder::datapointsToAlarm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatapointsToAlarm").build()}).build();
    private static final SdkField<List<AwsCloudWatchAlarmDimensionsDetails>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Dimensions").getter(AwsCloudWatchAlarmDetails.getter(AwsCloudWatchAlarmDetails::dimensions)).setter(AwsCloudWatchAlarmDetails.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsCloudWatchAlarmDimensionsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EVALUATE_LOW_SAMPLE_COUNT_PERCENTILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluateLowSampleCountPercentile").getter(AwsCloudWatchAlarmDetails.getter(AwsCloudWatchAlarmDetails::evaluateLowSampleCountPercentile)).setter(AwsCloudWatchAlarmDetails.setter(Builder::evaluateLowSampleCountPercentile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluateLowSampleCountPercentile").build()}).build();
    private static final SdkField<Integer> EVALUATION_PERIODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EvaluationPeriods").getter(AwsCloudWatchAlarmDetails.getter(AwsCloudWatchAlarmDetails::evaluationPeriods)).setter(AwsCloudWatchAlarmDetails.setter(Builder::evaluationPeriods)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationPeriods").build()}).build();
    private static final SdkField<String> EXTENDED_STATISTIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExtendedStatistic").getter(AwsCloudWatchAlarmDetails.getter(AwsCloudWatchAlarmDetails::extendedStatistic)).setter(AwsCloudWatchAlarmDetails.setter(Builder::extendedStatistic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendedStatistic").build()}).build();
    private static final SdkField<List<String>> INSUFFICIENT_DATA_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InsufficientDataActions").getter(AwsCloudWatchAlarmDetails.getter(AwsCloudWatchAlarmDetails::insufficientDataActions)).setter(AwsCloudWatchAlarmDetails.setter(Builder::insufficientDataActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsufficientDataActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(AwsCloudWatchAlarmDetails.getter(AwsCloudWatchAlarmDetails::metricName)).setter(AwsCloudWatchAlarmDetails.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(AwsCloudWatchAlarmDetails.getter(AwsCloudWatchAlarmDetails::namespace)).setter(AwsCloudWatchAlarmDetails.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<List<String>> OK_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OkActions").getter(AwsCloudWatchAlarmDetails.getter(AwsCloudWatchAlarmDetails::okActions)).setter(AwsCloudWatchAlarmDetails.setter(Builder::okActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OkActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Period").getter(AwsCloudWatchAlarmDetails.getter(AwsCloudWatchAlarmDetails::period)).setter(AwsCloudWatchAlarmDetails.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()}).build();
    private static final SdkField<String> STATISTIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Statistic").getter(AwsCloudWatchAlarmDetails.getter(AwsCloudWatchAlarmDetails::statistic)).setter(AwsCloudWatchAlarmDetails.setter(Builder::statistic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistic").build()}).build();
    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Threshold").getter(AwsCloudWatchAlarmDetails.getter(AwsCloudWatchAlarmDetails::threshold)).setter(AwsCloudWatchAlarmDetails.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build()}).build();
    private static final SdkField<String> THRESHOLD_METRIC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThresholdMetricId").getter(AwsCloudWatchAlarmDetails.getter(AwsCloudWatchAlarmDetails::thresholdMetricId)).setter(AwsCloudWatchAlarmDetails.setter(Builder::thresholdMetricId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThresholdMetricId").build()}).build();
    private static final SdkField<String> TREAT_MISSING_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TreatMissingData").getter(AwsCloudWatchAlarmDetails.getter(AwsCloudWatchAlarmDetails::treatMissingData)).setter(AwsCloudWatchAlarmDetails.setter(Builder::treatMissingData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatMissingData").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Unit").getter(AwsCloudWatchAlarmDetails.getter(AwsCloudWatchAlarmDetails::unit)).setter(AwsCloudWatchAlarmDetails.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_ENABLED_FIELD, ALARM_ACTIONS_FIELD, ALARM_ARN_FIELD, ALARM_CONFIGURATION_UPDATED_TIMESTAMP_FIELD, ALARM_DESCRIPTION_FIELD, ALARM_NAME_FIELD, COMPARISON_OPERATOR_FIELD, DATAPOINTS_TO_ALARM_FIELD, DIMENSIONS_FIELD, EVALUATE_LOW_SAMPLE_COUNT_PERCENTILE_FIELD, EVALUATION_PERIODS_FIELD, EXTENDED_STATISTIC_FIELD, INSUFFICIENT_DATA_ACTIONS_FIELD, METRIC_NAME_FIELD, NAMESPACE_FIELD, OK_ACTIONS_FIELD, PERIOD_FIELD, STATISTIC_FIELD, THRESHOLD_FIELD, THRESHOLD_METRIC_ID_FIELD, TREAT_MISSING_DATA_FIELD, UNIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsCloudWatchAlarmDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean actionsEnabled;
    private final List<String> alarmActions;
    private final String alarmArn;
    private final String alarmConfigurationUpdatedTimestamp;
    private final String alarmDescription;
    private final String alarmName;
    private final String comparisonOperator;
    private final Integer datapointsToAlarm;
    private final List<AwsCloudWatchAlarmDimensionsDetails> dimensions;
    private final String evaluateLowSampleCountPercentile;
    private final Integer evaluationPeriods;
    private final String extendedStatistic;
    private final List<String> insufficientDataActions;
    private final String metricName;
    private final String namespace;
    private final List<String> okActions;
    private final Integer period;
    private final String statistic;
    private final Double threshold;
    private final String thresholdMetricId;
    private final String treatMissingData;
    private final String unit;

    private AwsCloudWatchAlarmDetails(BuilderImpl builder) {
        this.actionsEnabled = builder.actionsEnabled;
        this.alarmActions = builder.alarmActions;
        this.alarmArn = builder.alarmArn;
        this.alarmConfigurationUpdatedTimestamp = builder.alarmConfigurationUpdatedTimestamp;
        this.alarmDescription = builder.alarmDescription;
        this.alarmName = builder.alarmName;
        this.comparisonOperator = builder.comparisonOperator;
        this.datapointsToAlarm = builder.datapointsToAlarm;
        this.dimensions = builder.dimensions;
        this.evaluateLowSampleCountPercentile = builder.evaluateLowSampleCountPercentile;
        this.evaluationPeriods = builder.evaluationPeriods;
        this.extendedStatistic = builder.extendedStatistic;
        this.insufficientDataActions = builder.insufficientDataActions;
        this.metricName = builder.metricName;
        this.namespace = builder.namespace;
        this.okActions = builder.okActions;
        this.period = builder.period;
        this.statistic = builder.statistic;
        this.threshold = builder.threshold;
        this.thresholdMetricId = builder.thresholdMetricId;
        this.treatMissingData = builder.treatMissingData;
        this.unit = builder.unit;
    }

    public final Boolean actionsEnabled() {
        return this.actionsEnabled;
    }

    public final boolean hasAlarmActions() {
        return this.alarmActions != null && !(this.alarmActions instanceof SdkAutoConstructList);
    }

    public final List<String> alarmActions() {
        return this.alarmActions;
    }

    public final String alarmArn() {
        return this.alarmArn;
    }

    public final String alarmConfigurationUpdatedTimestamp() {
        return this.alarmConfigurationUpdatedTimestamp;
    }

    public final String alarmDescription() {
        return this.alarmDescription;
    }

    public final String alarmName() {
        return this.alarmName;
    }

    public final String comparisonOperator() {
        return this.comparisonOperator;
    }

    public final Integer datapointsToAlarm() {
        return this.datapointsToAlarm;
    }

    public final boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructList);
    }

    public final List<AwsCloudWatchAlarmDimensionsDetails> dimensions() {
        return this.dimensions;
    }

    public final String evaluateLowSampleCountPercentile() {
        return this.evaluateLowSampleCountPercentile;
    }

    public final Integer evaluationPeriods() {
        return this.evaluationPeriods;
    }

    public final String extendedStatistic() {
        return this.extendedStatistic;
    }

    public final boolean hasInsufficientDataActions() {
        return this.insufficientDataActions != null && !(this.insufficientDataActions instanceof SdkAutoConstructList);
    }

    public final List<String> insufficientDataActions() {
        return this.insufficientDataActions;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final boolean hasOkActions() {
        return this.okActions != null && !(this.okActions instanceof SdkAutoConstructList);
    }

    public final List<String> okActions() {
        return this.okActions;
    }

    public final Integer period() {
        return this.period;
    }

    public final String statistic() {
        return this.statistic;
    }

    public final Double threshold() {
        return this.threshold;
    }

    public final String thresholdMetricId() {
        return this.thresholdMetricId;
    }

    public final String treatMissingData() {
        return this.treatMissingData;
    }

    public final String unit() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlarmActions() ? this.alarmActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmConfigurationUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperator());
        hashCode = 31 * hashCode + Objects.hashCode(this.datapointsToAlarm());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluateLowSampleCountPercentile());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationPeriods());
        hashCode = 31 * hashCode + Objects.hashCode(this.extendedStatistic());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInsufficientDataActions() ? this.insufficientDataActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOkActions() ? this.okActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.statistic());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.thresholdMetricId());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatMissingData());
        hashCode = 31 * hashCode + Objects.hashCode(this.unit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudWatchAlarmDetails)) {
            return false;
        }
        AwsCloudWatchAlarmDetails other = (AwsCloudWatchAlarmDetails)obj;
        return Objects.equals(this.actionsEnabled(), other.actionsEnabled()) && this.hasAlarmActions() == other.hasAlarmActions() && Objects.equals(this.alarmActions(), other.alarmActions()) && Objects.equals(this.alarmArn(), other.alarmArn()) && Objects.equals(this.alarmConfigurationUpdatedTimestamp(), other.alarmConfigurationUpdatedTimestamp()) && Objects.equals(this.alarmDescription(), other.alarmDescription()) && Objects.equals(this.alarmName(), other.alarmName()) && Objects.equals(this.comparisonOperator(), other.comparisonOperator()) && Objects.equals(this.datapointsToAlarm(), other.datapointsToAlarm()) && this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.evaluateLowSampleCountPercentile(), other.evaluateLowSampleCountPercentile()) && Objects.equals(this.evaluationPeriods(), other.evaluationPeriods()) && Objects.equals(this.extendedStatistic(), other.extendedStatistic()) && this.hasInsufficientDataActions() == other.hasInsufficientDataActions() && Objects.equals(this.insufficientDataActions(), other.insufficientDataActions()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.namespace(), other.namespace()) && this.hasOkActions() == other.hasOkActions() && Objects.equals(this.okActions(), other.okActions()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.statistic(), other.statistic()) && Objects.equals(this.threshold(), other.threshold()) && Objects.equals(this.thresholdMetricId(), other.thresholdMetricId()) && Objects.equals(this.treatMissingData(), other.treatMissingData()) && Objects.equals(this.unit(), other.unit());
    }

    public final String toString() {
        return ToString.builder((String)"AwsCloudWatchAlarmDetails").add("ActionsEnabled", (Object)this.actionsEnabled()).add("AlarmActions", this.hasAlarmActions() ? this.alarmActions() : null).add("AlarmArn", (Object)this.alarmArn()).add("AlarmConfigurationUpdatedTimestamp", (Object)this.alarmConfigurationUpdatedTimestamp()).add("AlarmDescription", (Object)this.alarmDescription()).add("AlarmName", (Object)this.alarmName()).add("ComparisonOperator", (Object)this.comparisonOperator()).add("DatapointsToAlarm", (Object)this.datapointsToAlarm()).add("Dimensions", this.hasDimensions() ? this.dimensions() : null).add("EvaluateLowSampleCountPercentile", (Object)this.evaluateLowSampleCountPercentile()).add("EvaluationPeriods", (Object)this.evaluationPeriods()).add("ExtendedStatistic", (Object)this.extendedStatistic()).add("InsufficientDataActions", this.hasInsufficientDataActions() ? this.insufficientDataActions() : null).add("MetricName", (Object)this.metricName()).add("Namespace", (Object)this.namespace()).add("OkActions", this.hasOkActions() ? this.okActions() : null).add("Period", (Object)this.period()).add("Statistic", (Object)this.statistic()).add("Threshold", (Object)this.threshold()).add("ThresholdMetricId", (Object)this.thresholdMetricId()).add("TreatMissingData", (Object)this.treatMissingData()).add("Unit", (Object)this.unit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionsEnabled": {
                return Optional.ofNullable(clazz.cast(this.actionsEnabled()));
            }
            case "AlarmActions": {
                return Optional.ofNullable(clazz.cast(this.alarmActions()));
            }
            case "AlarmArn": {
                return Optional.ofNullable(clazz.cast(this.alarmArn()));
            }
            case "AlarmConfigurationUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.alarmConfigurationUpdatedTimestamp()));
            }
            case "AlarmDescription": {
                return Optional.ofNullable(clazz.cast(this.alarmDescription()));
            }
            case "AlarmName": {
                return Optional.ofNullable(clazz.cast(this.alarmName()));
            }
            case "ComparisonOperator": {
                return Optional.ofNullable(clazz.cast(this.comparisonOperator()));
            }
            case "DatapointsToAlarm": {
                return Optional.ofNullable(clazz.cast(this.datapointsToAlarm()));
            }
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "EvaluateLowSampleCountPercentile": {
                return Optional.ofNullable(clazz.cast(this.evaluateLowSampleCountPercentile()));
            }
            case "EvaluationPeriods": {
                return Optional.ofNullable(clazz.cast(this.evaluationPeriods()));
            }
            case "ExtendedStatistic": {
                return Optional.ofNullable(clazz.cast(this.extendedStatistic()));
            }
            case "InsufficientDataActions": {
                return Optional.ofNullable(clazz.cast(this.insufficientDataActions()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "OkActions": {
                return Optional.ofNullable(clazz.cast(this.okActions()));
            }
            case "Period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "Statistic": {
                return Optional.ofNullable(clazz.cast(this.statistic()));
            }
            case "Threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
            case "ThresholdMetricId": {
                return Optional.ofNullable(clazz.cast(this.thresholdMetricId()));
            }
            case "TreatMissingData": {
                return Optional.ofNullable(clazz.cast(this.treatMissingData()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ActionsEnabled", ACTIONS_ENABLED_FIELD);
        map.put("AlarmActions", ALARM_ACTIONS_FIELD);
        map.put("AlarmArn", ALARM_ARN_FIELD);
        map.put("AlarmConfigurationUpdatedTimestamp", ALARM_CONFIGURATION_UPDATED_TIMESTAMP_FIELD);
        map.put("AlarmDescription", ALARM_DESCRIPTION_FIELD);
        map.put("AlarmName", ALARM_NAME_FIELD);
        map.put("ComparisonOperator", COMPARISON_OPERATOR_FIELD);
        map.put("DatapointsToAlarm", DATAPOINTS_TO_ALARM_FIELD);
        map.put("Dimensions", DIMENSIONS_FIELD);
        map.put("EvaluateLowSampleCountPercentile", EVALUATE_LOW_SAMPLE_COUNT_PERCENTILE_FIELD);
        map.put("EvaluationPeriods", EVALUATION_PERIODS_FIELD);
        map.put("ExtendedStatistic", EXTENDED_STATISTIC_FIELD);
        map.put("InsufficientDataActions", INSUFFICIENT_DATA_ACTIONS_FIELD);
        map.put("MetricName", METRIC_NAME_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("OkActions", OK_ACTIONS_FIELD);
        map.put("Period", PERIOD_FIELD);
        map.put("Statistic", STATISTIC_FIELD);
        map.put("Threshold", THRESHOLD_FIELD);
        map.put("ThresholdMetricId", THRESHOLD_METRIC_ID_FIELD);
        map.put("TreatMissingData", TREAT_MISSING_DATA_FIELD);
        map.put("Unit", UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudWatchAlarmDetails, T> g) {
        return obj -> g.apply((AwsCloudWatchAlarmDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean actionsEnabled;
        private List<String> alarmActions = DefaultSdkAutoConstructList.getInstance();
        private String alarmArn;
        private String alarmConfigurationUpdatedTimestamp;
        private String alarmDescription;
        private String alarmName;
        private String comparisonOperator;
        private Integer datapointsToAlarm;
        private List<AwsCloudWatchAlarmDimensionsDetails> dimensions = DefaultSdkAutoConstructList.getInstance();
        private String evaluateLowSampleCountPercentile;
        private Integer evaluationPeriods;
        private String extendedStatistic;
        private List<String> insufficientDataActions = DefaultSdkAutoConstructList.getInstance();
        private String metricName;
        private String namespace;
        private List<String> okActions = DefaultSdkAutoConstructList.getInstance();
        private Integer period;
        private String statistic;
        private Double threshold;
        private String thresholdMetricId;
        private String treatMissingData;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudWatchAlarmDetails model) {
            this.actionsEnabled(model.actionsEnabled);
            this.alarmActions(model.alarmActions);
            this.alarmArn(model.alarmArn);
            this.alarmConfigurationUpdatedTimestamp(model.alarmConfigurationUpdatedTimestamp);
            this.alarmDescription(model.alarmDescription);
            this.alarmName(model.alarmName);
            this.comparisonOperator(model.comparisonOperator);
            this.datapointsToAlarm(model.datapointsToAlarm);
            this.dimensions(model.dimensions);
            this.evaluateLowSampleCountPercentile(model.evaluateLowSampleCountPercentile);
            this.evaluationPeriods(model.evaluationPeriods);
            this.extendedStatistic(model.extendedStatistic);
            this.insufficientDataActions(model.insufficientDataActions);
            this.metricName(model.metricName);
            this.namespace(model.namespace);
            this.okActions(model.okActions);
            this.period(model.period);
            this.statistic(model.statistic);
            this.threshold(model.threshold);
            this.thresholdMetricId(model.thresholdMetricId);
            this.treatMissingData(model.treatMissingData);
            this.unit(model.unit);
        }

        public final Boolean getActionsEnabled() {
            return this.actionsEnabled;
        }

        public final void setActionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
        }

        @Override
        public final Builder actionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
            return this;
        }

        public final Collection<String> getAlarmActions() {
            if (this.alarmActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.alarmActions;
        }

        public final void setAlarmActions(Collection<String> alarmActions) {
            this.alarmActions = NonEmptyStringListCopier.copy(alarmActions);
        }

        @Override
        public final Builder alarmActions(Collection<String> alarmActions) {
            this.alarmActions = NonEmptyStringListCopier.copy(alarmActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmActions(String ... alarmActions) {
            this.alarmActions(Arrays.asList(alarmActions));
            return this;
        }

        public final String getAlarmArn() {
            return this.alarmArn;
        }

        public final void setAlarmArn(String alarmArn) {
            this.alarmArn = alarmArn;
        }

        @Override
        public final Builder alarmArn(String alarmArn) {
            this.alarmArn = alarmArn;
            return this;
        }

        public final String getAlarmConfigurationUpdatedTimestamp() {
            return this.alarmConfigurationUpdatedTimestamp;
        }

        public final void setAlarmConfigurationUpdatedTimestamp(String alarmConfigurationUpdatedTimestamp) {
            this.alarmConfigurationUpdatedTimestamp = alarmConfigurationUpdatedTimestamp;
        }

        @Override
        public final Builder alarmConfigurationUpdatedTimestamp(String alarmConfigurationUpdatedTimestamp) {
            this.alarmConfigurationUpdatedTimestamp = alarmConfigurationUpdatedTimestamp;
            return this;
        }

        public final String getAlarmDescription() {
            return this.alarmDescription;
        }

        public final void setAlarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
        }

        @Override
        public final Builder alarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
            return this;
        }

        public final String getAlarmName() {
            return this.alarmName;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        public final Integer getDatapointsToAlarm() {
            return this.datapointsToAlarm;
        }

        public final void setDatapointsToAlarm(Integer datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
        }

        @Override
        public final Builder datapointsToAlarm(Integer datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
            return this;
        }

        public final List<AwsCloudWatchAlarmDimensionsDetails.Builder> getDimensions() {
            List<AwsCloudWatchAlarmDimensionsDetails.Builder> result = AwsCloudWatchAlarmDimensionsListCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<AwsCloudWatchAlarmDimensionsDetails.BuilderImpl> dimensions) {
            this.dimensions = AwsCloudWatchAlarmDimensionsListCopier.copyFromBuilder(dimensions);
        }

        @Override
        public final Builder dimensions(Collection<AwsCloudWatchAlarmDimensionsDetails> dimensions) {
            this.dimensions = AwsCloudWatchAlarmDimensionsListCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(AwsCloudWatchAlarmDimensionsDetails ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<AwsCloudWatchAlarmDimensionsDetails.Builder> ... dimensions) {
            this.dimensions(Stream.of(dimensions).map(c -> (AwsCloudWatchAlarmDimensionsDetails)((AwsCloudWatchAlarmDimensionsDetails.Builder)AwsCloudWatchAlarmDimensionsDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEvaluateLowSampleCountPercentile() {
            return this.evaluateLowSampleCountPercentile;
        }

        public final void setEvaluateLowSampleCountPercentile(String evaluateLowSampleCountPercentile) {
            this.evaluateLowSampleCountPercentile = evaluateLowSampleCountPercentile;
        }

        @Override
        public final Builder evaluateLowSampleCountPercentile(String evaluateLowSampleCountPercentile) {
            this.evaluateLowSampleCountPercentile = evaluateLowSampleCountPercentile;
            return this;
        }

        public final Integer getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final String getExtendedStatistic() {
            return this.extendedStatistic;
        }

        public final void setExtendedStatistic(String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
        }

        @Override
        public final Builder extendedStatistic(String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
            return this;
        }

        public final Collection<String> getInsufficientDataActions() {
            if (this.insufficientDataActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.insufficientDataActions;
        }

        public final void setInsufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = NonEmptyStringListCopier.copy(insufficientDataActions);
        }

        @Override
        public final Builder insufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = NonEmptyStringListCopier.copy(insufficientDataActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insufficientDataActions(String ... insufficientDataActions) {
            this.insufficientDataActions(Arrays.asList(insufficientDataActions));
            return this;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final Collection<String> getOkActions() {
            if (this.okActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.okActions;
        }

        public final void setOkActions(Collection<String> okActions) {
            this.okActions = NonEmptyStringListCopier.copy(okActions);
        }

        @Override
        public final Builder okActions(Collection<String> okActions) {
            this.okActions = NonEmptyStringListCopier.copy(okActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder okActions(String ... okActions) {
            this.okActions(Arrays.asList(okActions));
            return this;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final String getStatistic() {
            return this.statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        public final Double getThreshold() {
            return this.threshold;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final String getThresholdMetricId() {
            return this.thresholdMetricId;
        }

        public final void setThresholdMetricId(String thresholdMetricId) {
            this.thresholdMetricId = thresholdMetricId;
        }

        @Override
        public final Builder thresholdMetricId(String thresholdMetricId) {
            this.thresholdMetricId = thresholdMetricId;
            return this;
        }

        public final String getTreatMissingData() {
            return this.treatMissingData;
        }

        public final void setTreatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
        }

        @Override
        public final Builder treatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public AwsCloudWatchAlarmDetails build() {
            return new AwsCloudWatchAlarmDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsCloudWatchAlarmDetails> {
        public Builder actionsEnabled(Boolean var1);

        public Builder alarmActions(Collection<String> var1);

        public Builder alarmActions(String ... var1);

        public Builder alarmArn(String var1);

        public Builder alarmConfigurationUpdatedTimestamp(String var1);

        public Builder alarmDescription(String var1);

        public Builder alarmName(String var1);

        public Builder comparisonOperator(String var1);

        public Builder datapointsToAlarm(Integer var1);

        public Builder dimensions(Collection<AwsCloudWatchAlarmDimensionsDetails> var1);

        public Builder dimensions(AwsCloudWatchAlarmDimensionsDetails ... var1);

        public Builder dimensions(Consumer<AwsCloudWatchAlarmDimensionsDetails.Builder> ... var1);

        public Builder evaluateLowSampleCountPercentile(String var1);

        public Builder evaluationPeriods(Integer var1);

        public Builder extendedStatistic(String var1);

        public Builder insufficientDataActions(Collection<String> var1);

        public Builder insufficientDataActions(String ... var1);

        public Builder metricName(String var1);

        public Builder namespace(String var1);

        public Builder okActions(Collection<String> var1);

        public Builder okActions(String ... var1);

        public Builder period(Integer var1);

        public Builder statistic(String var1);

        public Builder threshold(Double var1);

        public Builder thresholdMetricId(String var1);

        public Builder treatMissingData(String var1);

        public Builder unit(String var1);
    }
}

