/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionOptionsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionRoutesDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionRoutesListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionVgwTelemetryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2VpnConnectionDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2VpnConnectionDetails> {
    private static final SdkField<String> VPN_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpnConnectionId").getter(AwsEc2VpnConnectionDetails.getter(AwsEc2VpnConnectionDetails::vpnConnectionId)).setter(AwsEc2VpnConnectionDetails.setter(Builder::vpnConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(AwsEc2VpnConnectionDetails.getter(AwsEc2VpnConnectionDetails::state)).setter(AwsEc2VpnConnectionDetails.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> CUSTOMER_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerGatewayId").getter(AwsEc2VpnConnectionDetails.getter(AwsEc2VpnConnectionDetails::customerGatewayId)).setter(AwsEc2VpnConnectionDetails.setter(Builder::customerGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerGatewayId").build()}).build();
    private static final SdkField<String> CUSTOMER_GATEWAY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerGatewayConfiguration").getter(AwsEc2VpnConnectionDetails.getter(AwsEc2VpnConnectionDetails::customerGatewayConfiguration)).setter(AwsEc2VpnConnectionDetails.setter(Builder::customerGatewayConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerGatewayConfiguration").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(AwsEc2VpnConnectionDetails.getter(AwsEc2VpnConnectionDetails::type)).setter(AwsEc2VpnConnectionDetails.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> VPN_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpnGatewayId").getter(AwsEc2VpnConnectionDetails.getter(AwsEc2VpnConnectionDetails::vpnGatewayId)).setter(AwsEc2VpnConnectionDetails.setter(Builder::vpnGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnGatewayId").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(AwsEc2VpnConnectionDetails.getter(AwsEc2VpnConnectionDetails::category)).setter(AwsEc2VpnConnectionDetails.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<List<AwsEc2VpnConnectionVgwTelemetryDetails>> VGW_TELEMETRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VgwTelemetry").getter(AwsEc2VpnConnectionDetails.getter(AwsEc2VpnConnectionDetails::vgwTelemetry)).setter(AwsEc2VpnConnectionDetails.setter(Builder::vgwTelemetry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VgwTelemetry").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEc2VpnConnectionVgwTelemetryDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AwsEc2VpnConnectionOptionsDetails> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Options").getter(AwsEc2VpnConnectionDetails.getter(AwsEc2VpnConnectionDetails::options)).setter(AwsEc2VpnConnectionDetails.setter(Builder::options)).constructor(AwsEc2VpnConnectionOptionsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()}).build();
    private static final SdkField<List<AwsEc2VpnConnectionRoutesDetails>> ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Routes").getter(AwsEc2VpnConnectionDetails.getter(AwsEc2VpnConnectionDetails::routes)).setter(AwsEc2VpnConnectionDetails.setter(Builder::routes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Routes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEc2VpnConnectionRoutesDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayId").getter(AwsEc2VpnConnectionDetails.getter(AwsEc2VpnConnectionDetails::transitGatewayId)).setter(AwsEc2VpnConnectionDetails.setter(Builder::transitGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPN_CONNECTION_ID_FIELD, STATE_FIELD, CUSTOMER_GATEWAY_ID_FIELD, CUSTOMER_GATEWAY_CONFIGURATION_FIELD, TYPE_FIELD, VPN_GATEWAY_ID_FIELD, CATEGORY_FIELD, VGW_TELEMETRY_FIELD, OPTIONS_FIELD, ROUTES_FIELD, TRANSIT_GATEWAY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsEc2VpnConnectionDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String vpnConnectionId;
    private final String state;
    private final String customerGatewayId;
    private final String customerGatewayConfiguration;
    private final String type;
    private final String vpnGatewayId;
    private final String category;
    private final List<AwsEc2VpnConnectionVgwTelemetryDetails> vgwTelemetry;
    private final AwsEc2VpnConnectionOptionsDetails options;
    private final List<AwsEc2VpnConnectionRoutesDetails> routes;
    private final String transitGatewayId;

    private AwsEc2VpnConnectionDetails(BuilderImpl builder) {
        this.vpnConnectionId = builder.vpnConnectionId;
        this.state = builder.state;
        this.customerGatewayId = builder.customerGatewayId;
        this.customerGatewayConfiguration = builder.customerGatewayConfiguration;
        this.type = builder.type;
        this.vpnGatewayId = builder.vpnGatewayId;
        this.category = builder.category;
        this.vgwTelemetry = builder.vgwTelemetry;
        this.options = builder.options;
        this.routes = builder.routes;
        this.transitGatewayId = builder.transitGatewayId;
    }

    public final String vpnConnectionId() {
        return this.vpnConnectionId;
    }

    public final String state() {
        return this.state;
    }

    public final String customerGatewayId() {
        return this.customerGatewayId;
    }

    public final String customerGatewayConfiguration() {
        return this.customerGatewayConfiguration;
    }

    public final String type() {
        return this.type;
    }

    public final String vpnGatewayId() {
        return this.vpnGatewayId;
    }

    public final String category() {
        return this.category;
    }

    public final boolean hasVgwTelemetry() {
        return this.vgwTelemetry != null && !(this.vgwTelemetry instanceof SdkAutoConstructList);
    }

    public final List<AwsEc2VpnConnectionVgwTelemetryDetails> vgwTelemetry() {
        return this.vgwTelemetry;
    }

    public final AwsEc2VpnConnectionOptionsDetails options() {
        return this.options;
    }

    public final boolean hasRoutes() {
        return this.routes != null && !(this.routes instanceof SdkAutoConstructList);
    }

    public final List<AwsEc2VpnConnectionRoutesDetails> routes() {
        return this.routes;
    }

    public final String transitGatewayId() {
        return this.transitGatewayId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerGatewayConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVgwTelemetry() ? this.vgwTelemetry() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutes() ? this.routes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2VpnConnectionDetails)) {
            return false;
        }
        AwsEc2VpnConnectionDetails other = (AwsEc2VpnConnectionDetails)obj;
        return Objects.equals(this.vpnConnectionId(), other.vpnConnectionId()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.customerGatewayId(), other.customerGatewayId()) && Objects.equals(this.customerGatewayConfiguration(), other.customerGatewayConfiguration()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.vpnGatewayId(), other.vpnGatewayId()) && Objects.equals(this.category(), other.category()) && this.hasVgwTelemetry() == other.hasVgwTelemetry() && Objects.equals(this.vgwTelemetry(), other.vgwTelemetry()) && Objects.equals(this.options(), other.options()) && this.hasRoutes() == other.hasRoutes() && Objects.equals(this.routes(), other.routes()) && Objects.equals(this.transitGatewayId(), other.transitGatewayId());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEc2VpnConnectionDetails").add("VpnConnectionId", (Object)this.vpnConnectionId()).add("State", (Object)this.state()).add("CustomerGatewayId", (Object)this.customerGatewayId()).add("CustomerGatewayConfiguration", (Object)this.customerGatewayConfiguration()).add("Type", (Object)this.type()).add("VpnGatewayId", (Object)this.vpnGatewayId()).add("Category", (Object)this.category()).add("VgwTelemetry", this.hasVgwTelemetry() ? this.vgwTelemetry() : null).add("Options", (Object)this.options()).add("Routes", this.hasRoutes() ? this.routes() : null).add("TransitGatewayId", (Object)this.transitGatewayId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpnConnectionId": {
                return Optional.ofNullable(clazz.cast(this.vpnConnectionId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "CustomerGatewayId": {
                return Optional.ofNullable(clazz.cast(this.customerGatewayId()));
            }
            case "CustomerGatewayConfiguration": {
                return Optional.ofNullable(clazz.cast(this.customerGatewayConfiguration()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "VpnGatewayId": {
                return Optional.ofNullable(clazz.cast(this.vpnGatewayId()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "VgwTelemetry": {
                return Optional.ofNullable(clazz.cast(this.vgwTelemetry()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "Routes": {
                return Optional.ofNullable(clazz.cast(this.routes()));
            }
            case "TransitGatewayId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VpnConnectionId", VPN_CONNECTION_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("CustomerGatewayId", CUSTOMER_GATEWAY_ID_FIELD);
        map.put("CustomerGatewayConfiguration", CUSTOMER_GATEWAY_CONFIGURATION_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("VpnGatewayId", VPN_GATEWAY_ID_FIELD);
        map.put("Category", CATEGORY_FIELD);
        map.put("VgwTelemetry", VGW_TELEMETRY_FIELD);
        map.put("Options", OPTIONS_FIELD);
        map.put("Routes", ROUTES_FIELD);
        map.put("TransitGatewayId", TRANSIT_GATEWAY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2VpnConnectionDetails, T> g) {
        return obj -> g.apply((AwsEc2VpnConnectionDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vpnConnectionId;
        private String state;
        private String customerGatewayId;
        private String customerGatewayConfiguration;
        private String type;
        private String vpnGatewayId;
        private String category;
        private List<AwsEc2VpnConnectionVgwTelemetryDetails> vgwTelemetry = DefaultSdkAutoConstructList.getInstance();
        private AwsEc2VpnConnectionOptionsDetails options;
        private List<AwsEc2VpnConnectionRoutesDetails> routes = DefaultSdkAutoConstructList.getInstance();
        private String transitGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2VpnConnectionDetails model) {
            this.vpnConnectionId(model.vpnConnectionId);
            this.state(model.state);
            this.customerGatewayId(model.customerGatewayId);
            this.customerGatewayConfiguration(model.customerGatewayConfiguration);
            this.type(model.type);
            this.vpnGatewayId(model.vpnGatewayId);
            this.category(model.category);
            this.vgwTelemetry(model.vgwTelemetry);
            this.options(model.options);
            this.routes(model.routes);
            this.transitGatewayId(model.transitGatewayId);
        }

        public final String getVpnConnectionId() {
            return this.vpnConnectionId;
        }

        public final void setVpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
        }

        @Override
        public final Builder vpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getCustomerGatewayId() {
            return this.customerGatewayId;
        }

        public final void setCustomerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
        }

        @Override
        public final Builder customerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
            return this;
        }

        public final String getCustomerGatewayConfiguration() {
            return this.customerGatewayConfiguration;
        }

        public final void setCustomerGatewayConfiguration(String customerGatewayConfiguration) {
            this.customerGatewayConfiguration = customerGatewayConfiguration;
        }

        @Override
        public final Builder customerGatewayConfiguration(String customerGatewayConfiguration) {
            this.customerGatewayConfiguration = customerGatewayConfiguration;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getVpnGatewayId() {
            return this.vpnGatewayId;
        }

        public final void setVpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
        }

        @Override
        public final Builder vpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final List<AwsEc2VpnConnectionVgwTelemetryDetails.Builder> getVgwTelemetry() {
            List<AwsEc2VpnConnectionVgwTelemetryDetails.Builder> result = AwsEc2VpnConnectionVgwTelemetryListCopier.copyToBuilder(this.vgwTelemetry);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVgwTelemetry(Collection<AwsEc2VpnConnectionVgwTelemetryDetails.BuilderImpl> vgwTelemetry) {
            this.vgwTelemetry = AwsEc2VpnConnectionVgwTelemetryListCopier.copyFromBuilder(vgwTelemetry);
        }

        @Override
        public final Builder vgwTelemetry(Collection<AwsEc2VpnConnectionVgwTelemetryDetails> vgwTelemetry) {
            this.vgwTelemetry = AwsEc2VpnConnectionVgwTelemetryListCopier.copy(vgwTelemetry);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vgwTelemetry(AwsEc2VpnConnectionVgwTelemetryDetails ... vgwTelemetry) {
            this.vgwTelemetry(Arrays.asList(vgwTelemetry));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vgwTelemetry(Consumer<AwsEc2VpnConnectionVgwTelemetryDetails.Builder> ... vgwTelemetry) {
            this.vgwTelemetry(Stream.of(vgwTelemetry).map(c -> (AwsEc2VpnConnectionVgwTelemetryDetails)((AwsEc2VpnConnectionVgwTelemetryDetails.Builder)AwsEc2VpnConnectionVgwTelemetryDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AwsEc2VpnConnectionOptionsDetails.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        public final void setOptions(AwsEc2VpnConnectionOptionsDetails.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(AwsEc2VpnConnectionOptionsDetails options) {
            this.options = options;
            return this;
        }

        public final List<AwsEc2VpnConnectionRoutesDetails.Builder> getRoutes() {
            List<AwsEc2VpnConnectionRoutesDetails.Builder> result = AwsEc2VpnConnectionRoutesListCopier.copyToBuilder(this.routes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutes(Collection<AwsEc2VpnConnectionRoutesDetails.BuilderImpl> routes) {
            this.routes = AwsEc2VpnConnectionRoutesListCopier.copyFromBuilder(routes);
        }

        @Override
        public final Builder routes(Collection<AwsEc2VpnConnectionRoutesDetails> routes) {
            this.routes = AwsEc2VpnConnectionRoutesListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(AwsEc2VpnConnectionRoutesDetails ... routes) {
            this.routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<AwsEc2VpnConnectionRoutesDetails.Builder> ... routes) {
            this.routes(Stream.of(routes).map(c -> (AwsEc2VpnConnectionRoutesDetails)((AwsEc2VpnConnectionRoutesDetails.Builder)AwsEc2VpnConnectionRoutesDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public AwsEc2VpnConnectionDetails build() {
            return new AwsEc2VpnConnectionDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2VpnConnectionDetails> {
        public Builder vpnConnectionId(String var1);

        public Builder state(String var1);

        public Builder customerGatewayId(String var1);

        public Builder customerGatewayConfiguration(String var1);

        public Builder type(String var1);

        public Builder vpnGatewayId(String var1);

        public Builder category(String var1);

        public Builder vgwTelemetry(Collection<AwsEc2VpnConnectionVgwTelemetryDetails> var1);

        public Builder vgwTelemetry(AwsEc2VpnConnectionVgwTelemetryDetails ... var1);

        public Builder vgwTelemetry(Consumer<AwsEc2VpnConnectionVgwTelemetryDetails.Builder> ... var1);

        public Builder options(AwsEc2VpnConnectionOptionsDetails var1);

        default public Builder options(Consumer<AwsEc2VpnConnectionOptionsDetails.Builder> options) {
            return this.options((AwsEc2VpnConnectionOptionsDetails)((AwsEc2VpnConnectionOptionsDetails.Builder)AwsEc2VpnConnectionOptionsDetails.builder().applyMutation(options)).build());
        }

        public Builder routes(Collection<AwsEc2VpnConnectionRoutesDetails> var1);

        public Builder routes(AwsEc2VpnConnectionRoutesDetails ... var1);

        public Builder routes(Consumer<AwsEc2VpnConnectionRoutesDetails.Builder> ... var1);

        public Builder transitGatewayId(String var1);
    }
}

