/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.ActionListCopier;
import software.amazon.awssdk.services.securityhub.model.AutomationRulesAction;
import software.amazon.awssdk.services.securityhub.model.AutomationRulesFindingFilters;
import software.amazon.awssdk.services.securityhub.model.RuleStatus;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.services.securityhub.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAutomationRuleRequest
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, CreateAutomationRuleRequest> {
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateAutomationRuleRequest.getter(CreateAutomationRuleRequest::tags)).setter(CreateAutomationRuleRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RULE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleStatus").getter(CreateAutomationRuleRequest.getter(CreateAutomationRuleRequest::ruleStatusAsString)).setter(CreateAutomationRuleRequest.setter(Builder::ruleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleStatus").build()}).build();
    private static final SdkField<Integer> RULE_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RuleOrder").getter(CreateAutomationRuleRequest.getter(CreateAutomationRuleRequest::ruleOrder)).setter(CreateAutomationRuleRequest.setter(Builder::ruleOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleOrder").build()}).build();
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleName").getter(CreateAutomationRuleRequest.getter(CreateAutomationRuleRequest::ruleName)).setter(CreateAutomationRuleRequest.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateAutomationRuleRequest.getter(CreateAutomationRuleRequest::description)).setter(CreateAutomationRuleRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> IS_TERMINAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsTerminal").getter(CreateAutomationRuleRequest.getter(CreateAutomationRuleRequest::isTerminal)).setter(CreateAutomationRuleRequest.setter(Builder::isTerminal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTerminal").build()}).build();
    private static final SdkField<AutomationRulesFindingFilters> CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Criteria").getter(CreateAutomationRuleRequest.getter(CreateAutomationRuleRequest::criteria)).setter(CreateAutomationRuleRequest.setter(Builder::criteria)).constructor(AutomationRulesFindingFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criteria").build()}).build();
    private static final SdkField<List<AutomationRulesAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(CreateAutomationRuleRequest.getter(CreateAutomationRuleRequest::actions)).setter(CreateAutomationRuleRequest.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomationRulesAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGS_FIELD, RULE_STATUS_FIELD, RULE_ORDER_FIELD, RULE_NAME_FIELD, DESCRIPTION_FIELD, IS_TERMINAL_FIELD, CRITERIA_FIELD, ACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Tags", TAGS_FIELD);
            this.put("RuleStatus", RULE_STATUS_FIELD);
            this.put("RuleOrder", RULE_ORDER_FIELD);
            this.put("RuleName", RULE_NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("IsTerminal", IS_TERMINAL_FIELD);
            this.put("Criteria", CRITERIA_FIELD);
            this.put("Actions", ACTIONS_FIELD);
        }
    });
    private final Map<String, String> tags;
    private final String ruleStatus;
    private final Integer ruleOrder;
    private final String ruleName;
    private final String description;
    private final Boolean isTerminal;
    private final AutomationRulesFindingFilters criteria;
    private final List<AutomationRulesAction> actions;

    private CreateAutomationRuleRequest(BuilderImpl builder) {
        super(builder);
        this.tags = builder.tags;
        this.ruleStatus = builder.ruleStatus;
        this.ruleOrder = builder.ruleOrder;
        this.ruleName = builder.ruleName;
        this.description = builder.description;
        this.isTerminal = builder.isTerminal;
        this.criteria = builder.criteria;
        this.actions = builder.actions;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final RuleStatus ruleStatus() {
        return RuleStatus.fromValue(this.ruleStatus);
    }

    public final String ruleStatusAsString() {
        return this.ruleStatus;
    }

    public final Integer ruleOrder() {
        return this.ruleOrder;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean isTerminal() {
        return this.isTerminal;
    }

    public final AutomationRulesFindingFilters criteria() {
        return this.criteria;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<AutomationRulesAction> actions() {
        return this.actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTerminal());
        hashCode = 31 * hashCode + Objects.hashCode(this.criteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAutomationRuleRequest)) {
            return false;
        }
        CreateAutomationRuleRequest other = (CreateAutomationRuleRequest)((Object)obj);
        return this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.ruleStatusAsString(), other.ruleStatusAsString()) && Objects.equals(this.ruleOrder(), other.ruleOrder()) && Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.isTerminal(), other.isTerminal()) && Objects.equals(this.criteria(), other.criteria()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAutomationRuleRequest").add("Tags", this.hasTags() ? this.tags() : null).add("RuleStatus", (Object)this.ruleStatusAsString()).add("RuleOrder", (Object)this.ruleOrder()).add("RuleName", (Object)this.ruleName()).add("Description", (Object)this.description()).add("IsTerminal", (Object)this.isTerminal()).add("Criteria", (Object)this.criteria()).add("Actions", this.hasActions() ? this.actions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "RuleStatus": {
                return Optional.ofNullable(clazz.cast(this.ruleStatusAsString()));
            }
            case "RuleOrder": {
                return Optional.ofNullable(clazz.cast(this.ruleOrder()));
            }
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "IsTerminal": {
                return Optional.ofNullable(clazz.cast(this.isTerminal()));
            }
            case "Criteria": {
                return Optional.ofNullable(clazz.cast(this.criteria()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateAutomationRuleRequest, T> g) {
        return obj -> g.apply((CreateAutomationRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String ruleStatus;
        private Integer ruleOrder;
        private String ruleName;
        private String description;
        private Boolean isTerminal;
        private AutomationRulesFindingFilters criteria;
        private List<AutomationRulesAction> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAutomationRuleRequest model) {
            super(model);
            this.tags(model.tags);
            this.ruleStatus(model.ruleStatus);
            this.ruleOrder(model.ruleOrder);
            this.ruleName(model.ruleName);
            this.description(model.description);
            this.isTerminal(model.isTerminal);
            this.criteria(model.criteria);
            this.actions(model.actions);
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getRuleStatus() {
            return this.ruleStatus;
        }

        public final void setRuleStatus(String ruleStatus) {
            this.ruleStatus = ruleStatus;
        }

        @Override
        public final Builder ruleStatus(String ruleStatus) {
            this.ruleStatus = ruleStatus;
            return this;
        }

        @Override
        public final Builder ruleStatus(RuleStatus ruleStatus) {
            this.ruleStatus(ruleStatus == null ? null : ruleStatus.toString());
            return this;
        }

        public final Integer getRuleOrder() {
            return this.ruleOrder;
        }

        public final void setRuleOrder(Integer ruleOrder) {
            this.ruleOrder = ruleOrder;
        }

        @Override
        public final Builder ruleOrder(Integer ruleOrder) {
            this.ruleOrder = ruleOrder;
            return this;
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getIsTerminal() {
            return this.isTerminal;
        }

        public final void setIsTerminal(Boolean isTerminal) {
            this.isTerminal = isTerminal;
        }

        @Override
        public final Builder isTerminal(Boolean isTerminal) {
            this.isTerminal = isTerminal;
            return this;
        }

        public final AutomationRulesFindingFilters.Builder getCriteria() {
            return this.criteria != null ? this.criteria.toBuilder() : null;
        }

        public final void setCriteria(AutomationRulesFindingFilters.BuilderImpl criteria) {
            this.criteria = criteria != null ? criteria.build() : null;
        }

        @Override
        public final Builder criteria(AutomationRulesFindingFilters criteria) {
            this.criteria = criteria;
            return this;
        }

        public final List<AutomationRulesAction.Builder> getActions() {
            List<AutomationRulesAction.Builder> result = ActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<AutomationRulesAction.BuilderImpl> actions) {
            this.actions = ActionListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<AutomationRulesAction> actions) {
            this.actions = ActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(AutomationRulesAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<AutomationRulesAction.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (AutomationRulesAction)((AutomationRulesAction.Builder)AutomationRulesAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAutomationRuleRequest build() {
            return new CreateAutomationRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAutomationRuleRequest> {
        public Builder tags(Map<String, String> var1);

        public Builder ruleStatus(String var1);

        public Builder ruleStatus(RuleStatus var1);

        public Builder ruleOrder(Integer var1);

        public Builder ruleName(String var1);

        public Builder description(String var1);

        public Builder isTerminal(Boolean var1);

        public Builder criteria(AutomationRulesFindingFilters var1);

        default public Builder criteria(Consumer<AutomationRulesFindingFilters.Builder> criteria) {
            return this.criteria((AutomationRulesFindingFilters)((AutomationRulesFindingFilters.Builder)AutomationRulesFindingFilters.builder().applyMutation(criteria)).build());
        }

        public Builder actions(Collection<AutomationRulesAction> var1);

        public Builder actions(AutomationRulesAction ... var1);

        public Builder actions(Consumer<AutomationRulesAction.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

