/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsEcsContainerDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEcsContainerDetailsListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsEcsTaskVolumeDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEcsTaskVolumeDetailsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEcsTaskDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEcsTaskDetails> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(AwsEcsTaskDetails.getter(AwsEcsTaskDetails::clusterArn)).setter(AwsEcsTaskDetails.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()}).build();
    private static final SdkField<String> TASK_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskDefinitionArn").getter(AwsEcsTaskDetails.getter(AwsEcsTaskDetails::taskDefinitionArn)).setter(AwsEcsTaskDetails.setter(Builder::taskDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskDefinitionArn").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(AwsEcsTaskDetails.getter(AwsEcsTaskDetails::version)).setter(AwsEcsTaskDetails.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<String> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedAt").getter(AwsEcsTaskDetails.getter(AwsEcsTaskDetails::createdAt)).setter(AwsEcsTaskDetails.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartedAt").getter(AwsEcsTaskDetails.getter(AwsEcsTaskDetails::startedAt)).setter(AwsEcsTaskDetails.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build()}).build();
    private static final SdkField<String> STARTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartedBy").getter(AwsEcsTaskDetails.getter(AwsEcsTaskDetails::startedBy)).setter(AwsEcsTaskDetails.setter(Builder::startedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedBy").build()}).build();
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Group").getter(AwsEcsTaskDetails.getter(AwsEcsTaskDetails::group)).setter(AwsEcsTaskDetails.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()}).build();
    private static final SdkField<List<AwsEcsTaskVolumeDetails>> VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Volumes").getter(AwsEcsTaskDetails.getter(AwsEcsTaskDetails::volumes)).setter(AwsEcsTaskDetails.setter(Builder::volumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Volumes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEcsTaskVolumeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AwsEcsContainerDetails>> CONTAINERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Containers").getter(AwsEcsTaskDetails.getter(AwsEcsTaskDetails::containers)).setter(AwsEcsTaskDetails.setter(Builder::containers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Containers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEcsContainerDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, TASK_DEFINITION_ARN_FIELD, VERSION_FIELD, CREATED_AT_FIELD, STARTED_AT_FIELD, STARTED_BY_FIELD, GROUP_FIELD, VOLUMES_FIELD, CONTAINERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ClusterArn", CLUSTER_ARN_FIELD);
            this.put("TaskDefinitionArn", TASK_DEFINITION_ARN_FIELD);
            this.put("Version", VERSION_FIELD);
            this.put("CreatedAt", CREATED_AT_FIELD);
            this.put("StartedAt", STARTED_AT_FIELD);
            this.put("StartedBy", STARTED_BY_FIELD);
            this.put("Group", GROUP_FIELD);
            this.put("Volumes", VOLUMES_FIELD);
            this.put("Containers", CONTAINERS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String clusterArn;
    private final String taskDefinitionArn;
    private final String version;
    private final String createdAt;
    private final String startedAt;
    private final String startedBy;
    private final String group;
    private final List<AwsEcsTaskVolumeDetails> volumes;
    private final List<AwsEcsContainerDetails> containers;

    private AwsEcsTaskDetails(BuilderImpl builder) {
        this.clusterArn = builder.clusterArn;
        this.taskDefinitionArn = builder.taskDefinitionArn;
        this.version = builder.version;
        this.createdAt = builder.createdAt;
        this.startedAt = builder.startedAt;
        this.startedBy = builder.startedBy;
        this.group = builder.group;
        this.volumes = builder.volumes;
        this.containers = builder.containers;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final String taskDefinitionArn() {
        return this.taskDefinitionArn;
    }

    public final String version() {
        return this.version;
    }

    public final String createdAt() {
        return this.createdAt;
    }

    public final String startedAt() {
        return this.startedAt;
    }

    public final String startedBy() {
        return this.startedBy;
    }

    public final String group() {
        return this.group;
    }

    public final boolean hasVolumes() {
        return this.volumes != null && !(this.volumes instanceof SdkAutoConstructList);
    }

    public final List<AwsEcsTaskVolumeDetails> volumes() {
        return this.volumes;
    }

    public final boolean hasContainers() {
        return this.containers != null && !(this.containers instanceof SdkAutoConstructList);
    }

    public final List<AwsEcsContainerDetails> containers() {
        return this.containers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumes() ? this.volumes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainers() ? this.containers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDetails)) {
            return false;
        }
        AwsEcsTaskDetails other = (AwsEcsTaskDetails)obj;
        return Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.taskDefinitionArn(), other.taskDefinitionArn()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.startedBy(), other.startedBy()) && Objects.equals(this.group(), other.group()) && this.hasVolumes() == other.hasVolumes() && Objects.equals(this.volumes(), other.volumes()) && this.hasContainers() == other.hasContainers() && Objects.equals(this.containers(), other.containers());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEcsTaskDetails").add("ClusterArn", (Object)this.clusterArn()).add("TaskDefinitionArn", (Object)this.taskDefinitionArn()).add("Version", (Object)this.version()).add("CreatedAt", (Object)this.createdAt()).add("StartedAt", (Object)this.startedAt()).add("StartedBy", (Object)this.startedBy()).add("Group", (Object)this.group()).add("Volumes", this.hasVolumes() ? this.volumes() : null).add("Containers", this.hasContainers() ? this.containers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "TaskDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.taskDefinitionArn()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "StartedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "StartedBy": {
                return Optional.ofNullable(clazz.cast(this.startedBy()));
            }
            case "Group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "Volumes": {
                return Optional.ofNullable(clazz.cast(this.volumes()));
            }
            case "Containers": {
                return Optional.ofNullable(clazz.cast(this.containers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsTaskDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterArn;
        private String taskDefinitionArn;
        private String version;
        private String createdAt;
        private String startedAt;
        private String startedBy;
        private String group;
        private List<AwsEcsTaskVolumeDetails> volumes = DefaultSdkAutoConstructList.getInstance();
        private List<AwsEcsContainerDetails> containers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDetails model) {
            this.clusterArn(model.clusterArn);
            this.taskDefinitionArn(model.taskDefinitionArn);
            this.version(model.version);
            this.createdAt(model.createdAt);
            this.startedAt(model.startedAt);
            this.startedBy(model.startedBy);
            this.group(model.group);
            this.volumes(model.volumes);
            this.containers(model.containers);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getTaskDefinitionArn() {
            return this.taskDefinitionArn;
        }

        public final void setTaskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
        }

        @Override
        public final Builder taskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(String startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(String startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getStartedBy() {
            return this.startedBy;
        }

        public final void setStartedBy(String startedBy) {
            this.startedBy = startedBy;
        }

        @Override
        public final Builder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        public final String getGroup() {
            return this.group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final List<AwsEcsTaskVolumeDetails.Builder> getVolumes() {
            List<AwsEcsTaskVolumeDetails.Builder> result = AwsEcsTaskVolumeDetailsListCopier.copyToBuilder(this.volumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumes(Collection<AwsEcsTaskVolumeDetails.BuilderImpl> volumes) {
            this.volumes = AwsEcsTaskVolumeDetailsListCopier.copyFromBuilder(volumes);
        }

        @Override
        public final Builder volumes(Collection<AwsEcsTaskVolumeDetails> volumes) {
            this.volumes = AwsEcsTaskVolumeDetailsListCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(AwsEcsTaskVolumeDetails ... volumes) {
            this.volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<AwsEcsTaskVolumeDetails.Builder> ... volumes) {
            this.volumes(Stream.of(volumes).map(c -> (AwsEcsTaskVolumeDetails)((AwsEcsTaskVolumeDetails.Builder)AwsEcsTaskVolumeDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AwsEcsContainerDetails.Builder> getContainers() {
            List<AwsEcsContainerDetails.Builder> result = AwsEcsContainerDetailsListCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<AwsEcsContainerDetails.BuilderImpl> containers) {
            this.containers = AwsEcsContainerDetailsListCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<AwsEcsContainerDetails> containers) {
            this.containers = AwsEcsContainerDetailsListCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(AwsEcsContainerDetails ... containers) {
            this.containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<AwsEcsContainerDetails.Builder> ... containers) {
            this.containers(Stream.of(containers).map(c -> (AwsEcsContainerDetails)((AwsEcsContainerDetails.Builder)AwsEcsContainerDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AwsEcsTaskDetails build() {
            return new AwsEcsTaskDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEcsTaskDetails> {
        public Builder clusterArn(String var1);

        public Builder taskDefinitionArn(String var1);

        public Builder version(String var1);

        public Builder createdAt(String var1);

        public Builder startedAt(String var1);

        public Builder startedBy(String var1);

        public Builder group(String var1);

        public Builder volumes(Collection<AwsEcsTaskVolumeDetails> var1);

        public Builder volumes(AwsEcsTaskVolumeDetails ... var1);

        public Builder volumes(Consumer<AwsEcsTaskVolumeDetails.Builder> ... var1);

        public Builder containers(Collection<AwsEcsContainerDetails> var1);

        public Builder containers(AwsEcsContainerDetails ... var1);

        public Builder containers(Consumer<AwsEcsContainerDetails.Builder> ... var1);
    }
}

