/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.Product;

final class ProductsListCopier {
    ProductsListCopier() {
    }

    static List<Product> copy(Collection<? extends Product> productsListParam) {
        Object list;
        if (productsListParam == null || productsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(productsListParam.size());
            productsListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Product> copyFromBuilder(Collection<? extends Product.Builder> productsListParam) {
        Object list;
        if (productsListParam == null || productsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(productsListParam.size());
            productsListParam.forEach(entry -> {
                Product member = entry == null ? null : (Product)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Product.Builder> copyToBuilder(Collection<? extends Product> productsListParam) {
        Object list;
        if (productsListParam == null || productsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(productsListParam.size());
            productsListParam.forEach(entry -> {
                Product.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

