/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.StandardsInputParameterMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StandardsSubscriptionRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StandardsSubscriptionRequest> {
    private static final SdkField<String> STANDARDS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StandardsArn").getter(StandardsSubscriptionRequest.getter(StandardsSubscriptionRequest::standardsArn)).setter(StandardsSubscriptionRequest.setter(Builder::standardsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsArn").build()}).build();
    private static final SdkField<Map<String, String>> STANDARDS_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("StandardsInput").getter(StandardsSubscriptionRequest.getter(StandardsSubscriptionRequest::standardsInput)).setter(StandardsSubscriptionRequest.setter(Builder::standardsInput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsInput").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARDS_ARN_FIELD, STANDARDS_INPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StandardsArn", STANDARDS_ARN_FIELD);
            this.put("StandardsInput", STANDARDS_INPUT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String standardsArn;
    private final Map<String, String> standardsInput;

    private StandardsSubscriptionRequest(BuilderImpl builder) {
        this.standardsArn = builder.standardsArn;
        this.standardsInput = builder.standardsInput;
    }

    public final String standardsArn() {
        return this.standardsArn;
    }

    public final boolean hasStandardsInput() {
        return this.standardsInput != null && !(this.standardsInput instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> standardsInput() {
        return this.standardsInput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.standardsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStandardsInput() ? this.standardsInput() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandardsSubscriptionRequest)) {
            return false;
        }
        StandardsSubscriptionRequest other = (StandardsSubscriptionRequest)obj;
        return Objects.equals(this.standardsArn(), other.standardsArn()) && this.hasStandardsInput() == other.hasStandardsInput() && Objects.equals(this.standardsInput(), other.standardsInput());
    }

    public final String toString() {
        return ToString.builder((String)"StandardsSubscriptionRequest").add("StandardsArn", (Object)this.standardsArn()).add("StandardsInput", this.hasStandardsInput() ? this.standardsInput() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StandardsArn": {
                return Optional.ofNullable(clazz.cast(this.standardsArn()));
            }
            case "StandardsInput": {
                return Optional.ofNullable(clazz.cast(this.standardsInput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StandardsSubscriptionRequest, T> g) {
        return obj -> g.apply((StandardsSubscriptionRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String standardsArn;
        private Map<String, String> standardsInput = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StandardsSubscriptionRequest model) {
            this.standardsArn(model.standardsArn);
            this.standardsInput(model.standardsInput);
        }

        public final String getStandardsArn() {
            return this.standardsArn;
        }

        public final void setStandardsArn(String standardsArn) {
            this.standardsArn = standardsArn;
        }

        @Override
        public final Builder standardsArn(String standardsArn) {
            this.standardsArn = standardsArn;
            return this;
        }

        public final Map<String, String> getStandardsInput() {
            if (this.standardsInput instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.standardsInput;
        }

        public final void setStandardsInput(Map<String, String> standardsInput) {
            this.standardsInput = StandardsInputParameterMapCopier.copy(standardsInput);
        }

        @Override
        public final Builder standardsInput(Map<String, String> standardsInput) {
            this.standardsInput = StandardsInputParameterMapCopier.copy(standardsInput);
            return this;
        }

        public StandardsSubscriptionRequest build() {
            return new StandardsSubscriptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StandardsSubscriptionRequest> {
        public Builder standardsArn(String var1);

        public Builder standardsInput(Map<String, String> var1);
    }
}

