/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.RuleGroupSourceCustomActionsDetails;
import software.amazon.awssdk.services.securityhub.model.RuleGroupSourceCustomActionsListCopier;
import software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRulesDetails;
import software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRulesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleGroupSourceStatelessRulesAndCustomActionsDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleGroupSourceStatelessRulesAndCustomActionsDetails> {
    private static final SdkField<List<RuleGroupSourceCustomActionsDetails>> CUSTOM_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomActions").getter(RuleGroupSourceStatelessRulesAndCustomActionsDetails.getter(RuleGroupSourceStatelessRulesAndCustomActionsDetails::customActions)).setter(RuleGroupSourceStatelessRulesAndCustomActionsDetails.setter(Builder::customActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleGroupSourceCustomActionsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RuleGroupSourceStatelessRulesDetails>> STATELESS_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatelessRules").getter(RuleGroupSourceStatelessRulesAndCustomActionsDetails.getter(RuleGroupSourceStatelessRulesAndCustomActionsDetails::statelessRules)).setter(RuleGroupSourceStatelessRulesAndCustomActionsDetails.setter(Builder::statelessRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleGroupSourceStatelessRulesDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_ACTIONS_FIELD, STATELESS_RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CustomActions", CUSTOM_ACTIONS_FIELD);
            this.put("StatelessRules", STATELESS_RULES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<RuleGroupSourceCustomActionsDetails> customActions;
    private final List<RuleGroupSourceStatelessRulesDetails> statelessRules;

    private RuleGroupSourceStatelessRulesAndCustomActionsDetails(BuilderImpl builder) {
        this.customActions = builder.customActions;
        this.statelessRules = builder.statelessRules;
    }

    public final boolean hasCustomActions() {
        return this.customActions != null && !(this.customActions instanceof SdkAutoConstructList);
    }

    public final List<RuleGroupSourceCustomActionsDetails> customActions() {
        return this.customActions;
    }

    public final boolean hasStatelessRules() {
        return this.statelessRules != null && !(this.statelessRules instanceof SdkAutoConstructList);
    }

    public final List<RuleGroupSourceStatelessRulesDetails> statelessRules() {
        return this.statelessRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomActions() ? this.customActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatelessRules() ? this.statelessRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupSourceStatelessRulesAndCustomActionsDetails)) {
            return false;
        }
        RuleGroupSourceStatelessRulesAndCustomActionsDetails other = (RuleGroupSourceStatelessRulesAndCustomActionsDetails)obj;
        return this.hasCustomActions() == other.hasCustomActions() && Objects.equals(this.customActions(), other.customActions()) && this.hasStatelessRules() == other.hasStatelessRules() && Objects.equals(this.statelessRules(), other.statelessRules());
    }

    public final String toString() {
        return ToString.builder((String)"RuleGroupSourceStatelessRulesAndCustomActionsDetails").add("CustomActions", this.hasCustomActions() ? this.customActions() : null).add("StatelessRules", this.hasStatelessRules() ? this.statelessRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomActions": {
                return Optional.ofNullable(clazz.cast(this.customActions()));
            }
            case "StatelessRules": {
                return Optional.ofNullable(clazz.cast(this.statelessRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupSourceStatelessRulesAndCustomActionsDetails, T> g) {
        return obj -> g.apply((RuleGroupSourceStatelessRulesAndCustomActionsDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<RuleGroupSourceCustomActionsDetails> customActions = DefaultSdkAutoConstructList.getInstance();
        private List<RuleGroupSourceStatelessRulesDetails> statelessRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupSourceStatelessRulesAndCustomActionsDetails model) {
            this.customActions(model.customActions);
            this.statelessRules(model.statelessRules);
        }

        public final List<RuleGroupSourceCustomActionsDetails.Builder> getCustomActions() {
            List<RuleGroupSourceCustomActionsDetails.Builder> result = RuleGroupSourceCustomActionsListCopier.copyToBuilder(this.customActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomActions(Collection<RuleGroupSourceCustomActionsDetails.BuilderImpl> customActions) {
            this.customActions = RuleGroupSourceCustomActionsListCopier.copyFromBuilder(customActions);
        }

        @Override
        public final Builder customActions(Collection<RuleGroupSourceCustomActionsDetails> customActions) {
            this.customActions = RuleGroupSourceCustomActionsListCopier.copy(customActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customActions(RuleGroupSourceCustomActionsDetails ... customActions) {
            this.customActions(Arrays.asList(customActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customActions(Consumer<RuleGroupSourceCustomActionsDetails.Builder> ... customActions) {
            this.customActions(Stream.of(customActions).map(c -> (RuleGroupSourceCustomActionsDetails)((RuleGroupSourceCustomActionsDetails.Builder)RuleGroupSourceCustomActionsDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RuleGroupSourceStatelessRulesDetails.Builder> getStatelessRules() {
            List<RuleGroupSourceStatelessRulesDetails.Builder> result = RuleGroupSourceStatelessRulesListCopier.copyToBuilder(this.statelessRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatelessRules(Collection<RuleGroupSourceStatelessRulesDetails.BuilderImpl> statelessRules) {
            this.statelessRules = RuleGroupSourceStatelessRulesListCopier.copyFromBuilder(statelessRules);
        }

        @Override
        public final Builder statelessRules(Collection<RuleGroupSourceStatelessRulesDetails> statelessRules) {
            this.statelessRules = RuleGroupSourceStatelessRulesListCopier.copy(statelessRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessRules(RuleGroupSourceStatelessRulesDetails ... statelessRules) {
            this.statelessRules(Arrays.asList(statelessRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessRules(Consumer<RuleGroupSourceStatelessRulesDetails.Builder> ... statelessRules) {
            this.statelessRules(Stream.of(statelessRules).map(c -> (RuleGroupSourceStatelessRulesDetails)((RuleGroupSourceStatelessRulesDetails.Builder)RuleGroupSourceStatelessRulesDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RuleGroupSourceStatelessRulesAndCustomActionsDetails build() {
            return new RuleGroupSourceStatelessRulesAndCustomActionsDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleGroupSourceStatelessRulesAndCustomActionsDetails> {
        public Builder customActions(Collection<RuleGroupSourceCustomActionsDetails> var1);

        public Builder customActions(RuleGroupSourceCustomActionsDetails ... var1);

        public Builder customActions(Consumer<RuleGroupSourceCustomActionsDetails.Builder> ... var1);

        public Builder statelessRules(Collection<RuleGroupSourceStatelessRulesDetails> var1);

        public Builder statelessRules(RuleGroupSourceStatelessRulesDetails ... var1);

        public Builder statelessRules(Consumer<RuleGroupSourceStatelessRulesDetails.Builder> ... var1);
    }
}

