/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.PortRange;
import software.amazon.awssdk.services.securityhub.model.PortRangeListCopier;
import software.amazon.awssdk.services.securityhub.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkPathComponentDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkPathComponentDetails> {
    private static final SdkField<List<String>> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Address").getter(NetworkPathComponentDetails.getter(NetworkPathComponentDetails::address)).setter(NetworkPathComponentDetails.setter(Builder::address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PortRange>> PORT_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PortRanges").getter(NetworkPathComponentDetails.getter(NetworkPathComponentDetails::portRanges)).setter(NetworkPathComponentDetails.setter(Builder::portRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD, PORT_RANGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Address", ADDRESS_FIELD);
            this.put("PortRanges", PORT_RANGES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> address;
    private final List<PortRange> portRanges;

    private NetworkPathComponentDetails(BuilderImpl builder) {
        this.address = builder.address;
        this.portRanges = builder.portRanges;
    }

    public final boolean hasAddress() {
        return this.address != null && !(this.address instanceof SdkAutoConstructList);
    }

    public final List<String> address() {
        return this.address;
    }

    public final boolean hasPortRanges() {
        return this.portRanges != null && !(this.portRanges instanceof SdkAutoConstructList);
    }

    public final List<PortRange> portRanges() {
        return this.portRanges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddress() ? this.address() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPortRanges() ? this.portRanges() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkPathComponentDetails)) {
            return false;
        }
        NetworkPathComponentDetails other = (NetworkPathComponentDetails)obj;
        return this.hasAddress() == other.hasAddress() && Objects.equals(this.address(), other.address()) && this.hasPortRanges() == other.hasPortRanges() && Objects.equals(this.portRanges(), other.portRanges());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkPathComponentDetails").add("Address", this.hasAddress() ? this.address() : null).add("PortRanges", this.hasPortRanges() ? this.portRanges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "PortRanges": {
                return Optional.ofNullable(clazz.cast(this.portRanges()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NetworkPathComponentDetails, T> g) {
        return obj -> g.apply((NetworkPathComponentDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> address = DefaultSdkAutoConstructList.getInstance();
        private List<PortRange> portRanges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkPathComponentDetails model) {
            this.address(model.address);
            this.portRanges(model.portRanges);
        }

        public final Collection<String> getAddress() {
            if (this.address instanceof SdkAutoConstructList) {
                return null;
            }
            return this.address;
        }

        public final void setAddress(Collection<String> address) {
            this.address = StringListCopier.copy(address);
        }

        @Override
        public final Builder address(Collection<String> address) {
            this.address = StringListCopier.copy(address);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder address(String ... address) {
            this.address(Arrays.asList(address));
            return this;
        }

        public final List<PortRange.Builder> getPortRanges() {
            List<PortRange.Builder> result = PortRangeListCopier.copyToBuilder(this.portRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPortRanges(Collection<PortRange.BuilderImpl> portRanges) {
            this.portRanges = PortRangeListCopier.copyFromBuilder(portRanges);
        }

        @Override
        public final Builder portRanges(Collection<PortRange> portRanges) {
            this.portRanges = PortRangeListCopier.copy(portRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(PortRange ... portRanges) {
            this.portRanges(Arrays.asList(portRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(Consumer<PortRange.Builder> ... portRanges) {
            this.portRanges(Stream.of(portRanges).map(c -> (PortRange)((PortRange.Builder)PortRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public NetworkPathComponentDetails build() {
            return new NetworkPathComponentDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkPathComponentDetails> {
        public Builder address(Collection<String> var1);

        public Builder address(String ... var1);

        public Builder portRanges(Collection<PortRange> var1);

        public Builder portRanges(PortRange ... var1);

        public Builder portRanges(Consumer<PortRange.Builder> ... var1);
    }
}

