/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails;
import software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails;
import software.amazon.awssdk.services.securityhub.model.FieldMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsOpenSearchServiceDomainDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsOpenSearchServiceDomainDetails> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(AwsOpenSearchServiceDomainDetails.getter(AwsOpenSearchServiceDomainDetails::arn)).setter(AwsOpenSearchServiceDomainDetails.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ACCESS_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessPolicies").getter(AwsOpenSearchServiceDomainDetails.getter(AwsOpenSearchServiceDomainDetails::accessPolicies)).setter(AwsOpenSearchServiceDomainDetails.setter(Builder::accessPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPolicies").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(AwsOpenSearchServiceDomainDetails.getter(AwsOpenSearchServiceDomainDetails::domainName)).setter(AwsOpenSearchServiceDomainDetails.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(AwsOpenSearchServiceDomainDetails.getter(AwsOpenSearchServiceDomainDetails::id)).setter(AwsOpenSearchServiceDomainDetails.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> DOMAIN_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainEndpoint").getter(AwsOpenSearchServiceDomainDetails.getter(AwsOpenSearchServiceDomainDetails::domainEndpoint)).setter(AwsOpenSearchServiceDomainDetails.setter(Builder::domainEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpoint").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(AwsOpenSearchServiceDomainDetails.getter(AwsOpenSearchServiceDomainDetails::engineVersion)).setter(AwsOpenSearchServiceDomainDetails.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails> ENCRYPTION_AT_REST_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionAtRestOptions").getter(AwsOpenSearchServiceDomainDetails.getter(AwsOpenSearchServiceDomainDetails::encryptionAtRestOptions)).setter(AwsOpenSearchServiceDomainDetails.setter(Builder::encryptionAtRestOptions)).constructor(AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRestOptions").build()}).build();
    private static final SdkField<AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails> NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NodeToNodeEncryptionOptions").getter(AwsOpenSearchServiceDomainDetails.getter(AwsOpenSearchServiceDomainDetails::nodeToNodeEncryptionOptions)).setter(AwsOpenSearchServiceDomainDetails.setter(Builder::nodeToNodeEncryptionOptions)).constructor(AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeToNodeEncryptionOptions").build()}).build();
    private static final SdkField<AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails> SERVICE_SOFTWARE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceSoftwareOptions").getter(AwsOpenSearchServiceDomainDetails.getter(AwsOpenSearchServiceDomainDetails::serviceSoftwareOptions)).setter(AwsOpenSearchServiceDomainDetails.setter(Builder::serviceSoftwareOptions)).constructor(AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSoftwareOptions").build()}).build();
    private static final SdkField<AwsOpenSearchServiceDomainClusterConfigDetails> CLUSTER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClusterConfig").getter(AwsOpenSearchServiceDomainDetails.getter(AwsOpenSearchServiceDomainDetails::clusterConfig)).setter(AwsOpenSearchServiceDomainDetails.setter(Builder::clusterConfig)).constructor(AwsOpenSearchServiceDomainClusterConfigDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterConfig").build()}).build();
    private static final SdkField<AwsOpenSearchServiceDomainDomainEndpointOptionsDetails> DOMAIN_ENDPOINT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DomainEndpointOptions").getter(AwsOpenSearchServiceDomainDetails.getter(AwsOpenSearchServiceDomainDetails::domainEndpointOptions)).setter(AwsOpenSearchServiceDomainDetails.setter(Builder::domainEndpointOptions)).constructor(AwsOpenSearchServiceDomainDomainEndpointOptionsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpointOptions").build()}).build();
    private static final SdkField<AwsOpenSearchServiceDomainVpcOptionsDetails> VPC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcOptions").getter(AwsOpenSearchServiceDomainDetails.getter(AwsOpenSearchServiceDomainDetails::vpcOptions)).setter(AwsOpenSearchServiceDomainDetails.setter(Builder::vpcOptions)).constructor(AwsOpenSearchServiceDomainVpcOptionsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOptions").build()}).build();
    private static final SdkField<AwsOpenSearchServiceDomainLogPublishingOptionsDetails> LOG_PUBLISHING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogPublishingOptions").getter(AwsOpenSearchServiceDomainDetails.getter(AwsOpenSearchServiceDomainDetails::logPublishingOptions)).setter(AwsOpenSearchServiceDomainDetails.setter(Builder::logPublishingOptions)).constructor(AwsOpenSearchServiceDomainLogPublishingOptionsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingOptions").build()}).build();
    private static final SdkField<Map<String, String>> DOMAIN_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("DomainEndpoints").getter(AwsOpenSearchServiceDomainDetails.getter(AwsOpenSearchServiceDomainDetails::domainEndpoints)).setter(AwsOpenSearchServiceDomainDetails.setter(Builder::domainEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpoints").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails> ADVANCED_SECURITY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdvancedSecurityOptions").getter(AwsOpenSearchServiceDomainDetails.getter(AwsOpenSearchServiceDomainDetails::advancedSecurityOptions)).setter(AwsOpenSearchServiceDomainDetails.setter(Builder::advancedSecurityOptions)).constructor(AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedSecurityOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ACCESS_POLICIES_FIELD, DOMAIN_NAME_FIELD, ID_FIELD, DOMAIN_ENDPOINT_FIELD, ENGINE_VERSION_FIELD, ENCRYPTION_AT_REST_OPTIONS_FIELD, NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD, SERVICE_SOFTWARE_OPTIONS_FIELD, CLUSTER_CONFIG_FIELD, DOMAIN_ENDPOINT_OPTIONS_FIELD, VPC_OPTIONS_FIELD, LOG_PUBLISHING_OPTIONS_FIELD, DOMAIN_ENDPOINTS_FIELD, ADVANCED_SECURITY_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("AccessPolicies", ACCESS_POLICIES_FIELD);
            this.put("DomainName", DOMAIN_NAME_FIELD);
            this.put("Id", ID_FIELD);
            this.put("DomainEndpoint", DOMAIN_ENDPOINT_FIELD);
            this.put("EngineVersion", ENGINE_VERSION_FIELD);
            this.put("EncryptionAtRestOptions", ENCRYPTION_AT_REST_OPTIONS_FIELD);
            this.put("NodeToNodeEncryptionOptions", NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD);
            this.put("ServiceSoftwareOptions", SERVICE_SOFTWARE_OPTIONS_FIELD);
            this.put("ClusterConfig", CLUSTER_CONFIG_FIELD);
            this.put("DomainEndpointOptions", DOMAIN_ENDPOINT_OPTIONS_FIELD);
            this.put("VpcOptions", VPC_OPTIONS_FIELD);
            this.put("LogPublishingOptions", LOG_PUBLISHING_OPTIONS_FIELD);
            this.put("DomainEndpoints", DOMAIN_ENDPOINTS_FIELD);
            this.put("AdvancedSecurityOptions", ADVANCED_SECURITY_OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String accessPolicies;
    private final String domainName;
    private final String id;
    private final String domainEndpoint;
    private final String engineVersion;
    private final AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails encryptionAtRestOptions;
    private final AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails nodeToNodeEncryptionOptions;
    private final AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails serviceSoftwareOptions;
    private final AwsOpenSearchServiceDomainClusterConfigDetails clusterConfig;
    private final AwsOpenSearchServiceDomainDomainEndpointOptionsDetails domainEndpointOptions;
    private final AwsOpenSearchServiceDomainVpcOptionsDetails vpcOptions;
    private final AwsOpenSearchServiceDomainLogPublishingOptionsDetails logPublishingOptions;
    private final Map<String, String> domainEndpoints;
    private final AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails advancedSecurityOptions;

    private AwsOpenSearchServiceDomainDetails(BuilderImpl builder) {
        this.arn = builder.arn;
        this.accessPolicies = builder.accessPolicies;
        this.domainName = builder.domainName;
        this.id = builder.id;
        this.domainEndpoint = builder.domainEndpoint;
        this.engineVersion = builder.engineVersion;
        this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
        this.nodeToNodeEncryptionOptions = builder.nodeToNodeEncryptionOptions;
        this.serviceSoftwareOptions = builder.serviceSoftwareOptions;
        this.clusterConfig = builder.clusterConfig;
        this.domainEndpointOptions = builder.domainEndpointOptions;
        this.vpcOptions = builder.vpcOptions;
        this.logPublishingOptions = builder.logPublishingOptions;
        this.domainEndpoints = builder.domainEndpoints;
        this.advancedSecurityOptions = builder.advancedSecurityOptions;
    }

    public final String arn() {
        return this.arn;
    }

    public final String accessPolicies() {
        return this.accessPolicies;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String id() {
        return this.id;
    }

    public final String domainEndpoint() {
        return this.domainEndpoint;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails encryptionAtRestOptions() {
        return this.encryptionAtRestOptions;
    }

    public final AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails nodeToNodeEncryptionOptions() {
        return this.nodeToNodeEncryptionOptions;
    }

    public final AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails serviceSoftwareOptions() {
        return this.serviceSoftwareOptions;
    }

    public final AwsOpenSearchServiceDomainClusterConfigDetails clusterConfig() {
        return this.clusterConfig;
    }

    public final AwsOpenSearchServiceDomainDomainEndpointOptionsDetails domainEndpointOptions() {
        return this.domainEndpointOptions;
    }

    public final AwsOpenSearchServiceDomainVpcOptionsDetails vpcOptions() {
        return this.vpcOptions;
    }

    public final AwsOpenSearchServiceDomainLogPublishingOptionsDetails logPublishingOptions() {
        return this.logPublishingOptions;
    }

    public final boolean hasDomainEndpoints() {
        return this.domainEndpoints != null && !(this.domainEndpoints instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> domainEndpoints() {
        return this.domainEndpoints;
    }

    public final AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails advancedSecurityOptions() {
        return this.advancedSecurityOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionAtRestOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeToNodeEncryptionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceSoftwareOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainEndpointOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.logPublishingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainEndpoints() ? this.domainEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedSecurityOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsOpenSearchServiceDomainDetails)) {
            return false;
        }
        AwsOpenSearchServiceDomainDetails other = (AwsOpenSearchServiceDomainDetails)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.accessPolicies(), other.accessPolicies()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.domainEndpoint(), other.domainEndpoint()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.encryptionAtRestOptions(), other.encryptionAtRestOptions()) && Objects.equals(this.nodeToNodeEncryptionOptions(), other.nodeToNodeEncryptionOptions()) && Objects.equals(this.serviceSoftwareOptions(), other.serviceSoftwareOptions()) && Objects.equals(this.clusterConfig(), other.clusterConfig()) && Objects.equals(this.domainEndpointOptions(), other.domainEndpointOptions()) && Objects.equals(this.vpcOptions(), other.vpcOptions()) && Objects.equals(this.logPublishingOptions(), other.logPublishingOptions()) && this.hasDomainEndpoints() == other.hasDomainEndpoints() && Objects.equals(this.domainEndpoints(), other.domainEndpoints()) && Objects.equals(this.advancedSecurityOptions(), other.advancedSecurityOptions());
    }

    public final String toString() {
        return ToString.builder((String)"AwsOpenSearchServiceDomainDetails").add("Arn", (Object)this.arn()).add("AccessPolicies", (Object)this.accessPolicies()).add("DomainName", (Object)this.domainName()).add("Id", (Object)this.id()).add("DomainEndpoint", (Object)this.domainEndpoint()).add("EngineVersion", (Object)this.engineVersion()).add("EncryptionAtRestOptions", (Object)this.encryptionAtRestOptions()).add("NodeToNodeEncryptionOptions", (Object)this.nodeToNodeEncryptionOptions()).add("ServiceSoftwareOptions", (Object)this.serviceSoftwareOptions()).add("ClusterConfig", (Object)this.clusterConfig()).add("DomainEndpointOptions", (Object)this.domainEndpointOptions()).add("VpcOptions", (Object)this.vpcOptions()).add("LogPublishingOptions", (Object)this.logPublishingOptions()).add("DomainEndpoints", this.hasDomainEndpoints() ? this.domainEndpoints() : null).add("AdvancedSecurityOptions", (Object)this.advancedSecurityOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AccessPolicies": {
                return Optional.ofNullable(clazz.cast(this.accessPolicies()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "DomainEndpoint": {
                return Optional.ofNullable(clazz.cast(this.domainEndpoint()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "EncryptionAtRestOptions": {
                return Optional.ofNullable(clazz.cast(this.encryptionAtRestOptions()));
            }
            case "NodeToNodeEncryptionOptions": {
                return Optional.ofNullable(clazz.cast(this.nodeToNodeEncryptionOptions()));
            }
            case "ServiceSoftwareOptions": {
                return Optional.ofNullable(clazz.cast(this.serviceSoftwareOptions()));
            }
            case "ClusterConfig": {
                return Optional.ofNullable(clazz.cast(this.clusterConfig()));
            }
            case "DomainEndpointOptions": {
                return Optional.ofNullable(clazz.cast(this.domainEndpointOptions()));
            }
            case "VpcOptions": {
                return Optional.ofNullable(clazz.cast(this.vpcOptions()));
            }
            case "LogPublishingOptions": {
                return Optional.ofNullable(clazz.cast(this.logPublishingOptions()));
            }
            case "DomainEndpoints": {
                return Optional.ofNullable(clazz.cast(this.domainEndpoints()));
            }
            case "AdvancedSecurityOptions": {
                return Optional.ofNullable(clazz.cast(this.advancedSecurityOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsOpenSearchServiceDomainDetails, T> g) {
        return obj -> g.apply((AwsOpenSearchServiceDomainDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String accessPolicies;
        private String domainName;
        private String id;
        private String domainEndpoint;
        private String engineVersion;
        private AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails encryptionAtRestOptions;
        private AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails nodeToNodeEncryptionOptions;
        private AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails serviceSoftwareOptions;
        private AwsOpenSearchServiceDomainClusterConfigDetails clusterConfig;
        private AwsOpenSearchServiceDomainDomainEndpointOptionsDetails domainEndpointOptions;
        private AwsOpenSearchServiceDomainVpcOptionsDetails vpcOptions;
        private AwsOpenSearchServiceDomainLogPublishingOptionsDetails logPublishingOptions;
        private Map<String, String> domainEndpoints = DefaultSdkAutoConstructMap.getInstance();
        private AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails advancedSecurityOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsOpenSearchServiceDomainDetails model) {
            this.arn(model.arn);
            this.accessPolicies(model.accessPolicies);
            this.domainName(model.domainName);
            this.id(model.id);
            this.domainEndpoint(model.domainEndpoint);
            this.engineVersion(model.engineVersion);
            this.encryptionAtRestOptions(model.encryptionAtRestOptions);
            this.nodeToNodeEncryptionOptions(model.nodeToNodeEncryptionOptions);
            this.serviceSoftwareOptions(model.serviceSoftwareOptions);
            this.clusterConfig(model.clusterConfig);
            this.domainEndpointOptions(model.domainEndpointOptions);
            this.vpcOptions(model.vpcOptions);
            this.logPublishingOptions(model.logPublishingOptions);
            this.domainEndpoints(model.domainEndpoints);
            this.advancedSecurityOptions(model.advancedSecurityOptions);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAccessPolicies() {
            return this.accessPolicies;
        }

        public final void setAccessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
        }

        @Override
        public final Builder accessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDomainEndpoint() {
            return this.domainEndpoint;
        }

        public final void setDomainEndpoint(String domainEndpoint) {
            this.domainEndpoint = domainEndpoint;
        }

        @Override
        public final Builder domainEndpoint(String domainEndpoint) {
            this.domainEndpoint = domainEndpoint;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.Builder getEncryptionAtRestOptions() {
            return this.encryptionAtRestOptions != null ? this.encryptionAtRestOptions.toBuilder() : null;
        }

        public final void setEncryptionAtRestOptions(AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.BuilderImpl encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions != null ? encryptionAtRestOptions.build() : null;
        }

        @Override
        public final Builder encryptionAtRestOptions(AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        public final AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.Builder getNodeToNodeEncryptionOptions() {
            return this.nodeToNodeEncryptionOptions != null ? this.nodeToNodeEncryptionOptions.toBuilder() : null;
        }

        public final void setNodeToNodeEncryptionOptions(AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.BuilderImpl nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.build() : null;
        }

        @Override
        public final Builder nodeToNodeEncryptionOptions(AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions;
            return this;
        }

        public final AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.Builder getServiceSoftwareOptions() {
            return this.serviceSoftwareOptions != null ? this.serviceSoftwareOptions.toBuilder() : null;
        }

        public final void setServiceSoftwareOptions(AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.BuilderImpl serviceSoftwareOptions) {
            this.serviceSoftwareOptions = serviceSoftwareOptions != null ? serviceSoftwareOptions.build() : null;
        }

        @Override
        public final Builder serviceSoftwareOptions(AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails serviceSoftwareOptions) {
            this.serviceSoftwareOptions = serviceSoftwareOptions;
            return this;
        }

        public final AwsOpenSearchServiceDomainClusterConfigDetails.Builder getClusterConfig() {
            return this.clusterConfig != null ? this.clusterConfig.toBuilder() : null;
        }

        public final void setClusterConfig(AwsOpenSearchServiceDomainClusterConfigDetails.BuilderImpl clusterConfig) {
            this.clusterConfig = clusterConfig != null ? clusterConfig.build() : null;
        }

        @Override
        public final Builder clusterConfig(AwsOpenSearchServiceDomainClusterConfigDetails clusterConfig) {
            this.clusterConfig = clusterConfig;
            return this;
        }

        public final AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.Builder getDomainEndpointOptions() {
            return this.domainEndpointOptions != null ? this.domainEndpointOptions.toBuilder() : null;
        }

        public final void setDomainEndpointOptions(AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.BuilderImpl domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions != null ? domainEndpointOptions.build() : null;
        }

        @Override
        public final Builder domainEndpointOptions(AwsOpenSearchServiceDomainDomainEndpointOptionsDetails domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions;
            return this;
        }

        public final AwsOpenSearchServiceDomainVpcOptionsDetails.Builder getVpcOptions() {
            return this.vpcOptions != null ? this.vpcOptions.toBuilder() : null;
        }

        public final void setVpcOptions(AwsOpenSearchServiceDomainVpcOptionsDetails.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        @Override
        public final Builder vpcOptions(AwsOpenSearchServiceDomainVpcOptionsDetails vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final AwsOpenSearchServiceDomainLogPublishingOptionsDetails.Builder getLogPublishingOptions() {
            return this.logPublishingOptions != null ? this.logPublishingOptions.toBuilder() : null;
        }

        public final void setLogPublishingOptions(AwsOpenSearchServiceDomainLogPublishingOptionsDetails.BuilderImpl logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions != null ? logPublishingOptions.build() : null;
        }

        @Override
        public final Builder logPublishingOptions(AwsOpenSearchServiceDomainLogPublishingOptionsDetails logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions;
            return this;
        }

        public final Map<String, String> getDomainEndpoints() {
            if (this.domainEndpoints instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.domainEndpoints;
        }

        public final void setDomainEndpoints(Map<String, String> domainEndpoints) {
            this.domainEndpoints = FieldMapCopier.copy(domainEndpoints);
        }

        @Override
        public final Builder domainEndpoints(Map<String, String> domainEndpoints) {
            this.domainEndpoints = FieldMapCopier.copy(domainEndpoints);
            return this;
        }

        public final AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.Builder getAdvancedSecurityOptions() {
            return this.advancedSecurityOptions != null ? this.advancedSecurityOptions.toBuilder() : null;
        }

        public final void setAdvancedSecurityOptions(AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.BuilderImpl advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions != null ? advancedSecurityOptions.build() : null;
        }

        @Override
        public final Builder advancedSecurityOptions(AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions;
            return this;
        }

        public AwsOpenSearchServiceDomainDetails build() {
            return new AwsOpenSearchServiceDomainDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsOpenSearchServiceDomainDetails> {
        public Builder arn(String var1);

        public Builder accessPolicies(String var1);

        public Builder domainName(String var1);

        public Builder id(String var1);

        public Builder domainEndpoint(String var1);

        public Builder engineVersion(String var1);

        public Builder encryptionAtRestOptions(AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails var1);

        default public Builder encryptionAtRestOptions(Consumer<AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.Builder> encryptionAtRestOptions) {
            return this.encryptionAtRestOptions((AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails)((AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.Builder)AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.builder().applyMutation(encryptionAtRestOptions)).build());
        }

        public Builder nodeToNodeEncryptionOptions(AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails var1);

        default public Builder nodeToNodeEncryptionOptions(Consumer<AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.Builder> nodeToNodeEncryptionOptions) {
            return this.nodeToNodeEncryptionOptions((AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails)((AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.Builder)AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.builder().applyMutation(nodeToNodeEncryptionOptions)).build());
        }

        public Builder serviceSoftwareOptions(AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails var1);

        default public Builder serviceSoftwareOptions(Consumer<AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.Builder> serviceSoftwareOptions) {
            return this.serviceSoftwareOptions((AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails)((AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.Builder)AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.builder().applyMutation(serviceSoftwareOptions)).build());
        }

        public Builder clusterConfig(AwsOpenSearchServiceDomainClusterConfigDetails var1);

        default public Builder clusterConfig(Consumer<AwsOpenSearchServiceDomainClusterConfigDetails.Builder> clusterConfig) {
            return this.clusterConfig((AwsOpenSearchServiceDomainClusterConfigDetails)((AwsOpenSearchServiceDomainClusterConfigDetails.Builder)AwsOpenSearchServiceDomainClusterConfigDetails.builder().applyMutation(clusterConfig)).build());
        }

        public Builder domainEndpointOptions(AwsOpenSearchServiceDomainDomainEndpointOptionsDetails var1);

        default public Builder domainEndpointOptions(Consumer<AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.Builder> domainEndpointOptions) {
            return this.domainEndpointOptions((AwsOpenSearchServiceDomainDomainEndpointOptionsDetails)((AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.Builder)AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.builder().applyMutation(domainEndpointOptions)).build());
        }

        public Builder vpcOptions(AwsOpenSearchServiceDomainVpcOptionsDetails var1);

        default public Builder vpcOptions(Consumer<AwsOpenSearchServiceDomainVpcOptionsDetails.Builder> vpcOptions) {
            return this.vpcOptions((AwsOpenSearchServiceDomainVpcOptionsDetails)((AwsOpenSearchServiceDomainVpcOptionsDetails.Builder)AwsOpenSearchServiceDomainVpcOptionsDetails.builder().applyMutation(vpcOptions)).build());
        }

        public Builder logPublishingOptions(AwsOpenSearchServiceDomainLogPublishingOptionsDetails var1);

        default public Builder logPublishingOptions(Consumer<AwsOpenSearchServiceDomainLogPublishingOptionsDetails.Builder> logPublishingOptions) {
            return this.logPublishingOptions((AwsOpenSearchServiceDomainLogPublishingOptionsDetails)((AwsOpenSearchServiceDomainLogPublishingOptionsDetails.Builder)AwsOpenSearchServiceDomainLogPublishingOptionsDetails.builder().applyMutation(logPublishingOptions)).build());
        }

        public Builder domainEndpoints(Map<String, String> var1);

        public Builder advancedSecurityOptions(AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails var1);

        default public Builder advancedSecurityOptions(Consumer<AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.Builder> advancedSecurityOptions) {
            return this.advancedSecurityOptions((AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails)((AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.Builder)AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.builder().applyMutation(advancedSecurityOptions)).build());
        }
    }
}

