/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails;
import software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsCodeBuildProjectEnvironment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsCodeBuildProjectEnvironment> {
    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Certificate").getter(AwsCodeBuildProjectEnvironment.getter(AwsCodeBuildProjectEnvironment::certificate)).setter(AwsCodeBuildProjectEnvironment.setter(Builder::certificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()}).build();
    private static final SdkField<List<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails>> ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnvironmentVariables").getter(AwsCodeBuildProjectEnvironment.getter(AwsCodeBuildProjectEnvironment::environmentVariables)).setter(AwsCodeBuildProjectEnvironment.setter(Builder::environmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentVariables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PRIVILEGED_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PrivilegedMode").getter(AwsCodeBuildProjectEnvironment.getter(AwsCodeBuildProjectEnvironment::privilegedMode)).setter(AwsCodeBuildProjectEnvironment.setter(Builder::privilegedMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivilegedMode").build()}).build();
    private static final SdkField<String> IMAGE_PULL_CREDENTIALS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImagePullCredentialsType").getter(AwsCodeBuildProjectEnvironment.getter(AwsCodeBuildProjectEnvironment::imagePullCredentialsType)).setter(AwsCodeBuildProjectEnvironment.setter(Builder::imagePullCredentialsType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImagePullCredentialsType").build()}).build();
    private static final SdkField<AwsCodeBuildProjectEnvironmentRegistryCredential> REGISTRY_CREDENTIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RegistryCredential").getter(AwsCodeBuildProjectEnvironment.getter(AwsCodeBuildProjectEnvironment::registryCredential)).setter(AwsCodeBuildProjectEnvironment.setter(Builder::registryCredential)).constructor(AwsCodeBuildProjectEnvironmentRegistryCredential::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryCredential").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(AwsCodeBuildProjectEnvironment.getter(AwsCodeBuildProjectEnvironment::type)).setter(AwsCodeBuildProjectEnvironment.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD, ENVIRONMENT_VARIABLES_FIELD, PRIVILEGED_MODE_FIELD, IMAGE_PULL_CREDENTIALS_TYPE_FIELD, REGISTRY_CREDENTIAL_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Certificate", CERTIFICATE_FIELD);
            this.put("EnvironmentVariables", ENVIRONMENT_VARIABLES_FIELD);
            this.put("PrivilegedMode", PRIVILEGED_MODE_FIELD);
            this.put("ImagePullCredentialsType", IMAGE_PULL_CREDENTIALS_TYPE_FIELD);
            this.put("RegistryCredential", REGISTRY_CREDENTIAL_FIELD);
            this.put("Type", TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String certificate;
    private final List<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails> environmentVariables;
    private final Boolean privilegedMode;
    private final String imagePullCredentialsType;
    private final AwsCodeBuildProjectEnvironmentRegistryCredential registryCredential;
    private final String type;

    private AwsCodeBuildProjectEnvironment(BuilderImpl builder) {
        this.certificate = builder.certificate;
        this.environmentVariables = builder.environmentVariables;
        this.privilegedMode = builder.privilegedMode;
        this.imagePullCredentialsType = builder.imagePullCredentialsType;
        this.registryCredential = builder.registryCredential;
        this.type = builder.type;
    }

    public final String certificate() {
        return this.certificate;
    }

    public final boolean hasEnvironmentVariables() {
        return this.environmentVariables != null && !(this.environmentVariables instanceof SdkAutoConstructList);
    }

    public final List<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails> environmentVariables() {
        return this.environmentVariables;
    }

    public final Boolean privilegedMode() {
        return this.privilegedMode;
    }

    public final String imagePullCredentialsType() {
        return this.imagePullCredentialsType;
    }

    public final AwsCodeBuildProjectEnvironmentRegistryCredential registryCredential() {
        return this.registryCredential;
    }

    public final String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentVariables() ? this.environmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.privilegedMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.imagePullCredentialsType());
        hashCode = 31 * hashCode + Objects.hashCode(this.registryCredential());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCodeBuildProjectEnvironment)) {
            return false;
        }
        AwsCodeBuildProjectEnvironment other = (AwsCodeBuildProjectEnvironment)obj;
        return Objects.equals(this.certificate(), other.certificate()) && this.hasEnvironmentVariables() == other.hasEnvironmentVariables() && Objects.equals(this.environmentVariables(), other.environmentVariables()) && Objects.equals(this.privilegedMode(), other.privilegedMode()) && Objects.equals(this.imagePullCredentialsType(), other.imagePullCredentialsType()) && Objects.equals(this.registryCredential(), other.registryCredential()) && Objects.equals(this.type(), other.type());
    }

    public final String toString() {
        return ToString.builder((String)"AwsCodeBuildProjectEnvironment").add("Certificate", (Object)this.certificate()).add("EnvironmentVariables", this.hasEnvironmentVariables() ? this.environmentVariables() : null).add("PrivilegedMode", (Object)this.privilegedMode()).add("ImagePullCredentialsType", (Object)this.imagePullCredentialsType()).add("RegistryCredential", (Object)this.registryCredential()).add("Type", (Object)this.type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "EnvironmentVariables": {
                return Optional.ofNullable(clazz.cast(this.environmentVariables()));
            }
            case "PrivilegedMode": {
                return Optional.ofNullable(clazz.cast(this.privilegedMode()));
            }
            case "ImagePullCredentialsType": {
                return Optional.ofNullable(clazz.cast(this.imagePullCredentialsType()));
            }
            case "RegistryCredential": {
                return Optional.ofNullable(clazz.cast(this.registryCredential()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsCodeBuildProjectEnvironment, T> g) {
        return obj -> g.apply((AwsCodeBuildProjectEnvironment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificate;
        private List<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails> environmentVariables = DefaultSdkAutoConstructList.getInstance();
        private Boolean privilegedMode;
        private String imagePullCredentialsType;
        private AwsCodeBuildProjectEnvironmentRegistryCredential registryCredential;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCodeBuildProjectEnvironment model) {
            this.certificate(model.certificate);
            this.environmentVariables(model.environmentVariables);
            this.privilegedMode(model.privilegedMode);
            this.imagePullCredentialsType(model.imagePullCredentialsType);
            this.registryCredential(model.registryCredential);
            this.type(model.type);
        }

        public final String getCertificate() {
            return this.certificate;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final List<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.Builder> getEnvironmentVariables() {
            List<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.Builder> result = AwsCodeBuildProjectEnvironmentEnvironmentVariablesListCopier.copyToBuilder(this.environmentVariables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentVariables(Collection<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.BuilderImpl> environmentVariables) {
            this.environmentVariables = AwsCodeBuildProjectEnvironmentEnvironmentVariablesListCopier.copyFromBuilder(environmentVariables);
        }

        @Override
        public final Builder environmentVariables(Collection<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails> environmentVariables) {
            this.environmentVariables = AwsCodeBuildProjectEnvironmentEnvironmentVariablesListCopier.copy(environmentVariables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVariables(AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails ... environmentVariables) {
            this.environmentVariables(Arrays.asList(environmentVariables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVariables(Consumer<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.Builder> ... environmentVariables) {
            this.environmentVariables(Stream.of(environmentVariables).map(c -> (AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails)((AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.Builder)AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getPrivilegedMode() {
            return this.privilegedMode;
        }

        public final void setPrivilegedMode(Boolean privilegedMode) {
            this.privilegedMode = privilegedMode;
        }

        @Override
        public final Builder privilegedMode(Boolean privilegedMode) {
            this.privilegedMode = privilegedMode;
            return this;
        }

        public final String getImagePullCredentialsType() {
            return this.imagePullCredentialsType;
        }

        public final void setImagePullCredentialsType(String imagePullCredentialsType) {
            this.imagePullCredentialsType = imagePullCredentialsType;
        }

        @Override
        public final Builder imagePullCredentialsType(String imagePullCredentialsType) {
            this.imagePullCredentialsType = imagePullCredentialsType;
            return this;
        }

        public final AwsCodeBuildProjectEnvironmentRegistryCredential.Builder getRegistryCredential() {
            return this.registryCredential != null ? this.registryCredential.toBuilder() : null;
        }

        public final void setRegistryCredential(AwsCodeBuildProjectEnvironmentRegistryCredential.BuilderImpl registryCredential) {
            this.registryCredential = registryCredential != null ? registryCredential.build() : null;
        }

        @Override
        public final Builder registryCredential(AwsCodeBuildProjectEnvironmentRegistryCredential registryCredential) {
            this.registryCredential = registryCredential;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public AwsCodeBuildProjectEnvironment build() {
            return new AwsCodeBuildProjectEnvironment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsCodeBuildProjectEnvironment> {
        public Builder certificate(String var1);

        public Builder environmentVariables(Collection<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails> var1);

        public Builder environmentVariables(AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails ... var1);

        public Builder environmentVariables(Consumer<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.Builder> ... var1);

        public Builder privilegedMode(Boolean var1);

        public Builder imagePullCredentialsType(String var1);

        public Builder registryCredential(AwsCodeBuildProjectEnvironmentRegistryCredential var1);

        default public Builder registryCredential(Consumer<AwsCodeBuildProjectEnvironmentRegistryCredential.Builder> registryCredential) {
            return this.registryCredential((AwsCodeBuildProjectEnvironmentRegistryCredential)((AwsCodeBuildProjectEnvironmentRegistryCredential.Builder)AwsCodeBuildProjectEnvironmentRegistryCredential.builder().applyMutation(registryCredential)).build());
        }

        public Builder type(String var1);
    }
}

