/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesListCopier;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEcsTaskDefinitionDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEcsTaskDefinitionDetails> {
    private static final SdkField<List<AwsEcsTaskDefinitionContainerDefinitionsDetails>> CONTAINER_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContainerDefinitions").getter(AwsEcsTaskDefinitionDetails.getter(AwsEcsTaskDefinitionDetails::containerDefinitions)).setter(AwsEcsTaskDefinitionDetails.setter(Builder::containerDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEcsTaskDefinitionContainerDefinitionsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Cpu").getter(AwsEcsTaskDefinitionDetails.getter(AwsEcsTaskDefinitionDetails::cpu)).setter(AwsEcsTaskDefinitionDetails.setter(Builder::cpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cpu").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(AwsEcsTaskDefinitionDetails.getter(AwsEcsTaskDefinitionDetails::executionRoleArn)).setter(AwsEcsTaskDefinitionDetails.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<String> FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Family").getter(AwsEcsTaskDefinitionDetails.getter(AwsEcsTaskDefinitionDetails::family)).setter(AwsEcsTaskDefinitionDetails.setter(Builder::family)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Family").build()}).build();
    private static final SdkField<List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails>> INFERENCE_ACCELERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InferenceAccelerators").getter(AwsEcsTaskDefinitionDetails.getter(AwsEcsTaskDefinitionDetails::inferenceAccelerators)).setter(AwsEcsTaskDefinitionDetails.setter(Builder::inferenceAccelerators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceAccelerators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEcsTaskDefinitionInferenceAcceleratorsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IPC_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpcMode").getter(AwsEcsTaskDefinitionDetails.getter(AwsEcsTaskDefinitionDetails::ipcMode)).setter(AwsEcsTaskDefinitionDetails.setter(Builder::ipcMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpcMode").build()}).build();
    private static final SdkField<String> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Memory").getter(AwsEcsTaskDefinitionDetails.getter(AwsEcsTaskDefinitionDetails::memory)).setter(AwsEcsTaskDefinitionDetails.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Memory").build()}).build();
    private static final SdkField<String> NETWORK_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkMode").getter(AwsEcsTaskDefinitionDetails.getter(AwsEcsTaskDefinitionDetails::networkMode)).setter(AwsEcsTaskDefinitionDetails.setter(Builder::networkMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkMode").build()}).build();
    private static final SdkField<String> PID_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PidMode").getter(AwsEcsTaskDefinitionDetails.getter(AwsEcsTaskDefinitionDetails::pidMode)).setter(AwsEcsTaskDefinitionDetails.setter(Builder::pidMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PidMode").build()}).build();
    private static final SdkField<List<AwsEcsTaskDefinitionPlacementConstraintsDetails>> PLACEMENT_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PlacementConstraints").getter(AwsEcsTaskDefinitionDetails.getter(AwsEcsTaskDefinitionDetails::placementConstraints)).setter(AwsEcsTaskDefinitionDetails.setter(Builder::placementConstraints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementConstraints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEcsTaskDefinitionPlacementConstraintsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AwsEcsTaskDefinitionProxyConfigurationDetails> PROXY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProxyConfiguration").getter(AwsEcsTaskDefinitionDetails.getter(AwsEcsTaskDefinitionDetails::proxyConfiguration)).setter(AwsEcsTaskDefinitionDetails.setter(Builder::proxyConfiguration)).constructor(AwsEcsTaskDefinitionProxyConfigurationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfiguration").build()}).build();
    private static final SdkField<List<String>> REQUIRES_COMPATIBILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RequiresCompatibilities").getter(AwsEcsTaskDefinitionDetails.getter(AwsEcsTaskDefinitionDetails::requiresCompatibilities)).setter(AwsEcsTaskDefinitionDetails.setter(Builder::requiresCompatibilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiresCompatibilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TASK_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskRoleArn").getter(AwsEcsTaskDefinitionDetails.getter(AwsEcsTaskDefinitionDetails::taskRoleArn)).setter(AwsEcsTaskDefinitionDetails.setter(Builder::taskRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskRoleArn").build()}).build();
    private static final SdkField<List<AwsEcsTaskDefinitionVolumesDetails>> VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Volumes").getter(AwsEcsTaskDefinitionDetails.getter(AwsEcsTaskDefinitionDetails::volumes)).setter(AwsEcsTaskDefinitionDetails.setter(Builder::volumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Volumes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEcsTaskDefinitionVolumesDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AwsEcsTaskDefinitionDetails.getter(AwsEcsTaskDefinitionDetails::status)).setter(AwsEcsTaskDefinitionDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_DEFINITIONS_FIELD, CPU_FIELD, EXECUTION_ROLE_ARN_FIELD, FAMILY_FIELD, INFERENCE_ACCELERATORS_FIELD, IPC_MODE_FIELD, MEMORY_FIELD, NETWORK_MODE_FIELD, PID_MODE_FIELD, PLACEMENT_CONSTRAINTS_FIELD, PROXY_CONFIGURATION_FIELD, REQUIRES_COMPATIBILITIES_FIELD, TASK_ROLE_ARN_FIELD, VOLUMES_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ContainerDefinitions", CONTAINER_DEFINITIONS_FIELD);
            this.put("Cpu", CPU_FIELD);
            this.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
            this.put("Family", FAMILY_FIELD);
            this.put("InferenceAccelerators", INFERENCE_ACCELERATORS_FIELD);
            this.put("IpcMode", IPC_MODE_FIELD);
            this.put("Memory", MEMORY_FIELD);
            this.put("NetworkMode", NETWORK_MODE_FIELD);
            this.put("PidMode", PID_MODE_FIELD);
            this.put("PlacementConstraints", PLACEMENT_CONSTRAINTS_FIELD);
            this.put("ProxyConfiguration", PROXY_CONFIGURATION_FIELD);
            this.put("RequiresCompatibilities", REQUIRES_COMPATIBILITIES_FIELD);
            this.put("TaskRoleArn", TASK_ROLE_ARN_FIELD);
            this.put("Volumes", VOLUMES_FIELD);
            this.put("Status", STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<AwsEcsTaskDefinitionContainerDefinitionsDetails> containerDefinitions;
    private final String cpu;
    private final String executionRoleArn;
    private final String family;
    private final List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails> inferenceAccelerators;
    private final String ipcMode;
    private final String memory;
    private final String networkMode;
    private final String pidMode;
    private final List<AwsEcsTaskDefinitionPlacementConstraintsDetails> placementConstraints;
    private final AwsEcsTaskDefinitionProxyConfigurationDetails proxyConfiguration;
    private final List<String> requiresCompatibilities;
    private final String taskRoleArn;
    private final List<AwsEcsTaskDefinitionVolumesDetails> volumes;
    private final String status;

    private AwsEcsTaskDefinitionDetails(BuilderImpl builder) {
        this.containerDefinitions = builder.containerDefinitions;
        this.cpu = builder.cpu;
        this.executionRoleArn = builder.executionRoleArn;
        this.family = builder.family;
        this.inferenceAccelerators = builder.inferenceAccelerators;
        this.ipcMode = builder.ipcMode;
        this.memory = builder.memory;
        this.networkMode = builder.networkMode;
        this.pidMode = builder.pidMode;
        this.placementConstraints = builder.placementConstraints;
        this.proxyConfiguration = builder.proxyConfiguration;
        this.requiresCompatibilities = builder.requiresCompatibilities;
        this.taskRoleArn = builder.taskRoleArn;
        this.volumes = builder.volumes;
        this.status = builder.status;
    }

    public final boolean hasContainerDefinitions() {
        return this.containerDefinitions != null && !(this.containerDefinitions instanceof SdkAutoConstructList);
    }

    public final List<AwsEcsTaskDefinitionContainerDefinitionsDetails> containerDefinitions() {
        return this.containerDefinitions;
    }

    public final String cpu() {
        return this.cpu;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final String family() {
        return this.family;
    }

    public final boolean hasInferenceAccelerators() {
        return this.inferenceAccelerators != null && !(this.inferenceAccelerators instanceof SdkAutoConstructList);
    }

    public final List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails> inferenceAccelerators() {
        return this.inferenceAccelerators;
    }

    public final String ipcMode() {
        return this.ipcMode;
    }

    public final String memory() {
        return this.memory;
    }

    public final String networkMode() {
        return this.networkMode;
    }

    public final String pidMode() {
        return this.pidMode;
    }

    public final boolean hasPlacementConstraints() {
        return this.placementConstraints != null && !(this.placementConstraints instanceof SdkAutoConstructList);
    }

    public final List<AwsEcsTaskDefinitionPlacementConstraintsDetails> placementConstraints() {
        return this.placementConstraints;
    }

    public final AwsEcsTaskDefinitionProxyConfigurationDetails proxyConfiguration() {
        return this.proxyConfiguration;
    }

    public final boolean hasRequiresCompatibilities() {
        return this.requiresCompatibilities != null && !(this.requiresCompatibilities instanceof SdkAutoConstructList);
    }

    public final List<String> requiresCompatibilities() {
        return this.requiresCompatibilities;
    }

    public final String taskRoleArn() {
        return this.taskRoleArn;
    }

    public final boolean hasVolumes() {
        return this.volumes != null && !(this.volumes instanceof SdkAutoConstructList);
    }

    public final List<AwsEcsTaskDefinitionVolumesDetails> volumes() {
        return this.volumes;
    }

    public final String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerDefinitions() ? this.containerDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.family());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInferenceAccelerators() ? this.inferenceAccelerators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipcMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.pidMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlacementConstraints() ? this.placementConstraints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequiresCompatibilities() ? this.requiresCompatibilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.taskRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumes() ? this.volumes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionDetails other = (AwsEcsTaskDefinitionDetails)obj;
        return this.hasContainerDefinitions() == other.hasContainerDefinitions() && Objects.equals(this.containerDefinitions(), other.containerDefinitions()) && Objects.equals(this.cpu(), other.cpu()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.family(), other.family()) && this.hasInferenceAccelerators() == other.hasInferenceAccelerators() && Objects.equals(this.inferenceAccelerators(), other.inferenceAccelerators()) && Objects.equals(this.ipcMode(), other.ipcMode()) && Objects.equals(this.memory(), other.memory()) && Objects.equals(this.networkMode(), other.networkMode()) && Objects.equals(this.pidMode(), other.pidMode()) && this.hasPlacementConstraints() == other.hasPlacementConstraints() && Objects.equals(this.placementConstraints(), other.placementConstraints()) && Objects.equals(this.proxyConfiguration(), other.proxyConfiguration()) && this.hasRequiresCompatibilities() == other.hasRequiresCompatibilities() && Objects.equals(this.requiresCompatibilities(), other.requiresCompatibilities()) && Objects.equals(this.taskRoleArn(), other.taskRoleArn()) && this.hasVolumes() == other.hasVolumes() && Objects.equals(this.volumes(), other.volumes()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEcsTaskDefinitionDetails").add("ContainerDefinitions", this.hasContainerDefinitions() ? this.containerDefinitions() : null).add("Cpu", (Object)this.cpu()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("Family", (Object)this.family()).add("InferenceAccelerators", this.hasInferenceAccelerators() ? this.inferenceAccelerators() : null).add("IpcMode", (Object)this.ipcMode()).add("Memory", (Object)this.memory()).add("NetworkMode", (Object)this.networkMode()).add("PidMode", (Object)this.pidMode()).add("PlacementConstraints", this.hasPlacementConstraints() ? this.placementConstraints() : null).add("ProxyConfiguration", (Object)this.proxyConfiguration()).add("RequiresCompatibilities", this.hasRequiresCompatibilities() ? this.requiresCompatibilities() : null).add("TaskRoleArn", (Object)this.taskRoleArn()).add("Volumes", this.hasVolumes() ? this.volumes() : null).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerDefinitions": {
                return Optional.ofNullable(clazz.cast(this.containerDefinitions()));
            }
            case "Cpu": {
                return Optional.ofNullable(clazz.cast(this.cpu()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "Family": {
                return Optional.ofNullable(clazz.cast(this.family()));
            }
            case "InferenceAccelerators": {
                return Optional.ofNullable(clazz.cast(this.inferenceAccelerators()));
            }
            case "IpcMode": {
                return Optional.ofNullable(clazz.cast(this.ipcMode()));
            }
            case "Memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "NetworkMode": {
                return Optional.ofNullable(clazz.cast(this.networkMode()));
            }
            case "PidMode": {
                return Optional.ofNullable(clazz.cast(this.pidMode()));
            }
            case "PlacementConstraints": {
                return Optional.ofNullable(clazz.cast(this.placementConstraints()));
            }
            case "ProxyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.proxyConfiguration()));
            }
            case "RequiresCompatibilities": {
                return Optional.ofNullable(clazz.cast(this.requiresCompatibilities()));
            }
            case "TaskRoleArn": {
                return Optional.ofNullable(clazz.cast(this.taskRoleArn()));
            }
            case "Volumes": {
                return Optional.ofNullable(clazz.cast(this.volumes()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsTaskDefinitionDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AwsEcsTaskDefinitionContainerDefinitionsDetails> containerDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String cpu;
        private String executionRoleArn;
        private String family;
        private List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails> inferenceAccelerators = DefaultSdkAutoConstructList.getInstance();
        private String ipcMode;
        private String memory;
        private String networkMode;
        private String pidMode;
        private List<AwsEcsTaskDefinitionPlacementConstraintsDetails> placementConstraints = DefaultSdkAutoConstructList.getInstance();
        private AwsEcsTaskDefinitionProxyConfigurationDetails proxyConfiguration;
        private List<String> requiresCompatibilities = DefaultSdkAutoConstructList.getInstance();
        private String taskRoleArn;
        private List<AwsEcsTaskDefinitionVolumesDetails> volumes = DefaultSdkAutoConstructList.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionDetails model) {
            this.containerDefinitions(model.containerDefinitions);
            this.cpu(model.cpu);
            this.executionRoleArn(model.executionRoleArn);
            this.family(model.family);
            this.inferenceAccelerators(model.inferenceAccelerators);
            this.ipcMode(model.ipcMode);
            this.memory(model.memory);
            this.networkMode(model.networkMode);
            this.pidMode(model.pidMode);
            this.placementConstraints(model.placementConstraints);
            this.proxyConfiguration(model.proxyConfiguration);
            this.requiresCompatibilities(model.requiresCompatibilities);
            this.taskRoleArn(model.taskRoleArn);
            this.volumes(model.volumes);
            this.status(model.status);
        }

        public final List<AwsEcsTaskDefinitionContainerDefinitionsDetails.Builder> getContainerDefinitions() {
            List<AwsEcsTaskDefinitionContainerDefinitionsDetails.Builder> result = AwsEcsTaskDefinitionContainerDefinitionsListCopier.copyToBuilder(this.containerDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerDefinitions(Collection<AwsEcsTaskDefinitionContainerDefinitionsDetails.BuilderImpl> containerDefinitions) {
            this.containerDefinitions = AwsEcsTaskDefinitionContainerDefinitionsListCopier.copyFromBuilder(containerDefinitions);
        }

        @Override
        public final Builder containerDefinitions(Collection<AwsEcsTaskDefinitionContainerDefinitionsDetails> containerDefinitions) {
            this.containerDefinitions = AwsEcsTaskDefinitionContainerDefinitionsListCopier.copy(containerDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerDefinitions(AwsEcsTaskDefinitionContainerDefinitionsDetails ... containerDefinitions) {
            this.containerDefinitions(Arrays.asList(containerDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerDefinitions(Consumer<AwsEcsTaskDefinitionContainerDefinitionsDetails.Builder> ... containerDefinitions) {
            this.containerDefinitions(Stream.of(containerDefinitions).map(c -> (AwsEcsTaskDefinitionContainerDefinitionsDetails)((AwsEcsTaskDefinitionContainerDefinitionsDetails.Builder)AwsEcsTaskDefinitionContainerDefinitionsDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCpu() {
            return this.cpu;
        }

        public final void setCpu(String cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getFamily() {
            return this.family;
        }

        public final void setFamily(String family) {
            this.family = family;
        }

        @Override
        public final Builder family(String family) {
            this.family = family;
            return this;
        }

        public final List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails.Builder> getInferenceAccelerators() {
            List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails.Builder> result = AwsEcsTaskDefinitionInferenceAcceleratorsListCopier.copyToBuilder(this.inferenceAccelerators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInferenceAccelerators(Collection<AwsEcsTaskDefinitionInferenceAcceleratorsDetails.BuilderImpl> inferenceAccelerators) {
            this.inferenceAccelerators = AwsEcsTaskDefinitionInferenceAcceleratorsListCopier.copyFromBuilder(inferenceAccelerators);
        }

        @Override
        public final Builder inferenceAccelerators(Collection<AwsEcsTaskDefinitionInferenceAcceleratorsDetails> inferenceAccelerators) {
            this.inferenceAccelerators = AwsEcsTaskDefinitionInferenceAcceleratorsListCopier.copy(inferenceAccelerators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceAccelerators(AwsEcsTaskDefinitionInferenceAcceleratorsDetails ... inferenceAccelerators) {
            this.inferenceAccelerators(Arrays.asList(inferenceAccelerators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceAccelerators(Consumer<AwsEcsTaskDefinitionInferenceAcceleratorsDetails.Builder> ... inferenceAccelerators) {
            this.inferenceAccelerators(Stream.of(inferenceAccelerators).map(c -> (AwsEcsTaskDefinitionInferenceAcceleratorsDetails)((AwsEcsTaskDefinitionInferenceAcceleratorsDetails.Builder)AwsEcsTaskDefinitionInferenceAcceleratorsDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIpcMode() {
            return this.ipcMode;
        }

        public final void setIpcMode(String ipcMode) {
            this.ipcMode = ipcMode;
        }

        @Override
        public final Builder ipcMode(String ipcMode) {
            this.ipcMode = ipcMode;
            return this;
        }

        public final String getMemory() {
            return this.memory;
        }

        public final void setMemory(String memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public final String getNetworkMode() {
            return this.networkMode;
        }

        public final void setNetworkMode(String networkMode) {
            this.networkMode = networkMode;
        }

        @Override
        public final Builder networkMode(String networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        public final String getPidMode() {
            return this.pidMode;
        }

        public final void setPidMode(String pidMode) {
            this.pidMode = pidMode;
        }

        @Override
        public final Builder pidMode(String pidMode) {
            this.pidMode = pidMode;
            return this;
        }

        public final List<AwsEcsTaskDefinitionPlacementConstraintsDetails.Builder> getPlacementConstraints() {
            List<AwsEcsTaskDefinitionPlacementConstraintsDetails.Builder> result = AwsEcsTaskDefinitionPlacementConstraintsListCopier.copyToBuilder(this.placementConstraints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlacementConstraints(Collection<AwsEcsTaskDefinitionPlacementConstraintsDetails.BuilderImpl> placementConstraints) {
            this.placementConstraints = AwsEcsTaskDefinitionPlacementConstraintsListCopier.copyFromBuilder(placementConstraints);
        }

        @Override
        public final Builder placementConstraints(Collection<AwsEcsTaskDefinitionPlacementConstraintsDetails> placementConstraints) {
            this.placementConstraints = AwsEcsTaskDefinitionPlacementConstraintsListCopier.copy(placementConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(AwsEcsTaskDefinitionPlacementConstraintsDetails ... placementConstraints) {
            this.placementConstraints(Arrays.asList(placementConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(Consumer<AwsEcsTaskDefinitionPlacementConstraintsDetails.Builder> ... placementConstraints) {
            this.placementConstraints(Stream.of(placementConstraints).map(c -> (AwsEcsTaskDefinitionPlacementConstraintsDetails)((AwsEcsTaskDefinitionPlacementConstraintsDetails.Builder)AwsEcsTaskDefinitionPlacementConstraintsDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AwsEcsTaskDefinitionProxyConfigurationDetails.Builder getProxyConfiguration() {
            return this.proxyConfiguration != null ? this.proxyConfiguration.toBuilder() : null;
        }

        public final void setProxyConfiguration(AwsEcsTaskDefinitionProxyConfigurationDetails.BuilderImpl proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration != null ? proxyConfiguration.build() : null;
        }

        @Override
        public final Builder proxyConfiguration(AwsEcsTaskDefinitionProxyConfigurationDetails proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        public final Collection<String> getRequiresCompatibilities() {
            if (this.requiresCompatibilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.requiresCompatibilities;
        }

        public final void setRequiresCompatibilities(Collection<String> requiresCompatibilities) {
            this.requiresCompatibilities = NonEmptyStringListCopier.copy(requiresCompatibilities);
        }

        @Override
        public final Builder requiresCompatibilities(Collection<String> requiresCompatibilities) {
            this.requiresCompatibilities = NonEmptyStringListCopier.copy(requiresCompatibilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiresCompatibilities(String ... requiresCompatibilities) {
            this.requiresCompatibilities(Arrays.asList(requiresCompatibilities));
            return this;
        }

        public final String getTaskRoleArn() {
            return this.taskRoleArn;
        }

        public final void setTaskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
        }

        @Override
        public final Builder taskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
            return this;
        }

        public final List<AwsEcsTaskDefinitionVolumesDetails.Builder> getVolumes() {
            List<AwsEcsTaskDefinitionVolumesDetails.Builder> result = AwsEcsTaskDefinitionVolumesListCopier.copyToBuilder(this.volumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumes(Collection<AwsEcsTaskDefinitionVolumesDetails.BuilderImpl> volumes) {
            this.volumes = AwsEcsTaskDefinitionVolumesListCopier.copyFromBuilder(volumes);
        }

        @Override
        public final Builder volumes(Collection<AwsEcsTaskDefinitionVolumesDetails> volumes) {
            this.volumes = AwsEcsTaskDefinitionVolumesListCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(AwsEcsTaskDefinitionVolumesDetails ... volumes) {
            this.volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<AwsEcsTaskDefinitionVolumesDetails.Builder> ... volumes) {
            this.volumes(Stream.of(volumes).map(c -> (AwsEcsTaskDefinitionVolumesDetails)((AwsEcsTaskDefinitionVolumesDetails.Builder)AwsEcsTaskDefinitionVolumesDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public AwsEcsTaskDefinitionDetails build() {
            return new AwsEcsTaskDefinitionDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEcsTaskDefinitionDetails> {
        public Builder containerDefinitions(Collection<AwsEcsTaskDefinitionContainerDefinitionsDetails> var1);

        public Builder containerDefinitions(AwsEcsTaskDefinitionContainerDefinitionsDetails ... var1);

        public Builder containerDefinitions(Consumer<AwsEcsTaskDefinitionContainerDefinitionsDetails.Builder> ... var1);

        public Builder cpu(String var1);

        public Builder executionRoleArn(String var1);

        public Builder family(String var1);

        public Builder inferenceAccelerators(Collection<AwsEcsTaskDefinitionInferenceAcceleratorsDetails> var1);

        public Builder inferenceAccelerators(AwsEcsTaskDefinitionInferenceAcceleratorsDetails ... var1);

        public Builder inferenceAccelerators(Consumer<AwsEcsTaskDefinitionInferenceAcceleratorsDetails.Builder> ... var1);

        public Builder ipcMode(String var1);

        public Builder memory(String var1);

        public Builder networkMode(String var1);

        public Builder pidMode(String var1);

        public Builder placementConstraints(Collection<AwsEcsTaskDefinitionPlacementConstraintsDetails> var1);

        public Builder placementConstraints(AwsEcsTaskDefinitionPlacementConstraintsDetails ... var1);

        public Builder placementConstraints(Consumer<AwsEcsTaskDefinitionPlacementConstraintsDetails.Builder> ... var1);

        public Builder proxyConfiguration(AwsEcsTaskDefinitionProxyConfigurationDetails var1);

        default public Builder proxyConfiguration(Consumer<AwsEcsTaskDefinitionProxyConfigurationDetails.Builder> proxyConfiguration) {
            return this.proxyConfiguration((AwsEcsTaskDefinitionProxyConfigurationDetails)((AwsEcsTaskDefinitionProxyConfigurationDetails.Builder)AwsEcsTaskDefinitionProxyConfigurationDetails.builder().applyMutation(proxyConfiguration)).build());
        }

        public Builder requiresCompatibilities(Collection<String> var1);

        public Builder requiresCompatibilities(String ... var1);

        public Builder taskRoleArn(String var1);

        public Builder volumes(Collection<AwsEcsTaskDefinitionVolumesDetails> var1);

        public Builder volumes(AwsEcsTaskDefinitionVolumesDetails ... var1);

        public Builder volumes(Consumer<AwsEcsTaskDefinitionVolumesDetails.Builder> ... var1);

        public Builder status(String var1);
    }
}

