/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.InsightResultValue;
import software.amazon.awssdk.services.securityhub.model.InsightResultValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InsightResults
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InsightResults> {
    private static final SdkField<String> INSIGHT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InsightArn").getter(InsightResults.getter(InsightResults::insightArn)).setter(InsightResults.setter(Builder::insightArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightArn").build()}).build();
    private static final SdkField<String> GROUP_BY_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupByAttribute").getter(InsightResults.getter(InsightResults::groupByAttribute)).setter(InsightResults.setter(Builder::groupByAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByAttribute").build()}).build();
    private static final SdkField<List<InsightResultValue>> RESULT_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResultValues").getter(InsightResults.getter(InsightResults::resultValues)).setter(InsightResults.setter(Builder::resultValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InsightResultValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_ARN_FIELD, GROUP_BY_ATTRIBUTE_FIELD, RESULT_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InsightArn", INSIGHT_ARN_FIELD);
            this.put("GroupByAttribute", GROUP_BY_ATTRIBUTE_FIELD);
            this.put("ResultValues", RESULT_VALUES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String insightArn;
    private final String groupByAttribute;
    private final List<InsightResultValue> resultValues;

    private InsightResults(BuilderImpl builder) {
        this.insightArn = builder.insightArn;
        this.groupByAttribute = builder.groupByAttribute;
        this.resultValues = builder.resultValues;
    }

    public final String insightArn() {
        return this.insightArn;
    }

    public final String groupByAttribute() {
        return this.groupByAttribute;
    }

    public final boolean hasResultValues() {
        return this.resultValues != null && !(this.resultValues instanceof SdkAutoConstructList);
    }

    public final List<InsightResultValue> resultValues() {
        return this.resultValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.insightArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupByAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResultValues() ? this.resultValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightResults)) {
            return false;
        }
        InsightResults other = (InsightResults)obj;
        return Objects.equals(this.insightArn(), other.insightArn()) && Objects.equals(this.groupByAttribute(), other.groupByAttribute()) && this.hasResultValues() == other.hasResultValues() && Objects.equals(this.resultValues(), other.resultValues());
    }

    public final String toString() {
        return ToString.builder((String)"InsightResults").add("InsightArn", (Object)this.insightArn()).add("GroupByAttribute", (Object)this.groupByAttribute()).add("ResultValues", this.hasResultValues() ? this.resultValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InsightArn": {
                return Optional.ofNullable(clazz.cast(this.insightArn()));
            }
            case "GroupByAttribute": {
                return Optional.ofNullable(clazz.cast(this.groupByAttribute()));
            }
            case "ResultValues": {
                return Optional.ofNullable(clazz.cast(this.resultValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InsightResults, T> g) {
        return obj -> g.apply((InsightResults)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String insightArn;
        private String groupByAttribute;
        private List<InsightResultValue> resultValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InsightResults model) {
            this.insightArn(model.insightArn);
            this.groupByAttribute(model.groupByAttribute);
            this.resultValues(model.resultValues);
        }

        public final String getInsightArn() {
            return this.insightArn;
        }

        public final void setInsightArn(String insightArn) {
            this.insightArn = insightArn;
        }

        @Override
        public final Builder insightArn(String insightArn) {
            this.insightArn = insightArn;
            return this;
        }

        public final String getGroupByAttribute() {
            return this.groupByAttribute;
        }

        public final void setGroupByAttribute(String groupByAttribute) {
            this.groupByAttribute = groupByAttribute;
        }

        @Override
        public final Builder groupByAttribute(String groupByAttribute) {
            this.groupByAttribute = groupByAttribute;
            return this;
        }

        public final List<InsightResultValue.Builder> getResultValues() {
            List<InsightResultValue.Builder> result = InsightResultValueListCopier.copyToBuilder(this.resultValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultValues(Collection<InsightResultValue.BuilderImpl> resultValues) {
            this.resultValues = InsightResultValueListCopier.copyFromBuilder(resultValues);
        }

        @Override
        public final Builder resultValues(Collection<InsightResultValue> resultValues) {
            this.resultValues = InsightResultValueListCopier.copy(resultValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultValues(InsightResultValue ... resultValues) {
            this.resultValues(Arrays.asList(resultValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultValues(Consumer<InsightResultValue.Builder> ... resultValues) {
            this.resultValues(Stream.of(resultValues).map(c -> (InsightResultValue)((InsightResultValue.Builder)InsightResultValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public InsightResults build() {
            return new InsightResults(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InsightResults> {
        public Builder insightArn(String var1);

        public Builder groupByAttribute(String var1);

        public Builder resultValues(Collection<InsightResultValue> var1);

        public Builder resultValues(InsightResultValue ... var1);

        public Builder resultValues(Consumer<InsightResultValue.Builder> ... var1);
    }
}

