/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.ControlFindingGenerator;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.services.securityhub.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableSecurityHubRequest
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, EnableSecurityHubRequest> {
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(EnableSecurityHubRequest.getter(EnableSecurityHubRequest::tags)).setter(EnableSecurityHubRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_DEFAULT_STANDARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableDefaultStandards").getter(EnableSecurityHubRequest.getter(EnableSecurityHubRequest::enableDefaultStandards)).setter(EnableSecurityHubRequest.setter(Builder::enableDefaultStandards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDefaultStandards").build()}).build();
    private static final SdkField<String> CONTROL_FINDING_GENERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ControlFindingGenerator").getter(EnableSecurityHubRequest.getter(EnableSecurityHubRequest::controlFindingGeneratorAsString)).setter(EnableSecurityHubRequest.setter(Builder::controlFindingGenerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlFindingGenerator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGS_FIELD, ENABLE_DEFAULT_STANDARDS_FIELD, CONTROL_FINDING_GENERATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Tags", TAGS_FIELD);
            this.put("EnableDefaultStandards", ENABLE_DEFAULT_STANDARDS_FIELD);
            this.put("ControlFindingGenerator", CONTROL_FINDING_GENERATOR_FIELD);
        }
    });
    private final Map<String, String> tags;
    private final Boolean enableDefaultStandards;
    private final String controlFindingGenerator;

    private EnableSecurityHubRequest(BuilderImpl builder) {
        super(builder);
        this.tags = builder.tags;
        this.enableDefaultStandards = builder.enableDefaultStandards;
        this.controlFindingGenerator = builder.controlFindingGenerator;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Boolean enableDefaultStandards() {
        return this.enableDefaultStandards;
    }

    public final ControlFindingGenerator controlFindingGenerator() {
        return ControlFindingGenerator.fromValue(this.controlFindingGenerator);
    }

    public final String controlFindingGeneratorAsString() {
        return this.controlFindingGenerator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDefaultStandards());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlFindingGeneratorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableSecurityHubRequest)) {
            return false;
        }
        EnableSecurityHubRequest other = (EnableSecurityHubRequest)((Object)obj);
        return this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.enableDefaultStandards(), other.enableDefaultStandards()) && Objects.equals(this.controlFindingGeneratorAsString(), other.controlFindingGeneratorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EnableSecurityHubRequest").add("Tags", this.hasTags() ? this.tags() : null).add("EnableDefaultStandards", (Object)this.enableDefaultStandards()).add("ControlFindingGenerator", (Object)this.controlFindingGeneratorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "EnableDefaultStandards": {
                return Optional.ofNullable(clazz.cast(this.enableDefaultStandards()));
            }
            case "ControlFindingGenerator": {
                return Optional.ofNullable(clazz.cast(this.controlFindingGeneratorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EnableSecurityHubRequest, T> g) {
        return obj -> g.apply((EnableSecurityHubRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Boolean enableDefaultStandards;
        private String controlFindingGenerator;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableSecurityHubRequest model) {
            super(model);
            this.tags(model.tags);
            this.enableDefaultStandards(model.enableDefaultStandards);
            this.controlFindingGenerator(model.controlFindingGenerator);
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Boolean getEnableDefaultStandards() {
            return this.enableDefaultStandards;
        }

        public final void setEnableDefaultStandards(Boolean enableDefaultStandards) {
            this.enableDefaultStandards = enableDefaultStandards;
        }

        @Override
        public final Builder enableDefaultStandards(Boolean enableDefaultStandards) {
            this.enableDefaultStandards = enableDefaultStandards;
            return this;
        }

        public final String getControlFindingGenerator() {
            return this.controlFindingGenerator;
        }

        public final void setControlFindingGenerator(String controlFindingGenerator) {
            this.controlFindingGenerator = controlFindingGenerator;
        }

        @Override
        public final Builder controlFindingGenerator(String controlFindingGenerator) {
            this.controlFindingGenerator = controlFindingGenerator;
            return this;
        }

        @Override
        public final Builder controlFindingGenerator(ControlFindingGenerator controlFindingGenerator) {
            this.controlFindingGenerator(controlFindingGenerator == null ? null : controlFindingGenerator.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableSecurityHubRequest build() {
            return new EnableSecurityHubRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EnableSecurityHubRequest> {
        public Builder tags(Map<String, String> var1);

        public Builder enableDefaultStandards(Boolean var1);

        public Builder controlFindingGenerator(String var1);

        public Builder controlFindingGenerator(ControlFindingGenerator var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

