/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.CustomizablePropertiesCopier;
import software.amazon.awssdk.services.securityhub.model.ParameterDefinition;
import software.amazon.awssdk.services.securityhub.model.ParameterDefinitionsCopier;
import software.amazon.awssdk.services.securityhub.model.RegionAvailabilityStatus;
import software.amazon.awssdk.services.securityhub.model.SecurityControlProperty;
import software.amazon.awssdk.services.securityhub.model.SeverityRating;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityControlDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecurityControlDefinition> {
    private static final SdkField<String> SECURITY_CONTROL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityControlId").getter(SecurityControlDefinition.getter(SecurityControlDefinition::securityControlId)).setter(SecurityControlDefinition.setter(Builder::securityControlId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityControlId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(SecurityControlDefinition.getter(SecurityControlDefinition::title)).setter(SecurityControlDefinition.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(SecurityControlDefinition.getter(SecurityControlDefinition::description)).setter(SecurityControlDefinition.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> REMEDIATION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemediationUrl").getter(SecurityControlDefinition.getter(SecurityControlDefinition::remediationUrl)).setter(SecurityControlDefinition.setter(Builder::remediationUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationUrl").build()}).build();
    private static final SdkField<String> SEVERITY_RATING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SeverityRating").getter(SecurityControlDefinition.getter(SecurityControlDefinition::severityRatingAsString)).setter(SecurityControlDefinition.setter(Builder::severityRating)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeverityRating").build()}).build();
    private static final SdkField<String> CURRENT_REGION_AVAILABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentRegionAvailability").getter(SecurityControlDefinition.getter(SecurityControlDefinition::currentRegionAvailabilityAsString)).setter(SecurityControlDefinition.setter(Builder::currentRegionAvailability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentRegionAvailability").build()}).build();
    private static final SdkField<List<String>> CUSTOMIZABLE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomizableProperties").getter(SecurityControlDefinition.getter(SecurityControlDefinition::customizablePropertiesAsStrings)).setter(SecurityControlDefinition.setter(Builder::customizablePropertiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomizableProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ParameterDefinition>> PARAMETER_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ParameterDefinitions").getter(SecurityControlDefinition.getter(SecurityControlDefinition::parameterDefinitions)).setter(SecurityControlDefinition.setter(Builder::parameterDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterDefinitions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_CONTROL_ID_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, REMEDIATION_URL_FIELD, SEVERITY_RATING_FIELD, CURRENT_REGION_AVAILABILITY_FIELD, CUSTOMIZABLE_PROPERTIES_FIELD, PARAMETER_DEFINITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SecurityControlId", SECURITY_CONTROL_ID_FIELD);
            this.put("Title", TITLE_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("RemediationUrl", REMEDIATION_URL_FIELD);
            this.put("SeverityRating", SEVERITY_RATING_FIELD);
            this.put("CurrentRegionAvailability", CURRENT_REGION_AVAILABILITY_FIELD);
            this.put("CustomizableProperties", CUSTOMIZABLE_PROPERTIES_FIELD);
            this.put("ParameterDefinitions", PARAMETER_DEFINITIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String securityControlId;
    private final String title;
    private final String description;
    private final String remediationUrl;
    private final String severityRating;
    private final String currentRegionAvailability;
    private final List<String> customizableProperties;
    private final Map<String, ParameterDefinition> parameterDefinitions;

    private SecurityControlDefinition(BuilderImpl builder) {
        this.securityControlId = builder.securityControlId;
        this.title = builder.title;
        this.description = builder.description;
        this.remediationUrl = builder.remediationUrl;
        this.severityRating = builder.severityRating;
        this.currentRegionAvailability = builder.currentRegionAvailability;
        this.customizableProperties = builder.customizableProperties;
        this.parameterDefinitions = builder.parameterDefinitions;
    }

    public final String securityControlId() {
        return this.securityControlId;
    }

    public final String title() {
        return this.title;
    }

    public final String description() {
        return this.description;
    }

    public final String remediationUrl() {
        return this.remediationUrl;
    }

    public final SeverityRating severityRating() {
        return SeverityRating.fromValue(this.severityRating);
    }

    public final String severityRatingAsString() {
        return this.severityRating;
    }

    public final RegionAvailabilityStatus currentRegionAvailability() {
        return RegionAvailabilityStatus.fromValue(this.currentRegionAvailability);
    }

    public final String currentRegionAvailabilityAsString() {
        return this.currentRegionAvailability;
    }

    public final List<SecurityControlProperty> customizableProperties() {
        return CustomizablePropertiesCopier.copyStringToEnum(this.customizableProperties);
    }

    public final boolean hasCustomizableProperties() {
        return this.customizableProperties != null && !(this.customizableProperties instanceof SdkAutoConstructList);
    }

    public final List<String> customizablePropertiesAsStrings() {
        return this.customizableProperties;
    }

    public final boolean hasParameterDefinitions() {
        return this.parameterDefinitions != null && !(this.parameterDefinitions instanceof SdkAutoConstructMap);
    }

    public final Map<String, ParameterDefinition> parameterDefinitions() {
        return this.parameterDefinitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.securityControlId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.remediationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityRatingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentRegionAvailabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomizableProperties() ? this.customizablePropertiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameterDefinitions() ? this.parameterDefinitions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityControlDefinition)) {
            return false;
        }
        SecurityControlDefinition other = (SecurityControlDefinition)obj;
        return Objects.equals(this.securityControlId(), other.securityControlId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.remediationUrl(), other.remediationUrl()) && Objects.equals(this.severityRatingAsString(), other.severityRatingAsString()) && Objects.equals(this.currentRegionAvailabilityAsString(), other.currentRegionAvailabilityAsString()) && this.hasCustomizableProperties() == other.hasCustomizableProperties() && Objects.equals(this.customizablePropertiesAsStrings(), other.customizablePropertiesAsStrings()) && this.hasParameterDefinitions() == other.hasParameterDefinitions() && Objects.equals(this.parameterDefinitions(), other.parameterDefinitions());
    }

    public final String toString() {
        return ToString.builder((String)"SecurityControlDefinition").add("SecurityControlId", (Object)this.securityControlId()).add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("RemediationUrl", (Object)this.remediationUrl()).add("SeverityRating", (Object)this.severityRatingAsString()).add("CurrentRegionAvailability", (Object)this.currentRegionAvailabilityAsString()).add("CustomizableProperties", this.hasCustomizableProperties() ? this.customizablePropertiesAsStrings() : null).add("ParameterDefinitions", this.hasParameterDefinitions() ? this.parameterDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityControlId": {
                return Optional.ofNullable(clazz.cast(this.securityControlId()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RemediationUrl": {
                return Optional.ofNullable(clazz.cast(this.remediationUrl()));
            }
            case "SeverityRating": {
                return Optional.ofNullable(clazz.cast(this.severityRatingAsString()));
            }
            case "CurrentRegionAvailability": {
                return Optional.ofNullable(clazz.cast(this.currentRegionAvailabilityAsString()));
            }
            case "CustomizableProperties": {
                return Optional.ofNullable(clazz.cast(this.customizablePropertiesAsStrings()));
            }
            case "ParameterDefinitions": {
                return Optional.ofNullable(clazz.cast(this.parameterDefinitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SecurityControlDefinition, T> g) {
        return obj -> g.apply((SecurityControlDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String securityControlId;
        private String title;
        private String description;
        private String remediationUrl;
        private String severityRating;
        private String currentRegionAvailability;
        private List<String> customizableProperties = DefaultSdkAutoConstructList.getInstance();
        private Map<String, ParameterDefinition> parameterDefinitions = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityControlDefinition model) {
            this.securityControlId(model.securityControlId);
            this.title(model.title);
            this.description(model.description);
            this.remediationUrl(model.remediationUrl);
            this.severityRating(model.severityRating);
            this.currentRegionAvailability(model.currentRegionAvailability);
            this.customizablePropertiesWithStrings(model.customizableProperties);
            this.parameterDefinitions(model.parameterDefinitions);
        }

        public final String getSecurityControlId() {
            return this.securityControlId;
        }

        public final void setSecurityControlId(String securityControlId) {
            this.securityControlId = securityControlId;
        }

        @Override
        public final Builder securityControlId(String securityControlId) {
            this.securityControlId = securityControlId;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRemediationUrl() {
            return this.remediationUrl;
        }

        public final void setRemediationUrl(String remediationUrl) {
            this.remediationUrl = remediationUrl;
        }

        @Override
        public final Builder remediationUrl(String remediationUrl) {
            this.remediationUrl = remediationUrl;
            return this;
        }

        public final String getSeverityRating() {
            return this.severityRating;
        }

        public final void setSeverityRating(String severityRating) {
            this.severityRating = severityRating;
        }

        @Override
        public final Builder severityRating(String severityRating) {
            this.severityRating = severityRating;
            return this;
        }

        @Override
        public final Builder severityRating(SeverityRating severityRating) {
            this.severityRating(severityRating == null ? null : severityRating.toString());
            return this;
        }

        public final String getCurrentRegionAvailability() {
            return this.currentRegionAvailability;
        }

        public final void setCurrentRegionAvailability(String currentRegionAvailability) {
            this.currentRegionAvailability = currentRegionAvailability;
        }

        @Override
        public final Builder currentRegionAvailability(String currentRegionAvailability) {
            this.currentRegionAvailability = currentRegionAvailability;
            return this;
        }

        @Override
        public final Builder currentRegionAvailability(RegionAvailabilityStatus currentRegionAvailability) {
            this.currentRegionAvailability(currentRegionAvailability == null ? null : currentRegionAvailability.toString());
            return this;
        }

        public final Collection<String> getCustomizableProperties() {
            if (this.customizableProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customizableProperties;
        }

        public final void setCustomizableProperties(Collection<String> customizableProperties) {
            this.customizableProperties = CustomizablePropertiesCopier.copy(customizableProperties);
        }

        @Override
        public final Builder customizablePropertiesWithStrings(Collection<String> customizableProperties) {
            this.customizableProperties = CustomizablePropertiesCopier.copy(customizableProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customizablePropertiesWithStrings(String ... customizableProperties) {
            this.customizablePropertiesWithStrings(Arrays.asList(customizableProperties));
            return this;
        }

        @Override
        public final Builder customizableProperties(Collection<SecurityControlProperty> customizableProperties) {
            this.customizableProperties = CustomizablePropertiesCopier.copyEnumToString(customizableProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customizableProperties(SecurityControlProperty ... customizableProperties) {
            this.customizableProperties(Arrays.asList(customizableProperties));
            return this;
        }

        public final Map<String, ParameterDefinition.Builder> getParameterDefinitions() {
            Map<String, ParameterDefinition.Builder> result = ParameterDefinitionsCopier.copyToBuilder(this.parameterDefinitions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameterDefinitions(Map<String, ParameterDefinition.BuilderImpl> parameterDefinitions) {
            this.parameterDefinitions = ParameterDefinitionsCopier.copyFromBuilder(parameterDefinitions);
        }

        @Override
        public final Builder parameterDefinitions(Map<String, ParameterDefinition> parameterDefinitions) {
            this.parameterDefinitions = ParameterDefinitionsCopier.copy(parameterDefinitions);
            return this;
        }

        public SecurityControlDefinition build() {
            return new SecurityControlDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecurityControlDefinition> {
        public Builder securityControlId(String var1);

        public Builder title(String var1);

        public Builder description(String var1);

        public Builder remediationUrl(String var1);

        public Builder severityRating(String var1);

        public Builder severityRating(SeverityRating var1);

        public Builder currentRegionAvailability(String var1);

        public Builder currentRegionAvailability(RegionAvailabilityStatus var1);

        public Builder customizablePropertiesWithStrings(Collection<String> var1);

        public Builder customizablePropertiesWithStrings(String ... var1);

        public Builder customizableProperties(Collection<SecurityControlProperty> var1);

        public Builder customizableProperties(SecurityControlProperty ... var1);

        public Builder parameterDefinitions(Map<String, ParameterDefinition> var1);
    }
}

