/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEcrContainerImageDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEcrContainerImageDetails> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistryId").getter(AwsEcrContainerImageDetails.getter(AwsEcrContainerImageDetails::registryId)).setter(AwsEcrContainerImageDetails.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryId").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RepositoryName").getter(AwsEcrContainerImageDetails.getter(AwsEcrContainerImageDetails::repositoryName)).setter(AwsEcrContainerImageDetails.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryName").build()}).build();
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Architecture").getter(AwsEcrContainerImageDetails.getter(AwsEcrContainerImageDetails::architecture)).setter(AwsEcrContainerImageDetails.setter(Builder::architecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architecture").build()}).build();
    private static final SdkField<String> IMAGE_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageDigest").getter(AwsEcrContainerImageDetails.getter(AwsEcrContainerImageDetails::imageDigest)).setter(AwsEcrContainerImageDetails.setter(Builder::imageDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageDigest").build()}).build();
    private static final SdkField<List<String>> IMAGE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImageTags").getter(AwsEcrContainerImageDetails.getter(AwsEcrContainerImageDetails::imageTags)).setter(AwsEcrContainerImageDetails.setter(Builder::imageTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IMAGE_PUBLISHED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImagePublishedAt").getter(AwsEcrContainerImageDetails.getter(AwsEcrContainerImageDetails::imagePublishedAt)).setter(AwsEcrContainerImageDetails.setter(Builder::imagePublishedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImagePublishedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD, REPOSITORY_NAME_FIELD, ARCHITECTURE_FIELD, IMAGE_DIGEST_FIELD, IMAGE_TAGS_FIELD, IMAGE_PUBLISHED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RegistryId", REGISTRY_ID_FIELD);
            this.put("RepositoryName", REPOSITORY_NAME_FIELD);
            this.put("Architecture", ARCHITECTURE_FIELD);
            this.put("ImageDigest", IMAGE_DIGEST_FIELD);
            this.put("ImageTags", IMAGE_TAGS_FIELD);
            this.put("ImagePublishedAt", IMAGE_PUBLISHED_AT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String registryId;
    private final String repositoryName;
    private final String architecture;
    private final String imageDigest;
    private final List<String> imageTags;
    private final String imagePublishedAt;

    private AwsEcrContainerImageDetails(BuilderImpl builder) {
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.architecture = builder.architecture;
        this.imageDigest = builder.imageDigest;
        this.imageTags = builder.imageTags;
        this.imagePublishedAt = builder.imagePublishedAt;
    }

    public final String registryId() {
        return this.registryId;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final String architecture() {
        return this.architecture;
    }

    public final String imageDigest() {
        return this.imageDigest;
    }

    public final boolean hasImageTags() {
        return this.imageTags != null && !(this.imageTags instanceof SdkAutoConstructList);
    }

    public final List<String> imageTags() {
        return this.imageTags;
    }

    public final String imagePublishedAt() {
        return this.imagePublishedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.architecture());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageTags() ? this.imageTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.imagePublishedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcrContainerImageDetails)) {
            return false;
        }
        AwsEcrContainerImageDetails other = (AwsEcrContainerImageDetails)obj;
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.architecture(), other.architecture()) && Objects.equals(this.imageDigest(), other.imageDigest()) && this.hasImageTags() == other.hasImageTags() && Objects.equals(this.imageTags(), other.imageTags()) && Objects.equals(this.imagePublishedAt(), other.imagePublishedAt());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEcrContainerImageDetails").add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("Architecture", (Object)this.architecture()).add("ImageDigest", (Object)this.imageDigest()).add("ImageTags", this.hasImageTags() ? this.imageTags() : null).add("ImagePublishedAt", (Object)this.imagePublishedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegistryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "RepositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "Architecture": {
                return Optional.ofNullable(clazz.cast(this.architecture()));
            }
            case "ImageDigest": {
                return Optional.ofNullable(clazz.cast(this.imageDigest()));
            }
            case "ImageTags": {
                return Optional.ofNullable(clazz.cast(this.imageTags()));
            }
            case "ImagePublishedAt": {
                return Optional.ofNullable(clazz.cast(this.imagePublishedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcrContainerImageDetails, T> g) {
        return obj -> g.apply((AwsEcrContainerImageDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String architecture;
        private String imageDigest;
        private List<String> imageTags = DefaultSdkAutoConstructList.getInstance();
        private String imagePublishedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcrContainerImageDetails model) {
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.architecture(model.architecture);
            this.imageDigest(model.imageDigest);
            this.imageTags(model.imageTags);
            this.imagePublishedAt(model.imagePublishedAt);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final String getImageDigest() {
            return this.imageDigest;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final Collection<String> getImageTags() {
            if (this.imageTags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.imageTags;
        }

        public final void setImageTags(Collection<String> imageTags) {
            this.imageTags = NonEmptyStringListCopier.copy(imageTags);
        }

        @Override
        public final Builder imageTags(Collection<String> imageTags) {
            this.imageTags = NonEmptyStringListCopier.copy(imageTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageTags(String ... imageTags) {
            this.imageTags(Arrays.asList(imageTags));
            return this;
        }

        public final String getImagePublishedAt() {
            return this.imagePublishedAt;
        }

        public final void setImagePublishedAt(String imagePublishedAt) {
            this.imagePublishedAt = imagePublishedAt;
        }

        @Override
        public final Builder imagePublishedAt(String imagePublishedAt) {
            this.imagePublishedAt = imagePublishedAt;
            return this;
        }

        public AwsEcrContainerImageDetails build() {
            return new AwsEcrContainerImageDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEcrContainerImageDetails> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder architecture(String var1);

        public Builder imageDigest(String var1);

        public Builder imageTags(Collection<String> var1);

        public Builder imageTags(String ... var1);

        public Builder imagePublishedAt(String var1);
    }
}

