/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationSummariesCopier;
import software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStandardsControlAssociationsResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, ListStandardsControlAssociationsResponse> {
    private static final SdkField<List<StandardsControlAssociationSummary>> STANDARDS_CONTROL_ASSOCIATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StandardsControlAssociationSummaries").getter(ListStandardsControlAssociationsResponse.getter(ListStandardsControlAssociationsResponse::standardsControlAssociationSummaries)).setter(ListStandardsControlAssociationsResponse.setter(Builder::standardsControlAssociationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsControlAssociationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StandardsControlAssociationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListStandardsControlAssociationsResponse.getter(ListStandardsControlAssociationsResponse::nextToken)).setter(ListStandardsControlAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARDS_CONTROL_ASSOCIATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<StandardsControlAssociationSummary> standardsControlAssociationSummaries;
    private final String nextToken;

    private ListStandardsControlAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.standardsControlAssociationSummaries = builder.standardsControlAssociationSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasStandardsControlAssociationSummaries() {
        return this.standardsControlAssociationSummaries != null && !(this.standardsControlAssociationSummaries instanceof SdkAutoConstructList);
    }

    public final List<StandardsControlAssociationSummary> standardsControlAssociationSummaries() {
        return this.standardsControlAssociationSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStandardsControlAssociationSummaries() ? this.standardsControlAssociationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStandardsControlAssociationsResponse)) {
            return false;
        }
        ListStandardsControlAssociationsResponse other = (ListStandardsControlAssociationsResponse)((Object)obj);
        return this.hasStandardsControlAssociationSummaries() == other.hasStandardsControlAssociationSummaries() && Objects.equals(this.standardsControlAssociationSummaries(), other.standardsControlAssociationSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListStandardsControlAssociationsResponse").add("StandardsControlAssociationSummaries", this.hasStandardsControlAssociationSummaries() ? this.standardsControlAssociationSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StandardsControlAssociationSummaries": {
                return Optional.ofNullable(clazz.cast(this.standardsControlAssociationSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStandardsControlAssociationsResponse, T> g) {
        return obj -> g.apply((ListStandardsControlAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<StandardsControlAssociationSummary> standardsControlAssociationSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStandardsControlAssociationsResponse model) {
            super(model);
            this.standardsControlAssociationSummaries(model.standardsControlAssociationSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<StandardsControlAssociationSummary.Builder> getStandardsControlAssociationSummaries() {
            List<StandardsControlAssociationSummary.Builder> result = StandardsControlAssociationSummariesCopier.copyToBuilder(this.standardsControlAssociationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStandardsControlAssociationSummaries(Collection<StandardsControlAssociationSummary.BuilderImpl> standardsControlAssociationSummaries) {
            this.standardsControlAssociationSummaries = StandardsControlAssociationSummariesCopier.copyFromBuilder(standardsControlAssociationSummaries);
        }

        @Override
        public final Builder standardsControlAssociationSummaries(Collection<StandardsControlAssociationSummary> standardsControlAssociationSummaries) {
            this.standardsControlAssociationSummaries = StandardsControlAssociationSummariesCopier.copy(standardsControlAssociationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standardsControlAssociationSummaries(StandardsControlAssociationSummary ... standardsControlAssociationSummaries) {
            this.standardsControlAssociationSummaries(Arrays.asList(standardsControlAssociationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standardsControlAssociationSummaries(Consumer<StandardsControlAssociationSummary.Builder> ... standardsControlAssociationSummaries) {
            this.standardsControlAssociationSummaries(Stream.of(standardsControlAssociationSummaries).map(c -> (StandardsControlAssociationSummary)((StandardsControlAssociationSummary.Builder)StandardsControlAssociationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStandardsControlAssociationsResponse build() {
            return new ListStandardsControlAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStandardsControlAssociationsResponse> {
        public Builder standardsControlAssociationSummaries(Collection<StandardsControlAssociationSummary> var1);

        public Builder standardsControlAssociationSummaries(StandardsControlAssociationSummary ... var1);

        public Builder standardsControlAssociationSummaries(Consumer<StandardsControlAssociationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

