/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationInstanceReplicationSubnetGroupDetails;
import software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationInstanceVpcSecurityGroupsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationInstanceVpcSecurityGroupsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsDmsReplicationInstanceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsDmsReplicationInstanceDetails> {
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocatedStorage").getter(AwsDmsReplicationInstanceDetails.getter(AwsDmsReplicationInstanceDetails::allocatedStorage)).setter(AwsDmsReplicationInstanceDetails.setter(Builder::allocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoMinorVersionUpgrade").getter(AwsDmsReplicationInstanceDetails.getter(AwsDmsReplicationInstanceDetails::autoMinorVersionUpgrade)).setter(AwsDmsReplicationInstanceDetails.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(AwsDmsReplicationInstanceDetails.getter(AwsDmsReplicationInstanceDetails::availabilityZone)).setter(AwsDmsReplicationInstanceDetails.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(AwsDmsReplicationInstanceDetails.getter(AwsDmsReplicationInstanceDetails::engineVersion)).setter(AwsDmsReplicationInstanceDetails.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(AwsDmsReplicationInstanceDetails.getter(AwsDmsReplicationInstanceDetails::kmsKeyId)).setter(AwsDmsReplicationInstanceDetails.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiAZ").getter(AwsDmsReplicationInstanceDetails.getter(AwsDmsReplicationInstanceDetails::multiAZ)).setter(AwsDmsReplicationInstanceDetails.setter(Builder::multiAZ)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(AwsDmsReplicationInstanceDetails.getter(AwsDmsReplicationInstanceDetails::preferredMaintenanceWindow)).setter(AwsDmsReplicationInstanceDetails.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PubliclyAccessible").getter(AwsDmsReplicationInstanceDetails.getter(AwsDmsReplicationInstanceDetails::publiclyAccessible)).setter(AwsDmsReplicationInstanceDetails.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build()}).build();
    private static final SdkField<String> REPLICATION_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationInstanceClass").getter(AwsDmsReplicationInstanceDetails.getter(AwsDmsReplicationInstanceDetails::replicationInstanceClass)).setter(AwsDmsReplicationInstanceDetails.setter(Builder::replicationInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceClass").build()}).build();
    private static final SdkField<String> REPLICATION_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationInstanceIdentifier").getter(AwsDmsReplicationInstanceDetails.getter(AwsDmsReplicationInstanceDetails::replicationInstanceIdentifier)).setter(AwsDmsReplicationInstanceDetails.setter(Builder::replicationInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceIdentifier").build()}).build();
    private static final SdkField<AwsDmsReplicationInstanceReplicationSubnetGroupDetails> REPLICATION_SUBNET_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReplicationSubnetGroup").getter(AwsDmsReplicationInstanceDetails.getter(AwsDmsReplicationInstanceDetails::replicationSubnetGroup)).setter(AwsDmsReplicationInstanceDetails.setter(Builder::replicationSubnetGroup)).constructor(AwsDmsReplicationInstanceReplicationSubnetGroupDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSubnetGroup").build()}).build();
    private static final SdkField<List<AwsDmsReplicationInstanceVpcSecurityGroupsDetails>> VPC_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroups").getter(AwsDmsReplicationInstanceDetails.getter(AwsDmsReplicationInstanceDetails::vpcSecurityGroups)).setter(AwsDmsReplicationInstanceDetails.setter(Builder::vpcSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsDmsReplicationInstanceVpcSecurityGroupsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATED_STORAGE_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, AVAILABILITY_ZONE_FIELD, ENGINE_VERSION_FIELD, KMS_KEY_ID_FIELD, MULTI_AZ_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PUBLICLY_ACCESSIBLE_FIELD, REPLICATION_INSTANCE_CLASS_FIELD, REPLICATION_INSTANCE_IDENTIFIER_FIELD, REPLICATION_SUBNET_GROUP_FIELD, VPC_SECURITY_GROUPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer allocatedStorage;
    private final Boolean autoMinorVersionUpgrade;
    private final String availabilityZone;
    private final String engineVersion;
    private final String kmsKeyId;
    private final Boolean multiAZ;
    private final String preferredMaintenanceWindow;
    private final Boolean publiclyAccessible;
    private final String replicationInstanceClass;
    private final String replicationInstanceIdentifier;
    private final AwsDmsReplicationInstanceReplicationSubnetGroupDetails replicationSubnetGroup;
    private final List<AwsDmsReplicationInstanceVpcSecurityGroupsDetails> vpcSecurityGroups;

    private AwsDmsReplicationInstanceDetails(BuilderImpl builder) {
        this.allocatedStorage = builder.allocatedStorage;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.availabilityZone = builder.availabilityZone;
        this.engineVersion = builder.engineVersion;
        this.kmsKeyId = builder.kmsKeyId;
        this.multiAZ = builder.multiAZ;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.replicationInstanceClass = builder.replicationInstanceClass;
        this.replicationInstanceIdentifier = builder.replicationInstanceIdentifier;
        this.replicationSubnetGroup = builder.replicationSubnetGroup;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
    }

    public final Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public final Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final Boolean multiAZ() {
        return this.multiAZ;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public final Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public final String replicationInstanceClass() {
        return this.replicationInstanceClass;
    }

    public final String replicationInstanceIdentifier() {
        return this.replicationInstanceIdentifier;
    }

    public final AwsDmsReplicationInstanceReplicationSubnetGroupDetails replicationSubnetGroup() {
        return this.replicationSubnetGroup;
    }

    public final boolean hasVpcSecurityGroups() {
        return this.vpcSecurityGroups != null && !(this.vpcSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<AwsDmsReplicationInstanceVpcSecurityGroupsDetails> vpcSecurityGroups() {
        return this.vpcSecurityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationSubnetGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroups() ? this.vpcSecurityGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsDmsReplicationInstanceDetails)) {
            return false;
        }
        AwsDmsReplicationInstanceDetails other = (AwsDmsReplicationInstanceDetails)obj;
        return Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.multiAZ(), other.multiAZ()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.replicationInstanceClass(), other.replicationInstanceClass()) && Objects.equals(this.replicationInstanceIdentifier(), other.replicationInstanceIdentifier()) && Objects.equals(this.replicationSubnetGroup(), other.replicationSubnetGroup()) && this.hasVpcSecurityGroups() == other.hasVpcSecurityGroups() && Objects.equals(this.vpcSecurityGroups(), other.vpcSecurityGroups());
    }

    public final String toString() {
        return ToString.builder((String)"AwsDmsReplicationInstanceDetails").add("AllocatedStorage", (Object)this.allocatedStorage()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("AvailabilityZone", (Object)this.availabilityZone()).add("EngineVersion", (Object)this.engineVersion()).add("KmsKeyId", (Object)this.kmsKeyId()).add("MultiAZ", (Object)this.multiAZ()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("ReplicationInstanceClass", (Object)this.replicationInstanceClass()).add("ReplicationInstanceIdentifier", (Object)this.replicationInstanceIdentifier()).add("ReplicationSubnetGroup", (Object)this.replicationSubnetGroup()).add("VpcSecurityGroups", this.hasVpcSecurityGroups() ? this.vpcSecurityGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "MultiAZ": {
                return Optional.ofNullable(clazz.cast(this.multiAZ()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "ReplicationInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceClass()));
            }
            case "ReplicationInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceIdentifier()));
            }
            case "ReplicationSubnetGroup": {
                return Optional.ofNullable(clazz.cast(this.replicationSubnetGroup()));
            }
            case "VpcSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsDmsReplicationInstanceDetails, T> g) {
        return obj -> g.apply((AwsDmsReplicationInstanceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer allocatedStorage;
        private Boolean autoMinorVersionUpgrade;
        private String availabilityZone;
        private String engineVersion;
        private String kmsKeyId;
        private Boolean multiAZ;
        private String preferredMaintenanceWindow;
        private Boolean publiclyAccessible;
        private String replicationInstanceClass;
        private String replicationInstanceIdentifier;
        private AwsDmsReplicationInstanceReplicationSubnetGroupDetails replicationSubnetGroup;
        private List<AwsDmsReplicationInstanceVpcSecurityGroupsDetails> vpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsDmsReplicationInstanceDetails model) {
            this.allocatedStorage(model.allocatedStorage);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.availabilityZone(model.availabilityZone);
            this.engineVersion(model.engineVersion);
            this.kmsKeyId(model.kmsKeyId);
            this.multiAZ(model.multiAZ);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.publiclyAccessible(model.publiclyAccessible);
            this.replicationInstanceClass(model.replicationInstanceClass);
            this.replicationInstanceIdentifier(model.replicationInstanceIdentifier);
            this.replicationSubnetGroup(model.replicationSubnetGroup);
            this.vpcSecurityGroups(model.vpcSecurityGroups);
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final String getReplicationInstanceClass() {
            return this.replicationInstanceClass;
        }

        public final void setReplicationInstanceClass(String replicationInstanceClass) {
            this.replicationInstanceClass = replicationInstanceClass;
        }

        @Override
        public final Builder replicationInstanceClass(String replicationInstanceClass) {
            this.replicationInstanceClass = replicationInstanceClass;
            return this;
        }

        public final String getReplicationInstanceIdentifier() {
            return this.replicationInstanceIdentifier;
        }

        public final void setReplicationInstanceIdentifier(String replicationInstanceIdentifier) {
            this.replicationInstanceIdentifier = replicationInstanceIdentifier;
        }

        @Override
        public final Builder replicationInstanceIdentifier(String replicationInstanceIdentifier) {
            this.replicationInstanceIdentifier = replicationInstanceIdentifier;
            return this;
        }

        public final AwsDmsReplicationInstanceReplicationSubnetGroupDetails.Builder getReplicationSubnetGroup() {
            return this.replicationSubnetGroup != null ? this.replicationSubnetGroup.toBuilder() : null;
        }

        public final void setReplicationSubnetGroup(AwsDmsReplicationInstanceReplicationSubnetGroupDetails.BuilderImpl replicationSubnetGroup) {
            this.replicationSubnetGroup = replicationSubnetGroup != null ? replicationSubnetGroup.build() : null;
        }

        @Override
        public final Builder replicationSubnetGroup(AwsDmsReplicationInstanceReplicationSubnetGroupDetails replicationSubnetGroup) {
            this.replicationSubnetGroup = replicationSubnetGroup;
            return this;
        }

        public final List<AwsDmsReplicationInstanceVpcSecurityGroupsDetails.Builder> getVpcSecurityGroups() {
            List<AwsDmsReplicationInstanceVpcSecurityGroupsDetails.Builder> result = AwsDmsReplicationInstanceVpcSecurityGroupsListCopier.copyToBuilder(this.vpcSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcSecurityGroups(Collection<AwsDmsReplicationInstanceVpcSecurityGroupsDetails.BuilderImpl> vpcSecurityGroups) {
            this.vpcSecurityGroups = AwsDmsReplicationInstanceVpcSecurityGroupsListCopier.copyFromBuilder(vpcSecurityGroups);
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<AwsDmsReplicationInstanceVpcSecurityGroupsDetails> vpcSecurityGroups) {
            this.vpcSecurityGroups = AwsDmsReplicationInstanceVpcSecurityGroupsListCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(AwsDmsReplicationInstanceVpcSecurityGroupsDetails ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(Consumer<AwsDmsReplicationInstanceVpcSecurityGroupsDetails.Builder> ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Stream.of(vpcSecurityGroups).map(c -> (AwsDmsReplicationInstanceVpcSecurityGroupsDetails)((AwsDmsReplicationInstanceVpcSecurityGroupsDetails.Builder)AwsDmsReplicationInstanceVpcSecurityGroupsDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AwsDmsReplicationInstanceDetails build() {
            return new AwsDmsReplicationInstanceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsDmsReplicationInstanceDetails> {
        public Builder allocatedStorage(Integer var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder availabilityZone(String var1);

        public Builder engineVersion(String var1);

        public Builder kmsKeyId(String var1);

        public Builder multiAZ(Boolean var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder replicationInstanceClass(String var1);

        public Builder replicationInstanceIdentifier(String var1);

        public Builder replicationSubnetGroup(AwsDmsReplicationInstanceReplicationSubnetGroupDetails var1);

        default public Builder replicationSubnetGroup(Consumer<AwsDmsReplicationInstanceReplicationSubnetGroupDetails.Builder> replicationSubnetGroup) {
            return this.replicationSubnetGroup((AwsDmsReplicationInstanceReplicationSubnetGroupDetails)((AwsDmsReplicationInstanceReplicationSubnetGroupDetails.Builder)AwsDmsReplicationInstanceReplicationSubnetGroupDetails.builder().applyMutation(replicationSubnetGroup)).build());
        }

        public Builder vpcSecurityGroups(Collection<AwsDmsReplicationInstanceVpcSecurityGroupsDetails> var1);

        public Builder vpcSecurityGroups(AwsDmsReplicationInstanceVpcSecurityGroupsDetails ... var1);

        public Builder vpcSecurityGroups(Consumer<AwsDmsReplicationInstanceVpcSecurityGroupsDetails.Builder> ... var1);
    }
}

