/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsResponse;
import software.amazon.awssdk.services.securityhub.model.StandardsControl;

public class DescribeStandardsControlsPublisher
implements SdkPublisher<DescribeStandardsControlsResponse> {
    private final SecurityHubAsyncClient client;
    private final DescribeStandardsControlsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeStandardsControlsPublisher(SecurityHubAsyncClient client, DescribeStandardsControlsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeStandardsControlsPublisher(SecurityHubAsyncClient client, DescribeStandardsControlsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeStandardsControlsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeStandardsControlsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StandardsControl> controls() {
        Function<DescribeStandardsControlsResponse, Iterator> getIterator = response -> {
            if (response != null && response.controls() != null) {
                return response.controls().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeStandardsControlsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeStandardsControlsResponseFetcher
    implements AsyncPageFetcher<DescribeStandardsControlsResponse> {
        private DescribeStandardsControlsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStandardsControlsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeStandardsControlsResponse> nextPage(DescribeStandardsControlsResponse previousPage) {
            if (previousPage == null) {
                return DescribeStandardsControlsPublisher.this.client.describeStandardsControls(DescribeStandardsControlsPublisher.this.firstRequest);
            }
            return DescribeStandardsControlsPublisher.this.client.describeStandardsControls((DescribeStandardsControlsRequest)((Object)DescribeStandardsControlsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

