/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.RuleStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomationRulesMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomationRulesMetadata> {
    private static final SdkField<String> RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleArn").getter(AutomationRulesMetadata.getter(AutomationRulesMetadata::ruleArn)).setter(AutomationRulesMetadata.setter(Builder::ruleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArn").build()}).build();
    private static final SdkField<String> RULE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleStatus").getter(AutomationRulesMetadata.getter(AutomationRulesMetadata::ruleStatusAsString)).setter(AutomationRulesMetadata.setter(Builder::ruleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleStatus").build()}).build();
    private static final SdkField<Integer> RULE_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RuleOrder").getter(AutomationRulesMetadata.getter(AutomationRulesMetadata::ruleOrder)).setter(AutomationRulesMetadata.setter(Builder::ruleOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleOrder").build()}).build();
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleName").getter(AutomationRulesMetadata.getter(AutomationRulesMetadata::ruleName)).setter(AutomationRulesMetadata.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AutomationRulesMetadata.getter(AutomationRulesMetadata::description)).setter(AutomationRulesMetadata.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> IS_TERMINAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsTerminal").getter(AutomationRulesMetadata.getter(AutomationRulesMetadata::isTerminal)).setter(AutomationRulesMetadata.setter(Builder::isTerminal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTerminal").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(AutomationRulesMetadata.getter(AutomationRulesMetadata::createdAt)).setter(AutomationRulesMetadata.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(AutomationRulesMetadata.getter(AutomationRulesMetadata::updatedAt)).setter(AutomationRulesMetadata.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(AutomationRulesMetadata.getter(AutomationRulesMetadata::createdBy)).setter(AutomationRulesMetadata.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ARN_FIELD, RULE_STATUS_FIELD, RULE_ORDER_FIELD, RULE_NAME_FIELD, DESCRIPTION_FIELD, IS_TERMINAL_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, CREATED_BY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ruleArn;
    private final String ruleStatus;
    private final Integer ruleOrder;
    private final String ruleName;
    private final String description;
    private final Boolean isTerminal;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String createdBy;

    private AutomationRulesMetadata(BuilderImpl builder) {
        this.ruleArn = builder.ruleArn;
        this.ruleStatus = builder.ruleStatus;
        this.ruleOrder = builder.ruleOrder;
        this.ruleName = builder.ruleName;
        this.description = builder.description;
        this.isTerminal = builder.isTerminal;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.createdBy = builder.createdBy;
    }

    public final String ruleArn() {
        return this.ruleArn;
    }

    public final RuleStatus ruleStatus() {
        return RuleStatus.fromValue(this.ruleStatus);
    }

    public final String ruleStatusAsString() {
        return this.ruleStatus;
    }

    public final Integer ruleOrder() {
        return this.ruleOrder;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean isTerminal() {
        return this.isTerminal;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTerminal());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationRulesMetadata)) {
            return false;
        }
        AutomationRulesMetadata other = (AutomationRulesMetadata)obj;
        return Objects.equals(this.ruleArn(), other.ruleArn()) && Objects.equals(this.ruleStatusAsString(), other.ruleStatusAsString()) && Objects.equals(this.ruleOrder(), other.ruleOrder()) && Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.isTerminal(), other.isTerminal()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.createdBy(), other.createdBy());
    }

    public final String toString() {
        return ToString.builder((String)"AutomationRulesMetadata").add("RuleArn", (Object)this.ruleArn()).add("RuleStatus", (Object)this.ruleStatusAsString()).add("RuleOrder", (Object)this.ruleOrder()).add("RuleName", (Object)this.ruleName()).add("Description", (Object)this.description()).add("IsTerminal", (Object)this.isTerminal()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("CreatedBy", (Object)this.createdBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleArn": {
                return Optional.ofNullable(clazz.cast(this.ruleArn()));
            }
            case "RuleStatus": {
                return Optional.ofNullable(clazz.cast(this.ruleStatusAsString()));
            }
            case "RuleOrder": {
                return Optional.ofNullable(clazz.cast(this.ruleOrder()));
            }
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "IsTerminal": {
                return Optional.ofNullable(clazz.cast(this.isTerminal()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutomationRulesMetadata, T> g) {
        return obj -> g.apply((AutomationRulesMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleArn;
        private String ruleStatus;
        private Integer ruleOrder;
        private String ruleName;
        private String description;
        private Boolean isTerminal;
        private Instant createdAt;
        private Instant updatedAt;
        private String createdBy;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationRulesMetadata model) {
            this.ruleArn(model.ruleArn);
            this.ruleStatus(model.ruleStatus);
            this.ruleOrder(model.ruleOrder);
            this.ruleName(model.ruleName);
            this.description(model.description);
            this.isTerminal(model.isTerminal);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.createdBy(model.createdBy);
        }

        public final String getRuleArn() {
            return this.ruleArn;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final String getRuleStatus() {
            return this.ruleStatus;
        }

        public final void setRuleStatus(String ruleStatus) {
            this.ruleStatus = ruleStatus;
        }

        @Override
        public final Builder ruleStatus(String ruleStatus) {
            this.ruleStatus = ruleStatus;
            return this;
        }

        @Override
        public final Builder ruleStatus(RuleStatus ruleStatus) {
            this.ruleStatus(ruleStatus == null ? null : ruleStatus.toString());
            return this;
        }

        public final Integer getRuleOrder() {
            return this.ruleOrder;
        }

        public final void setRuleOrder(Integer ruleOrder) {
            this.ruleOrder = ruleOrder;
        }

        @Override
        public final Builder ruleOrder(Integer ruleOrder) {
            this.ruleOrder = ruleOrder;
            return this;
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getIsTerminal() {
            return this.isTerminal;
        }

        public final void setIsTerminal(Boolean isTerminal) {
            this.isTerminal = isTerminal;
        }

        @Override
        public final Builder isTerminal(Boolean isTerminal) {
            this.isTerminal = isTerminal;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public AutomationRulesMetadata build() {
            return new AutomationRulesMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomationRulesMetadata> {
        public Builder ruleArn(String var1);

        public Builder ruleStatus(String var1);

        public Builder ruleStatus(RuleStatus var1);

        public Builder ruleOrder(Integer var1);

        public Builder ruleName(String var1);

        public Builder description(String var1);

        public Builder isTerminal(Boolean var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder createdBy(String var1);
    }
}

