/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.AssociationType;
import software.amazon.awssdk.services.securityhub.model.ConfigurationPolicyAssociationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociationFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssociationFilters> {
    private static final SdkField<String> CONFIGURATION_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationPolicyId").getter(AssociationFilters.getter(AssociationFilters::configurationPolicyId)).setter(AssociationFilters.setter(Builder::configurationPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationPolicyId").build()}).build();
    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationType").getter(AssociationFilters.getter(AssociationFilters::associationTypeAsString)).setter(AssociationFilters.setter(Builder::associationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationType").build()}).build();
    private static final SdkField<String> ASSOCIATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationStatus").getter(AssociationFilters.getter(AssociationFilters::associationStatusAsString)).setter(AssociationFilters.setter(Builder::associationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_POLICY_ID_FIELD, ASSOCIATION_TYPE_FIELD, ASSOCIATION_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String configurationPolicyId;
    private final String associationType;
    private final String associationStatus;

    private AssociationFilters(BuilderImpl builder) {
        this.configurationPolicyId = builder.configurationPolicyId;
        this.associationType = builder.associationType;
        this.associationStatus = builder.associationStatus;
    }

    public final String configurationPolicyId() {
        return this.configurationPolicyId;
    }

    public final AssociationType associationType() {
        return AssociationType.fromValue(this.associationType);
    }

    public final String associationTypeAsString() {
        return this.associationType;
    }

    public final ConfigurationPolicyAssociationStatus associationStatus() {
        return ConfigurationPolicyAssociationStatus.fromValue(this.associationStatus);
    }

    public final String associationStatusAsString() {
        return this.associationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationFilters)) {
            return false;
        }
        AssociationFilters other = (AssociationFilters)obj;
        return Objects.equals(this.configurationPolicyId(), other.configurationPolicyId()) && Objects.equals(this.associationTypeAsString(), other.associationTypeAsString()) && Objects.equals(this.associationStatusAsString(), other.associationStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AssociationFilters").add("ConfigurationPolicyId", (Object)this.configurationPolicyId()).add("AssociationType", (Object)this.associationTypeAsString()).add("AssociationStatus", (Object)this.associationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationPolicyId": {
                return Optional.ofNullable(clazz.cast(this.configurationPolicyId()));
            }
            case "AssociationType": {
                return Optional.ofNullable(clazz.cast(this.associationTypeAsString()));
            }
            case "AssociationStatus": {
                return Optional.ofNullable(clazz.cast(this.associationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociationFilters, T> g) {
        return obj -> g.apply((AssociationFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configurationPolicyId;
        private String associationType;
        private String associationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationFilters model) {
            this.configurationPolicyId(model.configurationPolicyId);
            this.associationType(model.associationType);
            this.associationStatus(model.associationStatus);
        }

        public final String getConfigurationPolicyId() {
            return this.configurationPolicyId;
        }

        public final void setConfigurationPolicyId(String configurationPolicyId) {
            this.configurationPolicyId = configurationPolicyId;
        }

        @Override
        public final Builder configurationPolicyId(String configurationPolicyId) {
            this.configurationPolicyId = configurationPolicyId;
            return this;
        }

        public final String getAssociationType() {
            return this.associationType;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        @Override
        public final Builder associationType(AssociationType associationType) {
            this.associationType(associationType == null ? null : associationType.toString());
            return this;
        }

        public final String getAssociationStatus() {
            return this.associationStatus;
        }

        public final void setAssociationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
        }

        @Override
        public final Builder associationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        @Override
        public final Builder associationStatus(ConfigurationPolicyAssociationStatus associationStatus) {
            this.associationStatus(associationStatus == null ? null : associationStatus.toString());
            return this;
        }

        public AssociationFilters build() {
            return new AssociationFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssociationFilters> {
        public Builder configurationPolicyId(String var1);

        public Builder associationType(String var1);

        public Builder associationType(AssociationType var1);

        public Builder associationStatus(String var1);

        public Builder associationStatus(ConfigurationPolicyAssociationStatus var1);
    }
}

