/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.AssociationType;
import software.amazon.awssdk.services.securityhub.model.ConfigurationPolicyAssociationStatus;
import software.amazon.awssdk.services.securityhub.model.TargetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationPolicyAssociationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationPolicyAssociationSummary> {
    private static final SdkField<String> CONFIGURATION_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationPolicyId").getter(ConfigurationPolicyAssociationSummary.getter(ConfigurationPolicyAssociationSummary::configurationPolicyId)).setter(ConfigurationPolicyAssociationSummary.setter(Builder::configurationPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationPolicyId").build()}).build();
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetId").getter(ConfigurationPolicyAssociationSummary.getter(ConfigurationPolicyAssociationSummary::targetId)).setter(ConfigurationPolicyAssociationSummary.setter(Builder::targetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()}).build();
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetType").getter(ConfigurationPolicyAssociationSummary.getter(ConfigurationPolicyAssociationSummary::targetTypeAsString)).setter(ConfigurationPolicyAssociationSummary.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()}).build();
    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationType").getter(ConfigurationPolicyAssociationSummary.getter(ConfigurationPolicyAssociationSummary::associationTypeAsString)).setter(ConfigurationPolicyAssociationSummary.setter(Builder::associationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationType").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(ConfigurationPolicyAssociationSummary.getter(ConfigurationPolicyAssociationSummary::updatedAt)).setter(ConfigurationPolicyAssociationSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ASSOCIATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationStatus").getter(ConfigurationPolicyAssociationSummary.getter(ConfigurationPolicyAssociationSummary::associationStatusAsString)).setter(ConfigurationPolicyAssociationSummary.setter(Builder::associationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationStatus").build()}).build();
    private static final SdkField<String> ASSOCIATION_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationStatusMessage").getter(ConfigurationPolicyAssociationSummary.getter(ConfigurationPolicyAssociationSummary::associationStatusMessage)).setter(ConfigurationPolicyAssociationSummary.setter(Builder::associationStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationStatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_POLICY_ID_FIELD, TARGET_ID_FIELD, TARGET_TYPE_FIELD, ASSOCIATION_TYPE_FIELD, UPDATED_AT_FIELD, ASSOCIATION_STATUS_FIELD, ASSOCIATION_STATUS_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String configurationPolicyId;
    private final String targetId;
    private final String targetType;
    private final String associationType;
    private final Instant updatedAt;
    private final String associationStatus;
    private final String associationStatusMessage;

    private ConfigurationPolicyAssociationSummary(BuilderImpl builder) {
        this.configurationPolicyId = builder.configurationPolicyId;
        this.targetId = builder.targetId;
        this.targetType = builder.targetType;
        this.associationType = builder.associationType;
        this.updatedAt = builder.updatedAt;
        this.associationStatus = builder.associationStatus;
        this.associationStatusMessage = builder.associationStatusMessage;
    }

    public final String configurationPolicyId() {
        return this.configurationPolicyId;
    }

    public final String targetId() {
        return this.targetId;
    }

    public final TargetType targetType() {
        return TargetType.fromValue(this.targetType);
    }

    public final String targetTypeAsString() {
        return this.targetType;
    }

    public final AssociationType associationType() {
        return AssociationType.fromValue(this.associationType);
    }

    public final String associationTypeAsString() {
        return this.associationType;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final ConfigurationPolicyAssociationStatus associationStatus() {
        return ConfigurationPolicyAssociationStatus.fromValue(this.associationStatus);
    }

    public final String associationStatusAsString() {
        return this.associationStatus;
    }

    public final String associationStatusMessage() {
        return this.associationStatusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationStatusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationPolicyAssociationSummary)) {
            return false;
        }
        ConfigurationPolicyAssociationSummary other = (ConfigurationPolicyAssociationSummary)obj;
        return Objects.equals(this.configurationPolicyId(), other.configurationPolicyId()) && Objects.equals(this.targetId(), other.targetId()) && Objects.equals(this.targetTypeAsString(), other.targetTypeAsString()) && Objects.equals(this.associationTypeAsString(), other.associationTypeAsString()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.associationStatusAsString(), other.associationStatusAsString()) && Objects.equals(this.associationStatusMessage(), other.associationStatusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationPolicyAssociationSummary").add("ConfigurationPolicyId", (Object)this.configurationPolicyId()).add("TargetId", (Object)this.targetId()).add("TargetType", (Object)this.targetTypeAsString()).add("AssociationType", (Object)this.associationTypeAsString()).add("UpdatedAt", (Object)this.updatedAt()).add("AssociationStatus", (Object)this.associationStatusAsString()).add("AssociationStatusMessage", (Object)this.associationStatusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationPolicyId": {
                return Optional.ofNullable(clazz.cast(this.configurationPolicyId()));
            }
            case "TargetId": {
                return Optional.ofNullable(clazz.cast(this.targetId()));
            }
            case "TargetType": {
                return Optional.ofNullable(clazz.cast(this.targetTypeAsString()));
            }
            case "AssociationType": {
                return Optional.ofNullable(clazz.cast(this.associationTypeAsString()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "AssociationStatus": {
                return Optional.ofNullable(clazz.cast(this.associationStatusAsString()));
            }
            case "AssociationStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.associationStatusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationPolicyAssociationSummary, T> g) {
        return obj -> g.apply((ConfigurationPolicyAssociationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configurationPolicyId;
        private String targetId;
        private String targetType;
        private String associationType;
        private Instant updatedAt;
        private String associationStatus;
        private String associationStatusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationPolicyAssociationSummary model) {
            this.configurationPolicyId(model.configurationPolicyId);
            this.targetId(model.targetId);
            this.targetType(model.targetType);
            this.associationType(model.associationType);
            this.updatedAt(model.updatedAt);
            this.associationStatus(model.associationStatus);
            this.associationStatusMessage(model.associationStatusMessage);
        }

        public final String getConfigurationPolicyId() {
            return this.configurationPolicyId;
        }

        public final void setConfigurationPolicyId(String configurationPolicyId) {
            this.configurationPolicyId = configurationPolicyId;
        }

        @Override
        public final Builder configurationPolicyId(String configurationPolicyId) {
            this.configurationPolicyId = configurationPolicyId;
            return this;
        }

        public final String getTargetId() {
            return this.targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getTargetType() {
            return this.targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(TargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final String getAssociationType() {
            return this.associationType;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        @Override
        public final Builder associationType(AssociationType associationType) {
            this.associationType(associationType == null ? null : associationType.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getAssociationStatus() {
            return this.associationStatus;
        }

        public final void setAssociationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
        }

        @Override
        public final Builder associationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        @Override
        public final Builder associationStatus(ConfigurationPolicyAssociationStatus associationStatus) {
            this.associationStatus(associationStatus == null ? null : associationStatus.toString());
            return this;
        }

        public final String getAssociationStatusMessage() {
            return this.associationStatusMessage;
        }

        public final void setAssociationStatusMessage(String associationStatusMessage) {
            this.associationStatusMessage = associationStatusMessage;
        }

        @Override
        public final Builder associationStatusMessage(String associationStatusMessage) {
            this.associationStatusMessage = associationStatusMessage;
            return this;
        }

        public ConfigurationPolicyAssociationSummary build() {
            return new ConfigurationPolicyAssociationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationPolicyAssociationSummary> {
        public Builder configurationPolicyId(String var1);

        public Builder targetId(String var1);

        public Builder targetType(String var1);

        public Builder targetType(TargetType var1);

        public Builder associationType(String var1);

        public Builder associationType(AssociationType var1);

        public Builder updatedAt(Instant var1);

        public Builder associationStatus(String var1);

        public Builder associationStatus(ConfigurationPolicyAssociationStatus var1);

        public Builder associationStatusMessage(String var1);
    }
}

