/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.AwsS3AccessPointVpcConfigurationDetails;
import software.amazon.awssdk.services.securityhub.model.AwsS3AccountPublicAccessBlockDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsS3AccessPointDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsS3AccessPointDetails> {
    private static final SdkField<String> ACCESS_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessPointArn").getter(AwsS3AccessPointDetails.getter(AwsS3AccessPointDetails::accessPointArn)).setter(AwsS3AccessPointDetails.setter(Builder::accessPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPointArn").build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alias").getter(AwsS3AccessPointDetails.getter(AwsS3AccessPointDetails::alias)).setter(AwsS3AccessPointDetails.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()}).build();
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Bucket").getter(AwsS3AccessPointDetails.getter(AwsS3AccessPointDetails::bucket)).setter(AwsS3AccessPointDetails.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").build()}).build();
    private static final SdkField<String> BUCKET_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketAccountId").getter(AwsS3AccessPointDetails.getter(AwsS3AccessPointDetails::bucketAccountId)).setter(AwsS3AccessPointDetails.setter(Builder::bucketAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketAccountId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AwsS3AccessPointDetails.getter(AwsS3AccessPointDetails::name)).setter(AwsS3AccessPointDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> NETWORK_ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkOrigin").getter(AwsS3AccessPointDetails.getter(AwsS3AccessPointDetails::networkOrigin)).setter(AwsS3AccessPointDetails.setter(Builder::networkOrigin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkOrigin").build()}).build();
    private static final SdkField<AwsS3AccountPublicAccessBlockDetails> PUBLIC_ACCESS_BLOCK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PublicAccessBlockConfiguration").getter(AwsS3AccessPointDetails.getter(AwsS3AccessPointDetails::publicAccessBlockConfiguration)).setter(AwsS3AccessPointDetails.setter(Builder::publicAccessBlockConfiguration)).constructor(AwsS3AccountPublicAccessBlockDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicAccessBlockConfiguration").build()}).build();
    private static final SdkField<AwsS3AccessPointVpcConfigurationDetails> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfiguration").getter(AwsS3AccessPointDetails.getter(AwsS3AccessPointDetails::vpcConfiguration)).setter(AwsS3AccessPointDetails.setter(Builder::vpcConfiguration)).constructor(AwsS3AccessPointVpcConfigurationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POINT_ARN_FIELD, ALIAS_FIELD, BUCKET_FIELD, BUCKET_ACCOUNT_ID_FIELD, NAME_FIELD, NETWORK_ORIGIN_FIELD, PUBLIC_ACCESS_BLOCK_CONFIGURATION_FIELD, VPC_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accessPointArn;
    private final String alias;
    private final String bucket;
    private final String bucketAccountId;
    private final String name;
    private final String networkOrigin;
    private final AwsS3AccountPublicAccessBlockDetails publicAccessBlockConfiguration;
    private final AwsS3AccessPointVpcConfigurationDetails vpcConfiguration;

    private AwsS3AccessPointDetails(BuilderImpl builder) {
        this.accessPointArn = builder.accessPointArn;
        this.alias = builder.alias;
        this.bucket = builder.bucket;
        this.bucketAccountId = builder.bucketAccountId;
        this.name = builder.name;
        this.networkOrigin = builder.networkOrigin;
        this.publicAccessBlockConfiguration = builder.publicAccessBlockConfiguration;
        this.vpcConfiguration = builder.vpcConfiguration;
    }

    public final String accessPointArn() {
        return this.accessPointArn;
    }

    public final String alias() {
        return this.alias;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final String bucketAccountId() {
        return this.bucketAccountId;
    }

    public final String name() {
        return this.name;
    }

    public final String networkOrigin() {
        return this.networkOrigin;
    }

    public final AwsS3AccountPublicAccessBlockDetails publicAccessBlockConfiguration() {
        return this.publicAccessBlockConfiguration;
    }

    public final AwsS3AccessPointVpcConfigurationDetails vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkOrigin());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicAccessBlockConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3AccessPointDetails)) {
            return false;
        }
        AwsS3AccessPointDetails other = (AwsS3AccessPointDetails)obj;
        return Objects.equals(this.accessPointArn(), other.accessPointArn()) && Objects.equals(this.alias(), other.alias()) && Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.bucketAccountId(), other.bucketAccountId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.networkOrigin(), other.networkOrigin()) && Objects.equals(this.publicAccessBlockConfiguration(), other.publicAccessBlockConfiguration()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"AwsS3AccessPointDetails").add("AccessPointArn", (Object)this.accessPointArn()).add("Alias", (Object)this.alias()).add("Bucket", (Object)this.bucket()).add("BucketAccountId", (Object)this.bucketAccountId()).add("Name", (Object)this.name()).add("NetworkOrigin", (Object)this.networkOrigin()).add("PublicAccessBlockConfiguration", (Object)this.publicAccessBlockConfiguration()).add("VpcConfiguration", (Object)this.vpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessPointArn": {
                return Optional.ofNullable(clazz.cast(this.accessPointArn()));
            }
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "BucketAccountId": {
                return Optional.ofNullable(clazz.cast(this.bucketAccountId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "NetworkOrigin": {
                return Optional.ofNullable(clazz.cast(this.networkOrigin()));
            }
            case "PublicAccessBlockConfiguration": {
                return Optional.ofNullable(clazz.cast(this.publicAccessBlockConfiguration()));
            }
            case "VpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsS3AccessPointDetails, T> g) {
        return obj -> g.apply((AwsS3AccessPointDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessPointArn;
        private String alias;
        private String bucket;
        private String bucketAccountId;
        private String name;
        private String networkOrigin;
        private AwsS3AccountPublicAccessBlockDetails publicAccessBlockConfiguration;
        private AwsS3AccessPointVpcConfigurationDetails vpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3AccessPointDetails model) {
            this.accessPointArn(model.accessPointArn);
            this.alias(model.alias);
            this.bucket(model.bucket);
            this.bucketAccountId(model.bucketAccountId);
            this.name(model.name);
            this.networkOrigin(model.networkOrigin);
            this.publicAccessBlockConfiguration(model.publicAccessBlockConfiguration);
            this.vpcConfiguration(model.vpcConfiguration);
        }

        public final String getAccessPointArn() {
            return this.accessPointArn;
        }

        public final void setAccessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
        }

        @Override
        public final Builder accessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
            return this;
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getBucketAccountId() {
            return this.bucketAccountId;
        }

        public final void setBucketAccountId(String bucketAccountId) {
            this.bucketAccountId = bucketAccountId;
        }

        @Override
        public final Builder bucketAccountId(String bucketAccountId) {
            this.bucketAccountId = bucketAccountId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNetworkOrigin() {
            return this.networkOrigin;
        }

        public final void setNetworkOrigin(String networkOrigin) {
            this.networkOrigin = networkOrigin;
        }

        @Override
        public final Builder networkOrigin(String networkOrigin) {
            this.networkOrigin = networkOrigin;
            return this;
        }

        public final AwsS3AccountPublicAccessBlockDetails.Builder getPublicAccessBlockConfiguration() {
            return this.publicAccessBlockConfiguration != null ? this.publicAccessBlockConfiguration.toBuilder() : null;
        }

        public final void setPublicAccessBlockConfiguration(AwsS3AccountPublicAccessBlockDetails.BuilderImpl publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration != null ? publicAccessBlockConfiguration.build() : null;
        }

        @Override
        public final Builder publicAccessBlockConfiguration(AwsS3AccountPublicAccessBlockDetails publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration;
            return this;
        }

        public final AwsS3AccessPointVpcConfigurationDetails.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(AwsS3AccessPointVpcConfigurationDetails.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(AwsS3AccessPointVpcConfigurationDetails vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public AwsS3AccessPointDetails build() {
            return new AwsS3AccessPointDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsS3AccessPointDetails> {
        public Builder accessPointArn(String var1);

        public Builder alias(String var1);

        public Builder bucket(String var1);

        public Builder bucketAccountId(String var1);

        public Builder name(String var1);

        public Builder networkOrigin(String var1);

        public Builder publicAccessBlockConfiguration(AwsS3AccountPublicAccessBlockDetails var1);

        default public Builder publicAccessBlockConfiguration(Consumer<AwsS3AccountPublicAccessBlockDetails.Builder> publicAccessBlockConfiguration) {
            return this.publicAccessBlockConfiguration((AwsS3AccountPublicAccessBlockDetails)((AwsS3AccountPublicAccessBlockDetails.Builder)AwsS3AccountPublicAccessBlockDetails.builder().applyMutation(publicAccessBlockConfiguration)).build());
        }

        public Builder vpcConfiguration(AwsS3AccessPointVpcConfigurationDetails var1);

        default public Builder vpcConfiguration(Consumer<AwsS3AccessPointVpcConfigurationDetails.Builder> vpcConfiguration) {
            return this.vpcConfiguration((AwsS3AccessPointVpcConfigurationDetails)((AwsS3AccessPointVpcConfigurationDetails.Builder)AwsS3AccessPointVpcConfigurationDetails.builder().applyMutation(vpcConfiguration)).build());
        }
    }
}

