/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.AutoEnableStandards;
import software.amazon.awssdk.services.securityhub.model.OrganizationConfiguration;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOrganizationConfigurationResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, DescribeOrganizationConfigurationResponse> {
    private static final SdkField<Boolean> AUTO_ENABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoEnable").getter(DescribeOrganizationConfigurationResponse.getter(DescribeOrganizationConfigurationResponse::autoEnable)).setter(DescribeOrganizationConfigurationResponse.setter(Builder::autoEnable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEnable").build()}).build();
    private static final SdkField<Boolean> MEMBER_ACCOUNT_LIMIT_REACHED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MemberAccountLimitReached").getter(DescribeOrganizationConfigurationResponse.getter(DescribeOrganizationConfigurationResponse::memberAccountLimitReached)).setter(DescribeOrganizationConfigurationResponse.setter(Builder::memberAccountLimitReached)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberAccountLimitReached").build()}).build();
    private static final SdkField<String> AUTO_ENABLE_STANDARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoEnableStandards").getter(DescribeOrganizationConfigurationResponse.getter(DescribeOrganizationConfigurationResponse::autoEnableStandardsAsString)).setter(DescribeOrganizationConfigurationResponse.setter(Builder::autoEnableStandards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEnableStandards").build()}).build();
    private static final SdkField<OrganizationConfiguration> ORGANIZATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OrganizationConfiguration").getter(DescribeOrganizationConfigurationResponse.getter(DescribeOrganizationConfigurationResponse::organizationConfiguration)).setter(DescribeOrganizationConfigurationResponse.setter(Builder::organizationConfiguration)).constructor(OrganizationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ENABLE_FIELD, MEMBER_ACCOUNT_LIMIT_REACHED_FIELD, AUTO_ENABLE_STANDARDS_FIELD, ORGANIZATION_CONFIGURATION_FIELD));
    private final Boolean autoEnable;
    private final Boolean memberAccountLimitReached;
    private final String autoEnableStandards;
    private final OrganizationConfiguration organizationConfiguration;

    private DescribeOrganizationConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.autoEnable = builder.autoEnable;
        this.memberAccountLimitReached = builder.memberAccountLimitReached;
        this.autoEnableStandards = builder.autoEnableStandards;
        this.organizationConfiguration = builder.organizationConfiguration;
    }

    public final Boolean autoEnable() {
        return this.autoEnable;
    }

    public final Boolean memberAccountLimitReached() {
        return this.memberAccountLimitReached;
    }

    public final AutoEnableStandards autoEnableStandards() {
        return AutoEnableStandards.fromValue(this.autoEnableStandards);
    }

    public final String autoEnableStandardsAsString() {
        return this.autoEnableStandards;
    }

    public final OrganizationConfiguration organizationConfiguration() {
        return this.organizationConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEnable());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberAccountLimitReached());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEnableStandardsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationConfigurationResponse)) {
            return false;
        }
        DescribeOrganizationConfigurationResponse other = (DescribeOrganizationConfigurationResponse)((Object)obj);
        return Objects.equals(this.autoEnable(), other.autoEnable()) && Objects.equals(this.memberAccountLimitReached(), other.memberAccountLimitReached()) && Objects.equals(this.autoEnableStandardsAsString(), other.autoEnableStandardsAsString()) && Objects.equals(this.organizationConfiguration(), other.organizationConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeOrganizationConfigurationResponse").add("AutoEnable", (Object)this.autoEnable()).add("MemberAccountLimitReached", (Object)this.memberAccountLimitReached()).add("AutoEnableStandards", (Object)this.autoEnableStandardsAsString()).add("OrganizationConfiguration", (Object)this.organizationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoEnable": {
                return Optional.ofNullable(clazz.cast(this.autoEnable()));
            }
            case "MemberAccountLimitReached": {
                return Optional.ofNullable(clazz.cast(this.memberAccountLimitReached()));
            }
            case "AutoEnableStandards": {
                return Optional.ofNullable(clazz.cast(this.autoEnableStandardsAsString()));
            }
            case "OrganizationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.organizationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private Boolean autoEnable;
        private Boolean memberAccountLimitReached;
        private String autoEnableStandards;
        private OrganizationConfiguration organizationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationConfigurationResponse model) {
            super(model);
            this.autoEnable(model.autoEnable);
            this.memberAccountLimitReached(model.memberAccountLimitReached);
            this.autoEnableStandards(model.autoEnableStandards);
            this.organizationConfiguration(model.organizationConfiguration);
        }

        public final Boolean getAutoEnable() {
            return this.autoEnable;
        }

        public final void setAutoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
        }

        @Override
        public final Builder autoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
            return this;
        }

        public final Boolean getMemberAccountLimitReached() {
            return this.memberAccountLimitReached;
        }

        public final void setMemberAccountLimitReached(Boolean memberAccountLimitReached) {
            this.memberAccountLimitReached = memberAccountLimitReached;
        }

        @Override
        public final Builder memberAccountLimitReached(Boolean memberAccountLimitReached) {
            this.memberAccountLimitReached = memberAccountLimitReached;
            return this;
        }

        public final String getAutoEnableStandards() {
            return this.autoEnableStandards;
        }

        public final void setAutoEnableStandards(String autoEnableStandards) {
            this.autoEnableStandards = autoEnableStandards;
        }

        @Override
        public final Builder autoEnableStandards(String autoEnableStandards) {
            this.autoEnableStandards = autoEnableStandards;
            return this;
        }

        @Override
        public final Builder autoEnableStandards(AutoEnableStandards autoEnableStandards) {
            this.autoEnableStandards(autoEnableStandards == null ? null : autoEnableStandards.toString());
            return this;
        }

        public final OrganizationConfiguration.Builder getOrganizationConfiguration() {
            return this.organizationConfiguration != null ? this.organizationConfiguration.toBuilder() : null;
        }

        public final void setOrganizationConfiguration(OrganizationConfiguration.BuilderImpl organizationConfiguration) {
            this.organizationConfiguration = organizationConfiguration != null ? organizationConfiguration.build() : null;
        }

        @Override
        public final Builder organizationConfiguration(OrganizationConfiguration organizationConfiguration) {
            this.organizationConfiguration = organizationConfiguration;
            return this;
        }

        @Override
        public DescribeOrganizationConfigurationResponse build() {
            return new DescribeOrganizationConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOrganizationConfigurationResponse> {
        public Builder autoEnable(Boolean var1);

        public Builder memberAccountLimitReached(Boolean var1);

        public Builder autoEnableStandards(String var1);

        public Builder autoEnableStandards(AutoEnableStandards var1);

        public Builder organizationConfiguration(OrganizationConfiguration var1);

        default public Builder organizationConfiguration(Consumer<OrganizationConfiguration.Builder> organizationConfiguration) {
            return this.organizationConfiguration((OrganizationConfiguration)((OrganizationConfiguration.Builder)OrganizationConfiguration.builder().applyMutation(organizationConfiguration)).build());
        }
    }
}

